package com.ejianc.business.signaturemanage.service;

import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;

import java.util.List;

/**
 * @author baipengyan
 * @date 2022/6/9
 * @description 异步通知接口
 */
public interface IAsyncInformService {

	/**
	 * 异步通知业务系统签章状态
	 *
	 * @param billType  单据类型
	 * @param billId    单据id
	 * @param referCode 唯一标识
	 * @param status    签章状态
	 * @param authority 请求头上下文
	 */
	void informBusinessSystem(String billType, Long billId, String referCode, int status, String authority);

	/**
	 * 异步消息通知
	 *
	 * @param channels     消息渠道
	 * @param operators    签署动作
	 * @param contractId   PM系统合同id
	 * @param billCode     单据编号
	 * @param contractName 合同名称
	 */
	void informMessage(List<String> channels, List<SignMgrSignatoryEntity> operators, Long contractId, String billCode, String contractName, String authority);
}
