package com.ejianc.business.signaturemanage.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.signaturemanage.bean.SignatureSettingEntity;
import com.ejianc.business.signaturemanage.service.ISignatureSettingService;
import com.ejianc.business.signaturemanage.service.ISignatureSettingSubService;
import com.ejianc.business.signaturemanage.vo.SignatureSettingVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author:刘家乐
 * @version: 1
 * @document:
 */
@Controller
@RequestMapping("signatureSetting")
public class SignatureSettingController implements Serializable {
    private static final long serialVersionUID = 1L;
    /**此处需要根据实际修改*/
    private static final String BILL_CODE = "LJL_SIGNATURE_SET";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISignatureSettingService service;
    @Autowired
    private ISignatureSettingSubService subService;
    @Autowired
    private IOrgApi orgApi;


    @RequestMapping(value = "/saveOrUpdate",method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SignatureSettingVO> saveOrUpdate(@RequestBody SignatureSettingVO settingVO){
        return service.saveOrUpdateSignature(settingVO);
    }
    @ResponseBody
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<SignatureSettingVO>> queryList(@RequestBody QueryParam param){
        List<Long> orgIdList = new ArrayList<>();
        // 模糊搜索配置字段示例
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("unitName");
        fuzzyFields.add("defaultSealName");
        fuzzyFields.add("createName");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        CommonResponse<List<OrgVO>> orgResp = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgResp.isSuccess()){
            IPage<SignatureSettingVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), 0);
            return CommonResponse.success("查询数表参照失败，项目组织信息查询失败！", pageData);
        }
        List<OrgVO> orgList = orgResp.getData();
        if(CollectionUtils.isNotEmpty(orgList)) {
            orgList.forEach(orgVO -> {
                orgIdList.add(orgVO.getId());
            });
            if(CollectionUtils.isNotEmpty(orgIdList)) {
                param.getParams().put("unitId", new Parameter(QueryParam.IN, orgIdList));
            }
        }
        IPage<SignatureSettingEntity> page = service.queryPage(param,false);
        for (SignatureSettingEntity s:page.getRecords()){
            s.setDefaultSealName(subService.getDefaultSealName(s.getId()));
        }
        IPage<SignatureSettingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SignatureSettingVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    @ResponseBody
    @RequestMapping(value = "/updateStatus",method = RequestMethod.POST)
    public CommonResponse<SignatureSettingVO> updateStatus(@RequestBody SignatureSettingVO settingVO){
        SignatureSettingEntity entity = service.selectById(settingVO.getId());
        entity.setEnableStatus(settingVO.getEnableStatus());
        service.saveOrUpdate(entity,false);
        return CommonResponse.success(BeanMapper.map(entity,SignatureSettingVO.class));
    }

    /**
     * 查询详情
     * @param id 请求id
     * @return 返回当前详细信息
     */
    @ResponseBody
    @RequestMapping(value = "/queryDetail",method = RequestMethod.GET)
    public CommonResponse<SignatureSettingVO> queryDetail(Long id){
        return  service.queryDetail(id);
    }

    /**
     * 发起签章 发起请求 签章设置里查询默认印章
     * @return 启用的印章
     */
    @ResponseBody
    @RequestMapping(value = "/queryDefaultSeal", method = RequestMethod.GET)
    public CommonResponse<JSONObject> queryDefaultSeal(String unitId){
        return service.queryDefaultSeal(unitId);
    }


    /**
     *  文件导出 只导出本组织的
     * @param param 无
     * @param response 当前组织签章设置
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getParams().put("unit_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getOrgId()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<SignatureSettingEntity> pageData = service.queryPage(param, false);
        if (CollectionUtils.isNotEmpty(pageData.getRecords())){
            SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");
            List<SignatureSettingVO> list = BeanMapper.mapList(pageData.getRecords(), SignatureSettingVO.class);
            for (SignatureSettingVO vo:list){
                vo.setEnableStatusStr(vo.getEnableStatus()==1?"启用":"停用");

                vo.setSealCreateTimeStr(sdf.format(vo.getSealCreateTime()));
                vo.setDefaultSealName(subService.getDefaultSealName(vo.getId()));
            }
            //todo:字段翻译等等
            Map<String, Object> beans = new HashMap<>(list.size());
            logger.error(JSONObject.toJSONString(list));
            beans.put("bean", list);
            ExcelExport.getInstance().export("签章.xlsx", beans, response);
        }
    }


}
