package com.ejianc.business.signaturemanage.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.vo.SignatureCenterVO;
import com.ejianc.framework.skeleton.template.IBaseService;

/**
 * 签章管理-签署方子表
 *
 * @author generator
 */
public interface ISignMgrSignatoryService extends IBaseService<SignMgrSignatoryEntity> {

    /**
     * 签章中心分页查询
     *
     * @param tenantId         租户ID
     * @param signatureContact 签署人手机号
     * @param jobStatus        签章状态
     * @return 签章中心分页
     */
    IPage<SignatureCenterVO> querySignCenterPage(Page<SignatureCenterVO> page,
                                                 Long tenantId,
                                                 String signatureContact,
                                                 Integer jobStatus,
                                                 String billName,
                                                 String contractName,
                                                 String projectName,
                                                 String useSealType);

}
