package com.ejianc.business.signaturemanage.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.signaturemanage.bean.ManagementEntity;
import com.ejianc.business.signaturemanage.bean.ManagementUserEntity;
import com.ejianc.business.signaturemanage.bean.SignatureSettingEntity;
import com.ejianc.business.signaturemanage.bean.SignatureSettingSubEntity;
import com.ejianc.business.signaturemanage.mapper.SignatureSettingMapper;
import com.ejianc.business.signaturemanage.service.IManagementService;
import com.ejianc.business.signaturemanage.service.IManagementUserService;
import com.ejianc.business.signaturemanage.service.ISignatureSettingService;
import com.ejianc.business.signaturemanage.service.ISignatureSettingSubService;
import com.ejianc.business.signaturemanage.vo.ManagementUserVO;
import com.ejianc.business.signaturemanage.vo.SignatureSettingSubVO;
import com.ejianc.business.signaturemanage.vo.SignatureSettingVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author:刘家乐
 * @version:
 * @document:
 */
@Service("signatureSettingService")
public class SignatureSettingServiceImpl extends BaseServiceImpl<SignatureSettingMapper, SignatureSettingEntity>
        implements ISignatureSettingService {

    /**
     * 此处需要根据实际修改
     */
    private static final String BILL_CODE = "LJL_SIGNATURE_SET";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISignatureSettingSubService subService;
    @Autowired
    private IManagementUserService userService;
    @Autowired
    private IManagementService managementService;


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<SignatureSettingVO> addNewSignature(SignatureSettingVO settingVO) {
        SignatureSettingEntity entity = BeanMapper.map(settingVO, SignatureSettingEntity.class);

        CommonResponse<String> byRuleCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if (byRuleCode.isSuccess()) {
            //实体初始化
            entity.setCode(byRuleCode.getData());
            entity.setTenantId(InvocationInfoProxy.getTenantid());
            if (StringUtils.isEmpty(entity.getCreateName())) {
                entity.setCreateName(UserContext.getUserContext().getUserName());
                entity.setCreateId(UserContext.getUserContext().getUserId());
            }
            List<SignatureSettingSubEntity> subEntityList = entity.getSettingSubVoS();
            StringBuilder s = new StringBuilder();
            for (SignatureSettingSubEntity subEntity : subEntityList) {
                s.append(subEntity.getSourceSealName());
                s.append(",");
            }
            entity.setDefaultSealName(s.toString());
        } else {
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        this.saveOrUpdate(entity, false);
        return CommonResponse.success("新增或修改单据成功", BeanMapper.map(entity, SignatureSettingVO.class));
    }

    @Override
    public CommonResponse<SignatureSettingVO> queryDetail(Long id) {
        SignatureSettingEntity entity = this.selectById(id);
        SignatureSettingVO map = BeanMapper.map(entity, SignatureSettingVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter("eq", entity.getId()));
        List<SignatureSettingSubEntity> signatureSettingSubEntities = subService.queryList(queryParam);
        List<SignatureSettingSubVO> settingSubVoS = BeanMapper.mapList(signatureSettingSubEntities, SignatureSettingSubVO.class);
        map.setSettingSubVoS(settingSubVoS);
        return CommonResponse.success("查询成功", map);
    }

    @Override
    public CommonResponse<SignatureSettingVO> saveOrUpdateSignature(SignatureSettingVO settingVO) {
        SignatureSettingEntity entity = BeanMapper.map(settingVO, SignatureSettingEntity.class);
        if (this.check(entity)) {
            if (null == entity.getId()) {
                CommonResponse<String> byRuleCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
                if (byRuleCode.isSuccess()) {
                    //实体初始化
                    entity.setCode(byRuleCode.getData());
                    entity.setTenantId(InvocationInfoProxy.getTenantid());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            } else {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("pid", new Parameter(QueryParam.EQ, entity.getId()));
                List<SignatureSettingSubEntity> signatureSettingSubEntities = subService.queryList(queryParam);
                List<Long> idList = new ArrayList<>();
                for (SignatureSettingSubEntity subEntity : signatureSettingSubEntities) {
                    idList.add(subEntity.getId());
                }
                if (!idList.isEmpty()) {
                    subService.deleteUserByIdList(idList);
                }
            }
            if (StringUtils.isEmpty(entity.getCreateName())) {
                entity.setCreateName(UserContext.getUserContext().getUserName());
                entity.setCreateId(UserContext.getUserContext().getUserId());
            }
            List<SignatureSettingSubEntity> subEntityList = entity.getSettingSubVoS();
            this.saveOrUpdate(entity, false);
            return CommonResponse.success("新增或修改单据成功", BeanMapper.map(entity, SignatureSettingVO.class));
        } else {
            return CommonResponse.error("每个组织只能有一个签章设置");
        }

    }


    public boolean check(SignatureSettingEntity entity) {
        SignatureSettingEntity settingEntity = this.getOne(new QueryWrapper<SignatureSettingEntity>().eq("unit_id", entity.getUnitId()));
        boolean check = false;

        if (null == settingEntity) {
            check = true;
        } else {
            if (null != entity.getId()) {
                if (entity.getId().equals(settingEntity.getId())) {
                    check = true;
                }
            }
        }
        return check;
    }


    @Override
    public CommonResponse<JSONObject> queryDefaultSeal(String unitId) {
        SignatureSettingEntity entity = this.getOne(
                new QueryWrapper<SignatureSettingEntity>()
                        .eq("unit_id", unitId)
                        .eq("enable_status", 1));
        QueryParam queryParam = new QueryParam();
        if (null == entity) {
            return CommonResponse.success("当前单位未设置签章", null);
        }
        queryParam.getParams().put("pid", new Parameter(QueryParam.EQ, entity.getId()));
        queryParam.getParams().put("sourceStatus", new Parameter(QueryParam.EQ, "NORMAL"));
        List<SignatureSettingSubEntity> signatureSettingSubEntities = subService.queryList(queryParam);
        List<SignatureSettingSubVO> map = BeanMapper.mapList(signatureSettingSubEntities, SignatureSettingSubVO.class);
        logger.error("map:" + JSONObject.toJSONString(map));
        if (null == map) {
            return CommonResponse.success("数据为空", null);
        }

        for (SignatureSettingSubVO subVO : map) {
            ManagementEntity managementEntity = managementService.getOne(
                    new QueryWrapper<ManagementEntity>()
                            .eq("source_seal_id", subVO.getSourceSealId()));
            QueryParam query = new QueryParam();
            query.getParams().put("pid", new Parameter(QueryParam.EQ, managementEntity.getId()));
            List<ManagementUserEntity> managementUserEntities = userService.queryList(query, false);
            List<ManagementUserVO> managementUserVOS = BeanMapper.mapList(managementUserEntities, ManagementUserVO.class);
            subVO.setUserVOS(managementUserVOS);
        }
        Map<String, List<SignatureSettingSubVO>> collect = map.stream().collect(Collectors.groupingBy(SignatureSettingSubVO::getSealType));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("orgId", entity.getUnitId());
        jsonObject.put("orgName", entity.getUnitName());
        jsonObject.put("record", map);
        return CommonResponse.success(jsonObject);
    }
}
