/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.common;

import com.ejianc.framework.core.response.CommonResponse;
import javax.validation.ConstraintViolationException;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class CommonExceptionHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public CommonResponse<String> methodArgumentNotValidExceptionHandler(MethodArgumentNotValidException e) {
        BindingResult bindingResult = e.getBindingResult();
        StringBuilder sb = new StringBuilder("\u53c2\u6570\u6821\u9a8c\u5931\u8d25:");
        for (FieldError fieldError : bindingResult.getFieldErrors()) {
            sb.append(fieldError.getField()).append("\uff1a").append(fieldError.getDefaultMessage()).append(", ");
        }
        String msg = sb.toString();
        this.logger.error("MethodArgumentNotValidException--{}", (Object)msg);
        return CommonResponse.error((String)msg);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public CommonResponse<String> constraintViolationExceptionHandler(ConstraintViolationException e) {
        this.logger.error("ConstraintViolationException--{}", (Object)e.getMessage());
        return CommonResponse.error((String)e.getMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public CommonResponse<String> illegalArgumentExceptionHandler(IllegalArgumentException e) {
        this.logger.error("IllegalArgumentException--{}", (Object)e.getMessage());
        return CommonResponse.error((String)e.getMessage());
    }

    @ExceptionHandler(value={PrivateAppException.class})
    public CommonResponse<String> privateAppExceptionHandler(PrivateAppException e) {
        this.logger.error("PrivateAppException--{}", (Object)e.getMessage());
        return CommonResponse.error((String)e.getMessage());
    }
}

