package com.ejianc.business.signaturemanage.service;

import com.ejianc.business.signaturemanage.bean.ManagementEntity;
import com.ejianc.business.signaturemanage.vo.ManagementUserVO;
import com.ejianc.business.signaturemanage.vo.ManagementVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import net.qiyuesuo.sdk.bean.company.Company;
import net.qiyuesuo.sdk.bean.seal.Seal;
import net.qiyuesuo.sdk.bean.seal.SealPermissionGroupBean;

import java.util.List;

public interface ISealManageService extends IBaseService<ManagementEntity> {

    /**
     * 公司印章列表
     *
     * @param companyId
     * @param companyName
     * @param category
     * @return
     */
    List<Seal> sealList(Long companyId, String companyName, String category);

    /**
     * 查询印章详情
     *
     * @param sealId
     * @return
     */
    Seal detail(Long sealId);

    /**
     * 获取印章图片地址
     *
     * @param sealId
     * @return
     */
    void replaceImgUrl(Long sealId, String authority, ManagementEntity entity);


    /**
     * 解析印章管理员和使用者信息
     *
     * @param sealGroup
     * @return
     */
    List<ManagementUserVO> getUsers(List<SealPermissionGroupBean> sealGroup, Boolean isAdmin);

    /**
     * 查询所有内部企业的印章列表
     *
     * @return
     */
    List<Company> companySealList();


    /**
     * 查询公司下的印章列表
     *
     * @param companyName
     * @return
     */
    List<ManagementVO> querySealsByCompanyName(String companyName);


    /**
     * 查询所有内部企业的印章列表
     *
     * @return
     */
    List<ManagementVO> queryAllSeal();

}
