package com.ejianc.business.signaturemanage.utils;

import com.ejianc.business.signaturemanage.vo.WatermarkConfigVO;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import org.springframework.stereotype.Component;

import java.time.Instant;
import java.util.ArrayList;

/**
 * @author baipengyan
 * @date 2022/5/24
 * @description 水印配置转换工具类
 */
@Component
public class WatermarkConfigConvert {

	/**
	 * 默认转换方法
	 *
	 * @param fileId     要加水印的文件id
	 * @param billId     业务id
	 * @param billCode   合同编码
	 * @param billType   单据类型编码
	 * @param sourceType 业务类型编码
	 *
	 * @return WatermarkVO 水印配置
	 */
	public WatermarkVO convert(Long fileId, Long billId, String billCode, String billType, String sourceType) {

		// 截取业务id后四位
		String bid = String.valueOf(billId);
		// 时间戳后四位
		String mil = String.valueOf(Instant.now().toEpochMilli());
		// 水印内容规则：业务id后四位_合同编码_时间戳后四位
		String content = bid.substring(bid.length() - 4) + "_" + billCode + "_" + mil.substring(mil.length() - 4);

		// 合同添加水印：默认配置
		WatermarkVO watermarkVO = new WatermarkVO();
		watermarkVO.setScheme("QI_YUE_SUO");
		watermarkVO.setFileId(fileId);
		watermarkVO.setBillId(billId);
		watermarkVO.setBillType(billType);
		watermarkVO.setSourceType(sourceType);

		ArrayList<WatermarkConfigVO> watermarks = new ArrayList<>();
		WatermarkConfigVO vo = new WatermarkConfigVO();
		vo.setType("TEXT");
		vo.setContent(content);
		vo.setImageBase64("");
		// 默认字号大小调整为16
		vo.setFontSize(16);
		vo.setColor("#999999");
		vo.setRotateAngle(30.0D);
		vo.setTransparency(0.5D);
		// 默认居中
		vo.setLocation("TILE");
		watermarks.add(vo);
		watermarkVO.setWatermarkConfigs(watermarks);

		return watermarkVO;
	}

}
