/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.enums.SignMgrSignatoryEnum;
import com.ejianc.business.signaturemanage.service.IAsyncInformService;
import com.ejianc.business.signaturemanage.service.ISignMgrSignatoryService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.google.common.base.Stopwatch;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Recover;
import org.springframework.retry.annotation.Retryable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="asyncInformService")
public class IAsyncInformServiceImpl
implements IAsyncInformService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IBillTypeApi billTypeApi;
    private final IUserApi userApi;
    private final IPushMessageApi pushMessageApi;
    private final ISignMgrSignatoryService signMgrSignatoryService;
    private final Map<String, Function<Map<String, Object>, Void>> channelMap = new HashMap<String, Function<Map<String, Object>, Void>>();
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;

    public IAsyncInformServiceImpl(IBillTypeApi billTypeApi, IUserApi userApi, IPushMessageApi pushMessageApi, ISignMgrSignatoryService signMgrSignatoryService) {
        this.billTypeApi = billTypeApi;
        this.userApi = userApi;
        this.pushMessageApi = pushMessageApi;
        this.signMgrSignatoryService = signMgrSignatoryService;
    }

    @PostConstruct
    public void channelDispatcher() {
        this.channelMap.put("sys", this::systemInformMessage);
    }

    @Override
    @Retryable(value={Exception.class}, maxAttempts=3, backoff=@Backoff(delay=2000L, multiplier=1.5), stateful=true)
    public void informBusinessSystem(String billType, Long billId, String referCode, int status, String authority) {
        Assert.hasText((String)billType, (String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)billId, (String)"\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasLength((String)referCode, (String)"\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)authority, (String)"\u8bf7\u6c42\u5934\u4e0a\u4e0b\u6587\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.logger.info("\u5f02\u6b65\u901a\u77e5\u4e1a\u52a1\u7cfb\u7edf\u7b7e\u7ae0\u72b6\u6001\uff0c\u5355\u636e\u7c7b\u578b\uff1a{}\uff0c\u5355\u636eid\uff1a{}\uff0c\u552f\u4e00\u6807\u8bc6\uff1a{}\uff0c\u7b7e\u7ae0\u72b6\u6001\uff1a{}\uff0c\u8bf7\u6c42\u5934\u4e0a\u4e0b\u6587\uff1a{}", new Object[]{billType, billId, referCode, status, authority});
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = Objects.requireNonNull(requestAttributes).getRequest();
        this.logger.info("\u5f02\u6b65\u901a\u77e5\u4e1a\u52a1\u7cfb\u7edf\u7b7e\u7ae0\u72b6\u6001\u7684authority\uff1a{}", (Object)request.getHeader("authority"));
        if (StringUtils.isBlank((CharSequence)request.getHeader("authority"))) {
            InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
            this.logger.info("informBusinessSystem-\u5f02\u6b65\u901a\u77e5\u4e1a\u52a1\u7cfb\u7edf\u7b7e\u7ae0\u72b6\u6001\u7684authority\uff1a{}", (Object)authority);
        } else {
            InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)request.getHeader("authority"));
            this.logger.info("informBusinessSystem-\u5f02\u6b65\u901a\u77e5\u4e1a\u52a1\u7cfb\u7edf\u7b7e\u7ae0\u72b6\u6001\u7684authority\uff1a{}", (Object)request.getHeader("authority"));
        }
        CommonResponse mdRefResp = this.billTypeApi.queryMetadataByBillType(billType);
        if (!mdRefResp.isSuccess() || mdRefResp.getData() == null) {
            this.logger.error("\u5f02\u6b65\u901a\u77e5\u4e1a\u52a1\u7cfb\u7edf\u7b7e\u7ae0\u72b6\u6001\uff0c\u6839\u636e\u5355\u636e\u7c7b\u578bbillType\uff1a{}\uff0c\u67e5\u8be2\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25,\u539f\u56e0\uff1a{}\uff01", (Object)billType, (Object)mdRefResp.getMsg());
            throw new BusinessException("\u5f02\u6b65\u901a\u77e5\u4e1a\u52a1\u7cfb\u7edf\u7b7e\u7ae0\u72b6\u6001\uff0c\u6839\u636e\u5355\u636e\u7c7b\u578bbillType\uff1a" + billType + "\uff0c\u67e5\u8be2\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + mdRefResp.getMsg());
        }
        String entityName = ((MdReferVO)mdRefResp.getData()).getEntityName().replace("Entity", "") + "Signature";
        String apiUrl = entityName.substring(0, 1).toLowerCase() + entityName.substring(1);
        String url = this.BASE_HOST + ((MdReferVO)mdRefResp.getData()).getProjectName() + "/" + apiUrl + "/changeStatus";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("billId", billId);
        param.put("refCode", referCode);
        param.put("status", status);
        this.logger.info("\u5f02\u6b65\u901a\u77e5\u4e1a\u52a1\u7cfb\u7edf\u7b7e\u7ae0\u72b6\u6001\uff0c\u8bf7\u6c42\u5f00\u59cb\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff01", (Object)url, (Object)JSON.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        Stopwatch start = Stopwatch.createStarted();
        String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).header("authority", authority)).body(JSON.toJSONString(param)).timeout(10000).execute().body();
        Assert.hasLength((String)response, (String)"\u5f02\u6b65\u901a\u77e5\u4e1a\u52a1\u7cfb\u7edf\u7b7e\u7ae0\u72b6\u6001\uff0c\u8bf7\u6c42\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
        this.logger.info("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edfurl-{}\uff0cparam-{}\uff0c\u7b7e\u7ae0\u72b6\u6001\u7ed3\u679c\uff1a{}", new Object[]{url, JSON.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}), response});
        CommonResponse commonResponse = (CommonResponse)JSON.parseObject((String)response, CommonResponse.class);
        if (!commonResponse.isSuccess()) {
            this.logger.error("\u5f02\u6b65\u901a\u77e5\u4e1a\u52a1\u7cfb\u7edf\u7b7e\u7ae0\u72b6\u6001\uff0c\u8bf7\u6c42\u300c\u6210\u529f\u300d\uff0c\u8fd4\u56de\u7ed3\u679c\u300c\u5931\u8d25\u300d\uff1a{}\uff01", (Object)commonResponse.getMsg());
            throw new BusinessException("\u5f02\u6b65\u901a\u77e5\u4e1a\u52a1\u7cfb\u7edf\u7b7e\u7ae0\u72b6\u6001\uff0c\u8bf7\u6c42\u300c\u6210\u529f\u300d\uff0c\u8fd4\u56de\u7ed3\u679c\u300c\u5931\u8d25\u300d\uff1a" + commonResponse.getMsg());
        }
        this.logger.info("\u5f02\u6b65\u901a\u77e5\u4e1a\u52a1\u7cfb\u7edf\u7b7e\u7ae0\u72b6\u6001\uff0c\u8bf7\u6c42\u300c\u6210\u529f\u300d\uff0c\u8fd4\u56de\u7ed3\u679c\u300c\u6210\u529f\u300d\uff0c\u8017\u65f6\u300c{}\u300d\u79d2\uff01", (Object)start.elapsed(TimeUnit.SECONDS));
    }

    @Recover
    public void informBusinessSystemRecover(Exception e, String billType, Long billId, String referCode, int status, String authority) {
        this.logger.error("\u5f02\u6b65\u901a\u77e5\u4e1a\u52a1\u7cfb\u7edf\u7b7e\u7ae0\u72b6\u6001\uff0c\u91cd\u8bd5\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570--billType\uff1a{}\uff0cbillId\uff1a{}\uff0creferCode\uff1a{}\uff0cstatus\uff1a{}\uff0cauthority\uff1a{}\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}\uff01", new Object[]{billType, billId, referCode, status, authority, e.getMessage()});
    }

    @Override
    @Async(value="attributesTask")
    @Retryable(value={Exception.class}, maxAttempts=3, backoff=@Backoff(delay=3000L, multiplier=1.5), stateful=true)
    public void informMessage(List<String> channels, List<SignMgrSignatoryEntity> operators, Long contractId, String billCode, String contractName, String authority) {
        this.logger.info("\u5f02\u6b65\u6d88\u606f\u901a\u77e5\uff0c\u8bf7\u6c42\u5f00\u59cb\uff0c\u8bf7\u6c42\u53c2\u6570--channels\uff1a{}\uff0coperators\uff1a{}\uff0ccontractId\uff1a{}\uff0cbillCode\uff1a{}\uff0ccontractName\uff1a{}", new Object[]{JSON.toJSONString(channels, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}), JSON.toJSONString(operators, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}), contractId, billCode, contractName});
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = Objects.requireNonNull(requestAttributes).getRequest();
        this.logger.info("\u5f02\u6b65\u6d88\u606f\u901a\u77e5\u7684authority\uff1a{}", (Object)request.getHeader("authority"));
        if (StringUtils.isBlank((CharSequence)request.getHeader("authority"))) {
            InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
            this.logger.info("informMessage-\u5f02\u6b65\u6d88\u606f\u901a\u77e5\u7684authority\uff1a{}", (Object)authority);
        } else {
            InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)request.getHeader("authority"));
            this.logger.info("informMessage-\u5f02\u6b65\u6d88\u606f\u901a\u77e5\u7684authority\uff1a{}", (Object)request.getHeader("authority"));
        }
        channels.forEach(channel -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("channel", channel);
            map.put("operators", operators);
            map.put("contractId", contractId);
            map.put("billCode", billCode);
            map.put("contractName", contractName);
            Function<Map<String, Object>, Void> result = this.channelMap.get(channel);
            Assert.notNull(result, (String)"\u5f02\u6b65\u6d88\u606f\u901a\u77e5\uff0c\u8bf7\u6c42\u5931\u8d25\uff0c\u6d88\u606f\u901a\u9053\u4e0d\u5b58\u5728\uff01");
            result.apply(map);
        });
    }

    public Void systemInformMessage(Map<String, Object> map) {
        String channel = (String)map.get("channel");
        List operators = (List)map.get("operators");
        Long contractId = (Long)map.get("contractId");
        String billCode = (String)map.get("billCode");
        String contractName = (String)map.get("contractName");
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setChannel(new String[]{channel});
        parameter.setMsgType("task");
        String subject = "\u4f60\u6709\u4e00\u4efd\u65b0\u7684\u6587\u4ef6\u3010" + billCode + "_" + contractName + "\u3011\u9700\u8981\u7b7e\u7f72!";
        parameter.setSubject(subject);
        if (Objects.equals(((SignMgrSignatoryEntity)((Object)operators.get(0))).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
            String[] receivers = (String[])operators.stream().map(e -> String.valueOf(e.getSignatureId())).toArray(String[]::new);
            parameter.setReceivers(receivers);
            String content = "PERSONAL".equals(((SignMgrSignatoryEntity)((Object)operators.get(0))).getSignActionType()) ? "\u60a8\u6709\u4e00\u4e2a\u79c1\u6709\u4e91\u5f85\u7b7e\u7f72\u5408\u540c:<a href=\"" + this.BASE_HOST + "ejc-signaturemanage-frontend/#/privateSign?contractId=" + contractId + "&tenantType=" + ((SignMgrSignatoryEntity)((Object)operators.get(0))).getTenantType() + "&tenantName=" + ((SignMgrSignatoryEntity)((Object)operators.get(0))).getTenantName() + "&contact=" + ((SignMgrSignatoryEntity)((Object)operators.get(0))).getSignatureContact() + "\">\u70b9\u6211\u7b7e\u7f72</a>" : "\u60a8\u6709\u4e00\u4e2a\u79c1\u6709\u4e91\u5f85\u7b7e\u7f72\u5408\u540c:<a href=\"" + this.BASE_HOST + "ejc-signaturemanage-frontend/#/privateSign?contractId=" + contractId + "&tenantType=" + ((SignMgrSignatoryEntity)((Object)operators.get(0))).getTenantType() + "&tenantName=" + ((SignMgrSignatoryEntity)((Object)operators.get(0))).getTenantName() + "&contact=\">\u70b9\u6211\u7b7e\u7f72</a>";
            parameter.setContent(content);
            CommonResponse user = this.userApi.findUserByUserId(Long.valueOf(receivers[0]));
            if (!user.isSuccess() || user.getData() == null) {
                throw new BusinessException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff01");
            }
            this.logger.info("\u67e5\u8be2\u5230\u7684\u79df\u6237\u5217\u8868\uff1a{}", (Object)JSON.toJSONString((Object)user.getData(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            String tenantId = String.valueOf(((UserVO)user.getData()).getTenantId());
            parameter.setTenantId(tenantId);
            this.logger.info("\u53d1\u9001\u901a\u77e5\u5165\u53c2\uff1a\u6d88\u606f\u53d1\u9001\u6e20\u9053\u7c7b\u578b\uff1a{}\uff0c\u63a5\u6536\u4eba\uff1a{}\uff0c\u6d88\u606f\u7c7b\u578b\uff1a{}\uff0c\u6d88\u606f\u4e3b\u9898\uff1a{}\uff0c\u6d88\u606f\u5185\u5bb9\uff1a{}\uff0c\u79df\u6237ID\uff1a{}", new Object[]{channel, receivers, "task", subject, content, tenantId});
            CommonResponse response = this.pushMessageApi.pushMessage(parameter);
            if (!response.isSuccess()) {
                this.logger.error("\u53d1\u9001\u7cfb\u7edf\u6d88\u606f\u901a\u77e5\u5931\u8d25\uff0c\u54cd\u5e94\uff1a{}", (Object)JSON.toJSONString((Object)response, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
                throw new BusinessException("\u53d1\u9001\u7cfb\u7edf\u6d88\u606f\u901a\u77e5\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
            }
        } else {
            this.logger.info("\u5916\u90e8\u5355\u4f4d\u53d1\u9001\u6d88\u606f\u901a\u77e5");
        }
        operators.forEach(o -> o.setAcceptTime(new Date()));
        this.signMgrSignatoryService.saveOrUpdateBatch(operators, 5, false);
        this.logger.info("\u6d88\u606f\u901a\u77e5\u6210\u529f\uff0c\u5df2\u8bbe\u7f6e\u63a5\u6536\u65f6\u95f4\uff0c\u5f53\u524d\u901a\u77e5\u4eba\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)operators, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return null;
    }

    @Recover
    public Void systemInformMessage(Exception e, Map<String, Object> map) {
        String channel = (String)map.get("channel");
        List operators = (List)map.get("operators");
        Long contractId = (Long)map.get("contractId");
        String billCode = (String)map.get("billCode");
        String contractName = (String)map.get("contractName");
        this.logger.error("\u5f02\u6b65\u6d88\u606f\u901a\u77e5\uff0c\u91cd\u8bd5\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570--channel\uff1a{}\uff0coperators\uff1a{}\uff0ccontractId\uff1a{}\uff0cbillCode\uff1a{}\uff0ccontractName\uff1a{}\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}\uff01", new Object[]{channel, JSON.toJSONString((Object)operators, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}), contractId, billCode, contractName, e.getMessage()});
        return null;
    }
}

