package com.ejianc.business.signaturemanage.controller.api;


import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.signaturemanage.bean.SignMgrEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrLogEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrPreviewEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.enums.SignMgrSignatoryEnum;
import com.ejianc.business.signaturemanage.service.*;
import com.ejianc.business.signaturemanage.utils.FileConvert;
import com.ejianc.business.signaturemanage.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import net.qiyuesuo.sdk.bean.user.UserDetail;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 签章管理API控制器
 *
 * @author baipengyan
 * @Description: 签章管理API控制器
 */
@RestController
@RequestMapping(value = "/api/signaturemanage")
public class SignatureManageApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IGlobalCallBackService globalCallBackService;

    @Autowired
    private ISignMgrService signMgrService;

    @Autowired
    private ISignMgrSignatoryService signMgrSignatoryService;

    @Autowired
    private ISignMgrPreviewService signMgrPreviewService;

    @Autowired
    private ISignMgrLogService signMgrLogService;

    @Autowired
    private IEmployeeApi employeeApi;// 获取用户信息

    @Autowired
    private IAttachmentApi attachmentApi; // 文件信息

    @Value("${ejc.fileServerUrl}")
    private String FILE_HOST; // 文件中心域名

    @Autowired
    private ISignMgrSignatoryService signatoryService;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IUserApi userApi; //获取用户

    private final String FACE_SIGN_SIGNAL = "P-n0dc750133";

    /**
     * 发起签章
     * 1.创建合同文档
     * 2.创建合同
     * 3.获取下一个待签章的人员列表
     * 4.推送消息通知
     *
     * @param initSignatureVO 发起签章VO
     * @return contractId
     */
    @PostMapping(value = "/sendSignature")
    public CommonResponse<Long> initiateSignature(@RequestBody InitSignatureVO initSignatureVO, HttpServletRequest httpServletRequest) {
        logger.info("发起签章初始数据initSignatureVO:{}", JSONObject.toJSONString(initSignatureVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        signMgrService.validation(initSignatureVO);
        // 获取上下文
        String authority = httpServletRequest.getHeader("authority");

        // 校验是否重发合同

        // 先获取发起人名称和手机号
        Long userId = InvocationInfoProxy.getUserid();
        CommonResponse<EmployeeVO> employeeResponse = employeeApi.queryEmployeByUserId(userId);
        logger.info("发起人信息：{}", JSONObject.toJSONString(employeeResponse));
        if (employeeResponse.isSuccess()) {
            String userName = employeeResponse.getData().getUserName();
            if (StringUtils.isEmpty(userName)) {
                throw new BusinessException("请维护发起人名称！");
            }
            String mobilePhone = employeeResponse.getData().getMobilePhone();
            if (StringUtils.isEmpty(mobilePhone)) {
                throw new BusinessException("请维护发起人手机号！");
            }
            initSignatureVO.setCreatorName(employeeResponse.getData().getUserName());
            initSignatureVO.setCreatorContact(employeeResponse.getData().getMobilePhone());
        } else {
            throw new BusinessException("未获取到发起人信息！");
        }

        // 获取文件地址
        String fileName;
        String billDocumentType = null;
        String url;
        CommonResponse<AttachmentVO> attachmentResp = attachmentApi.queryDetail(String.valueOf(initSignatureVO.getBillDocId()));
        logger.info("调用第三方接口返回的文件信息：{}", JSONObject.toJSONString(attachmentResp));
        if (attachmentResp.isSuccess()) {
            // url = attachmentResp.getData().getTruePath();
            url = FILE_HOST + attachmentResp.getData().getFilePath();
            if (StringUtils.isEmpty(url)) {
                throw new BusinessException("文件地址为空！");
            }
            fileName = attachmentResp.getData().getFileName();
            if (StringUtils.isEmpty(fileName)) {
                throw new BusinessException("文件名称为空！");
            }
            billDocumentType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        } else {
            throw new BusinessException("获取文件信息异常！");
        }

        Long documentId = signMgrService.createDocument(url, initSignatureVO.getBillDocumentName(), billDocumentType);
        Long contractId = signMgrService.createContract(documentId, initSignatureVO);

        QueryWrapper<SignMgrEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("source_bill_id", contractId);
        queryWrapper.eq("del_flag", 0);
        SignMgrEntity signMgrEntity = signMgrService.getOne(queryWrapper);

        String billType = signMgrEntity.getBillType();
        Long billId = signMgrEntity.getBillId();
        String billRefCode = signMgrEntity.getBillRefCode();

        Integer maxSignOrder = -1;
        Integer maxSealSignOrder = -1;

        // 找到下一个签章人
        List<SignMgrSignatoryEntity> operators = signMgrService.nextSignatory(contractId, maxSignOrder, maxSealSignOrder);

        int status;
        if (operators.isEmpty()) {
            throw new BusinessException("找不到下一个签章人！");
        } else {
            // 发送消息通知
            signMgrService.sendMessage(contractId, operators, initSignatureVO.getBillCode(), initSignatureVO.getContractName());
            if (Objects.equals(operators.get(0).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                status = 3;
                // 待甲方签章
                signMgrService.sendStatus(billType, billId, billRefCode, status, authority);
            } else {
                status = 2;
                // 待乙方签章
                signMgrService.sendStatus(billType, billId, billRefCode, status, authority);
            }
        }
        return CommonResponse.success("发起签章，操作成功！", contractId);
    }


    /**
     * 契约锁，全局状态回调
     *
     * @param map 回调参数
     * @return 回调结果
     */
    @PostMapping(value = "/qysCallBack/global")
    public CommonResponse<Map<String, String>> global(@RequestParam Map<String, String> map, HttpServletRequest httpServletRequest) {
        logger.info("/qysCallBack/global回调入参map为：{}", JSONObject.toJSONString(map, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));

        CommonResponse<Map<String, String>> result = this.CallBackInit(map, httpServletRequest);
        if (!result.isSuccess()) {
            return CommonResponse.error("回调成功！", map);
        }
        // 全局签章回调处理
        globalCallBackService.callBackHandler(result.getData());

        return CommonResponse.success("全局状态回调成功！", map);
    }

    private CommonResponse<Map<String, String>> CallBackInit(Map<String, String> map, HttpServletRequest httpServletRequest) {
        // 主表
        QueryWrapper<SignMgrEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("del_flag", 0);
        queryWrapper.eq("source_bill_id", Long.valueOf(map.get("contractId")));
        SignMgrEntity signMgrEntity = signMgrService.getOne(queryWrapper);
        if (signMgrEntity == null) {
            return CommonResponse.error("回调成功！", map);
        }

        // 获取上下文
        String authority = signMgrService.login(httpServletRequest, signMgrEntity.getTenantId());
        logger.info("获取的上下文信息为：{}", authority);
        InvocationInfoProxy.setTenantid(signMgrEntity.getTenantId());
        String key = "userCode";
        int idx = authority.indexOf(";" + key + "=");
        if (idx >= 0) {
            String tmp = authority.substring(idx + 1);
            InvocationInfoProxy.setUsercode(tmp.substring(0, tmp.indexOf(";")).replace(key + "=", ""));
        }
        RequestContextHolder.getRequestAttributes().setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);

        map.put("authority", authority);
        map.put("id", String.valueOf(signMgrEntity.getId()));
        map.put("billId", String.valueOf(signMgrEntity.getBillId()));
        map.put("billType", signMgrEntity.getBillType());
        map.put("billCode", signMgrEntity.getBillCode());
        map.put("billRefCode", signMgrEntity.getBillRefCode());
        map.put("contractName", signMgrEntity.getContractName());
        map.put("pid", String.valueOf(signMgrEntity.getId()));
        return CommonResponse.success("回调成功！", map);
    }


    // fixme : 避免影响原有功能，后期进行改造合并

    /**
     * 契约锁，发起方状态回调
     *
     * @param map 回调参数
     * @return 回调结果
     */
    @PostMapping(value = "/qysCallBack/organizer1")
    public CommonResponse<Map<String, String>> organizer1(@RequestParam Map<String, String> map, HttpServletRequest httpServletRequest) {
        logger.info("/qysCallBack/organizer1回调入参map为：{}", JSONObject.toJSONString(map, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));

        CommonResponse<Map<String, String>> result = this.CallBackInit(map, httpServletRequest);
        if (!result.isSuccess()) return CommonResponse.error("回调成功！", map);
        // 全局签章回调处理
        globalCallBackService.callBackHandler(result.getData());

        return CommonResponse.success("发起方状态回调成功！", map);
    }


    /**
     * 契约锁，发起方状态回调
     *
     * @param map 回调参数
     * @return 回调结果
     */
    @PostMapping(value = "/qysCallBack/organizer")
    public CommonResponse<String> organizer(@RequestParam Map<String, String> map, HttpServletRequest httpServletRequest) {
        logger.info("/qysCallBack/organizer:回调入参map为：{}", JSONObject.toJSONString(map));

        Long contractId = Long.valueOf(map.get("contractId"));

        switch (map.get("type")) {
            case "CONTRACT_SIGN":
                // 文件签署-签署方签署

                break;
            case "INTERNAL_FLOW":
                // 每个节点签署完成
                logger.info("================================>单个节点回调-START<================================");
                QueryWrapper<SignMgrEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.eq("source_bill_id", contractId);
                queryWrapper.eq("del_flag", 0);
                SignMgrEntity signMgrEntity = signMgrService.getOne(queryWrapper);

                // 获取上下文
                String authority = signMgrService.login(httpServletRequest, signMgrEntity.getTenantId());

                InvocationInfoProxy.setTenantid(signMgrEntity.getTenantId());
                String key = "userCode";
                int idx = authority.indexOf(";" + key + "=");
                if (idx >= 0) {
                    String tmp = authority.substring(idx + 1);
                    InvocationInfoProxy.setUsercode(tmp.substring(0, tmp.indexOf(";")).replace(key + "=", ""));
                }

                logger.info("获取的上下文信息为：{}", authority);
                RequestContextHolder.getRequestAttributes().setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);

                String billType = signMgrEntity.getBillType();
                Long billId = signMgrEntity.getBillId();
                String billRefCode = signMgrEntity.getBillRefCode();

                QueryWrapper<SignMgrSignatoryEntity> queryWrapper1 = new QueryWrapper<>();
                queryWrapper1.eq("pid", signMgrEntity.getId());
                queryWrapper1.eq("del_flag", 0);
                List<SignMgrSignatoryEntity> actionList = signMgrSignatoryService.list(queryWrapper1);


                Map<String, Object> minMax = signMgrService.internalFlow(map, signMgrEntity, actionList);
                Integer maxSignOrder = (Integer) minMax.get("maxSignOrder");
                Integer maxSealSignOrder = (Integer) minMax.get("maxSealSignOrder");

                List<SignMgrLogEntity> slog = (List<SignMgrLogEntity>) minMax.get("SignMgrLogEntity");
                List<SignMgrSignatoryEntity> operators = signMgrService.nextSignatory(contractId, maxSignOrder, maxSealSignOrder);

                // 通知业务系统结果
                String res;
                if (operators.isEmpty()) {
                    // 全都签章完成
                    // 无待激活状态，判定全部完成,（不做操作的话等全局回调合同完成）这里可以把合同状态通知给业务系统
                    res = signMgrService.sendStatus(billType, billId, billRefCode, SignMgrSignatoryEnum.SIGNED.getValue(), authority);
                } else {
                    // 发送消息通知
                    logger.info("================================>发送消息通知-START<================================");
                    signMgrService.sendMessage(contractId, operators, signMgrEntity.getBillCode(), signMgrEntity.getContractName());
                    logger.info("================================>发送消息通知-END<================================");
                    if (Objects.equals(operators.get(0).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                        // 待甲方签章
                        logger.info("================================>业务系统更新状态-待甲方签章-START<================================");
                        res = signMgrService.sendStatus(billType, billId, billRefCode, SignMgrSignatoryEnum.WAITE_PARTY_A.getValue(), authority);
                        logger.info("================================>业务系统更新状态-待甲方签章-END<================================");
                    } else {
                        // 待乙方签章
                        logger.info("================================>业务系统更新状态-待乙方签章-START<================================");
                        res = signMgrService.sendStatus(billType, billId, billRefCode, SignMgrSignatoryEnum.WAITE_PARTY_B.getValue(), authority);
                        logger.info("================================>业务系统更新状态-待乙方签章-END<================================");
                    }
                }

                slog.stream().peek(e -> e.setBillSysResp(res)).collect(Collectors.toList());
                signMgrLogService.updateBatchById(slog);

                // 异步任务-文件下载和上传
                // signMgrService.fileTask(contractId, status, signMgrEntity, authority, billType, billId);

                logger.info("================================>单个节点回调-END<================================");
                break;
            case "CONTRACT_RECALL":
                // 文件撤回-发起方撤回
                break;
            default:
                break;
        }

        return CommonResponse.success("发起方状态，回调成功！");
    }


    /**
     * 契约锁，接收方状态回调
     *
     * @param map 回调参数
     * @param httpServletRequest
     * @return 回调结果
     */
    @PostMapping(value = "/qysCallBack/receiver")
    public CommonResponse<Map<String, String>> receiver(@RequestParam Map<String, String> map, HttpServletRequest httpServletRequest) {
        logger.info("/qysCallBack/receiver:回调入参map为：{}", JSONObject.toJSONString(map, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));

        CommonResponse<Map<String, String>> result = this.CallBackInit(map, httpServletRequest);
        if (!result.isSuccess()) {
            return CommonResponse.error("回调成功！", map);
        }
        // 全局签章回调处理
        globalCallBackService.callBackHandler(result.getData());

        return CommonResponse.success("接收方状态回调成功！", map);
    }


    /**
     * 获取私有云合同签署短链接
     *
     * @param privateSignUrlVO
     * @return privateSignUrl
     */
    @PostMapping(value = "/getPrivateSignUrl")
    public CommonResponse<String> privateSignUrl(@RequestBody PrivateSignUrlVO privateSignUrlVO) {

        // 用户签章是否需要传递联系方式系统参数
        String contract = privateSignUrlVO.getContact();
        boolean needContact = false;
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(FACE_SIGN_SIGNAL);
        if (!response.isSuccess() || null == response.getData()) {
            logger.error("获取人脸签章系统参数失败，失败原因：", JSONObject.toJSONString(response));
        }
        if("1".equals(response.getData().getValueData())) {
            needContact = true;
        }
        if(needContact && StringUtils.isBlank(contract)) {
            //查找当前操作用户的联系方式
            CommonResponse<UserVO> userResp = userApi.findUserByUserId(InvocationInfoProxy.getUserid());
            if(!userResp.isSuccess()) {
                logger.error("获取签署连接失败，查询当前用户-[{}]联系方式失败, {}", InvocationInfoProxy.getUserid(), JSONObject.toJSONString(userResp));
                throw new BusinessException("获取签署连接失败，查询当前用户联系方式失败！");
            }

            if(StringUtils.isBlank(userResp.getData().getUserMobile())) {
                logger.error("获取签署连接失败，查询当前用户-[{}]联系方式为空!");
                throw new BusinessException("获取签署连接失败，查询当前用户联系方式为空！");
            }
            contract = userResp.getData().getUserMobile();
        }

        //根据契约锁合同文件Id查询当前签署方第一个非个人印章的契约锁单面名称
        String sourceCompanyName = signatoryService.getFirstNoPsSealSourceCompanyName(privateSignUrlVO.getContractId());
        logger.info("根据sourceBillId-{}获取到当前合同签署方的tenantName为:{}", privateSignUrlVO.getContractId(), sourceCompanyName);

        String privateSignUrl = signMgrService.createPrivateSignUrl(privateSignUrlVO.getContractId(), privateSignUrlVO.getTenantType(), StringUtils.isNotBlank(sourceCompanyName) ? sourceCompanyName : privateSignUrlVO.getTenantName(), contract);
        return CommonResponse.success("获取私有云合同签署短链接，成功！", privateSignUrl);
    }


    @GetMapping(value = "/downloadHasSignedFile")
    public void downloadHasSignedFile(@RequestParam(value = "billId") Long billId, HttpServletResponse response) {

        if (billId == null) {
            throw new BusinessException("请检查业务id是否为空！");
        }

        QueryWrapper<SignMgrEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("bill_id", billId);
        queryWrapper.eq("del_flag", 0);
        SignMgrEntity signMgrEntity = signMgrService.getOne(queryWrapper);

        if (signMgrEntity == null) {
            throw new BusinessException("查询不到对应数据，请检查重试！");
        }

        Long contractId = signMgrEntity.getSourceBillId();

        OutputStream out = null;
        String fileName = String.format("%s_%d", signMgrEntity.getBillDocumentName(), billId);
        File file = null;
        try {
            file = File.createTempFile(fileName, ".pdf");
            out = new FileOutputStream(file);
        } catch (Exception e) {
            logger.error("下载签章文件，失败！原因是：", e);
            throw new BusinessException("下载签章文件，失败！");
        }

        if (!file.isFile() || !file.exists()) {
            throw new BusinessException("初始化临时文件不存在！");
        }

        signMgrService.downloadHasSignedFile(contractId, out);
        logger.info("下载合同完成,业务ID为：{},契约锁合同ID为：{}", billId, contractId);

        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream)) {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(response.getOutputStream());
                int length = 0;
                byte[] temp = new byte[1024 * 10];
                while ((length = bufferedInputStream.read(temp)) != -1) {
                    bufferedOutputStream.write(temp, 0, length);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                logger.info("下载签章文件成功，文件名称：{}", file.getName());
            }
            inputStream.close();
        } catch (IOException e) {
            logger.error("下载签章文件，失败！原因是：", e);
            throw new BusinessException("下载签章文件，失败！");
        } finally {
            // 成功后才删除签章文件
            file.delete();
            logger.info("删除签章文件：{},成功！", file.getName());
        }
    }

    @GetMapping(value = "/previewContract")
    public CommonResponse<String> previewContract(@RequestParam(value = "billId") Long billId) {
        // FIXME: 2022/05/16  合同预览接口需要更新
        if (billId == null) {
            return CommonResponse.success("获取合同预览链接失败！", null);
        }
        logger.info("合同ID为--{}", billId);

        QueryWrapper<SignMgrEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("del_flag", 0);
        queryWrapper.eq("bill_id", billId);
        SignMgrEntity entity = signMgrService.getOne(queryWrapper);
        if (entity == null) {
            return CommonResponse.success("获取合同预览链接失败！", null);
        }

        return CommonResponse.success("获取合同预览链接请求成功！", signMgrService.viewUrl(entity.getSourceBillId()));
    }


    /**
     * 签章详情
     *
     * @param billId
     * @return
     */
    @GetMapping(value = "/signDetail")
    public CommonResponse<SignDetailVO> signDetail(@RequestParam(value = "billId") Long billId) {
        SignDetailVO signDetailVO = new SignDetailVO();

        QueryWrapper<SignMgrEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("bill_id", billId);
        queryWrapper.eq("del_flag", 0);
        SignMgrEntity signMgrEntity = signMgrService.getOne(queryWrapper);

        if (signMgrEntity != null) {
            QueryWrapper<SignMgrSignatoryEntity> queryWrapper1 = new QueryWrapper<>();
            queryWrapper1.eq("pid", signMgrEntity.getId());
            queryWrapper1.eq("del_flag", 0);
            List<SignMgrSignatoryEntity> list = signMgrSignatoryService.list(queryWrapper1);
            if (list.isEmpty()) {
                throw new BusinessException("查询签署详情失败，请稍后尝试！");
            }

            signDetailVO.setTenantName(signMgrEntity.getTenantName());
            signDetailVO.setCreatorName(signMgrEntity.getCreatorName());
            signDetailVO.setCreateTime(signMgrEntity.getCreateTime());

            List<SignatoryDetailVO> sds = new ArrayList<>();
            list.sort(Comparator.comparing(SignMgrSignatoryEntity::getSignOrder));
            Map<Integer, List<SignMgrSignatoryEntity>> listMap = list.stream().collect(Collectors.groupingBy(SignMgrSignatoryEntity::getSignOrder));

            int number = 1;
            for (Integer key : listMap.keySet()) {
                List<SignMgrSignatoryEntity> values = listMap.get(key);

                SignatoryDetailVO signatoryDetailVO = new SignatoryDetailVO();
                List<ActionDetailVO> actionDetails = new ArrayList<>();

                for (SignMgrSignatoryEntity value : values) {
                    ActionDetailVO actionDetailVO = new ActionDetailVO();
                    actionDetailVO.setActionName(value.getName());
                    actionDetailVO.setSignatoryName(value.getSignatureName());
                    actionDetailVO.setActualSignatoryName(value.getActualSignatoryName());
                    actionDetailVO.setSigningDate(value.getEndTime());
                    actionDetailVO.setSignatureStatus(value.getJobStatus());
                    actionDetails.add(actionDetailVO);
                }

                Set<Integer> s = actionDetails.stream().map(ActionDetailVO::getSignatureStatus).collect(Collectors.toSet());
                if (!s.isEmpty()) {
                    if (s.contains(1)) {
                        signatoryDetailVO.setStatus(1);
                    } else if (s.size() == 1 && s.iterator().next().equals(2)) {
                        signatoryDetailVO.setStatus(2);
                    } else {
                        signatoryDetailVO.setStatus(0);
                    }
                }
                if (signMgrEntity.getTenantName().equals(values.get(0).getTenantName())) {
                    signatoryDetailVO.setSignatoryName("发起主体");
                } else {
                    signatoryDetailVO.setSignatoryName("签约方" + number);
                    number++;
                }
                signatoryDetailVO.setTenantName(values.get(0).getTenantName());
                // 契约锁展示逻辑：甲方接收人和手机号都传，以手机号为准，看存不存在契约锁公司人员里，存在则签署详情展示传的手机号对应真实的人，不存在则创建新的接收人和手机号/只传接收人，不传手机号，展示接受人名和创建人手机号/只传手机号，不传接收人，以手机号为准，如果手机号已在契约锁平台公司人员下，展示真实的接收人名，不在的话
                if (!Objects.equals(values.get(0).getSignatureType(), SignMgrSignatoryEnum.INTERNAL_UNIT.getValue())) {
                    signatoryDetailVO.setOperatorName(values.get(0).getReceiverName());
                    signatoryDetailVO.setContact(values.get(0).getContact());
                } else {
                    if (!StringUtils.isEmpty(values.get(0).getContact())) {
                        if (StringUtils.isEmpty(values.get(0).getReceiverName())) {
                            signatoryDetailVO.setOperatorName(null);
                        } else {
                            // 取真实的
                            UserDetail userDetail = signMgrService.userDetail(values.get(0).getContact());
                            logger.info("根据手机号获取的用户信息和公司信息----{}", JSONObject.toJSONString(userDetail));
                            if ("AUTH_FAILURE".equals(userDetail.getStatus())) {
                                signatoryDetailVO.setOperatorName(values.get(0).getReceiverName());
                            } else {
                                signatoryDetailVO.setOperatorName(userDetail.getName());
                            }
                        }
                        signatoryDetailVO.setContact(values.get(0).getContact());
                    } else {
                        if (StringUtils.isEmpty(values.get(0).getReceiverName())) {
                            signatoryDetailVO.setOperatorName(signMgrEntity.getCreatorName());
                            signatoryDetailVO.setContact(signMgrEntity.getCreatorContact());
                        } else {
                            signatoryDetailVO.setOperatorName(values.get(0).getReceiverName());
                            signatoryDetailVO.setContact(signMgrEntity.getCreatorContact());
                        }
                    }
                }
                signatoryDetailVO.setAcceptTime(values.get(0).getAcceptTime());
                signatoryDetailVO.setFinishTime(values.get(values.size() - 1).getEndTime());

                signatoryDetailVO.setActionDetails(actionDetails);
                sds.add(signatoryDetailVO);
            }
            signDetailVO.setSignatorys(sds);
        } else {
            throw new BusinessException("未查询到签章记录，请联系管理员处理！");
        }
        return CommonResponse.success("获取签署详情成功！", signDetailVO);
    }


    /**
     * 定时同步签章合同到文件中心
     *
     * @return CommonResponse<List < SignMgrPreviewVO>>
     */
    @PostMapping("/synchronizeContractToFileCenter")
    @Deprecated
    public CommonResponse<List<SignMgrPreviewVO>> synchronizeContractToFileCenter(HttpServletRequest request) {
        logger.info("同步签章合同到文件中心--------开始！");
        QueryWrapper<SignMgrPreviewEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.isNull("file_id");
        queryWrapper.isNotNull("file_base64");
        queryWrapper.isNotNull("file_name");
        queryWrapper.eq("del_flag", 0);

        List<SignMgrPreviewEntity> entities = signMgrPreviewService.list(queryWrapper);
        if (entities.isEmpty()) {
            return CommonResponse.success("同步成功！", null);
        }

        // base64字符串转文件，上传文件中心
        List<SignMgrPreviewEntity> previewEntityList = entities.parallelStream().map(e -> {
            // 字符串转文件
            File file = FileConvert.base64ToFile(e.getFileBase64(), e.getFileName());
            if (!file.isFile()) {
                logger.error("定时同步签章合同到文件中心--------文件转换失败！失败的数据是：{}", JSONObject.toJSONString(e, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
                if (file.exists()) {
                    file.delete();
                }
                return e;
            }
            // 上传文件中心
            AttachmentVO attachmentVO = signMgrService.pushToFileCenter(file, request.getHeader("authority"), e.getSourceType(), e.getBillId(), e.getBillType(), "true");
            if (attachmentVO == null) {
                // 删除本地文件
                file.delete();
                return e;
            }
            e.setBillId(attachmentVO.getSourceId());
            e.setBillType(attachmentVO.getBillType());
            e.setSourceType(attachmentVO.getSourceType());
            // 上传成功，置空，防止表存储过大
            e.setFileBase64(null);
            e.setFileId(attachmentVO.getId());
            e.setFileName(attachmentVO.getFileName());
            e.setFilePath(attachmentVO.getFilePath());
            e.setFileSize(attachmentVO.getFileSize());
            e.setOnlinePath(attachmentVO.getOnlinePath());
            e.setTruePath(attachmentVO.getTruePath());
            // 删除本地文件
            file.delete();
            return e;
        }).collect(Collectors.toList());

        // 批量更新
        signMgrPreviewService.saveOrUpdateBatch(previewEntityList, 5);

        List<SignMgrPreviewVO> vos = BeanMapper.mapList(previewEntityList, SignMgrPreviewVO.class);
        logger.info("同步签章合同到文件中心--------结束！");
        return CommonResponse.success("同步成功！", vos);
    }

    /**
     * 契约锁，全局状态回调 郑州一建
     *
     * @param map 回调参数
     * @return 回调结果
     */
    @PostMapping(value = "/qysCallBack/globalZzyj")
    public CommonResponse<Map<String, String>> globalZzyj(@RequestParam Map<String, String> map, HttpServletRequest httpServletRequest) {
        logger.info("/qysCallBack/globalZzyj回调入参map为：{}", JSONObject.toJSONString(map, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));

        return CommonResponse.success("全局状态回调成功！", map);
    }

}
