package com.ejianc.business.signaturemanage.enums;

/**
 * @author baipengyan
 * @date 2022/5/18
 * @description 合同水印位置枚举
 */
public enum WatermarkLocationEnum {
    UPPER_LEFT("UPPER_LEFT", "左上角"),
    UPPER_RIGHT("UPPER_RIGHT", "右上角"),
    LOWER_LEFT("LOWER_LEFT", "左下角"),
    LOWER_RIGHT("LOWER_RIGHT", "右下角"),
    MIDDLE_CENTER("MIDDLE_CENTER", "居中"),
    TILE("TILE", "平铺"),
    FILL("FILL", "填充");
    private final String code;
    private final String description;

    WatermarkLocationEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }
}
