package com.ejianc.business.signaturemanage.service;

import com.ejianc.business.signaturemanage.vo.SignatureVO;

/**
 * @author baipengyan
 * @date 2022/6/2
 * @description 签章定位业务接口
 */
public interface ISignatureRectService {

	/**
	 * 删除签章数据：双删除（本地逻辑删除，第三方合同删除）
	 *
	 * @param contractId PM系统合同id
	 */
	void deleteSignatureRect(Long contractId);

	/**
	 * 获取预签署链接
	 *
	 * @param signatureVO 发起签章VO
	 *
	 * @return String 预签署链接
	 */
	String fetchPreSignUrl(SignatureVO signatureVO);

	/**
	 * 发起签章
	 *
	 * @param contractId PM系统合同id
	 */
	void sendSignature(Long contractId);

	/**
	 * 合同签章撤回
	 * 撤回状态是“签署中”或“填参中”的合同
	 *
	 * @param billId 单据主键Id
	 * @param recallReason 撤回原因
	 * @return recallResult 撤回结果，为空时，表示撤回成功
	 */
	String recallContract(Long billId, String recallReason);
}
