package com.ejianc.business.signaturemanage.service;

import com.ejianc.business.signaturemanage.bean.SignatureSettingSubEntity;
import com.ejianc.business.signaturemanage.vo.SignatureSettingSubVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author:刘家乐
 * @version: 1
 * @date:2021/11/23
 * @document:
 */
public interface ISignatureSettingSubService extends IBaseService<SignatureSettingSubEntity> {

    /**
     * 根据id删除
     * @param idList
     */
    void deleteUserByIdList(@Param("idList") List<Long> idList);

    /**
     *  查询当前默认
     * @param pid
     * @return
     */
    String getDefaultSealName(Long pid);

    /**
     * 根据签章设置Id查询对应的签章设置列表
     *
     *
     * @param unitIds 签章单位Id
     * @param sourceStatus 印章状态
     * @return
     */
    List<SignatureSettingSubVO> getByUnitIds(List<Long> unitIds, String sourceStatus);
}
