/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.service.impl;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.signaturemanage.bean.SignMgrEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrPreviewEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.enums.DelFlagEnum;
import com.ejianc.business.signaturemanage.enums.WatermarkSchemeEnum;
import com.ejianc.business.signaturemanage.service.ISignMgrPreviewService;
import com.ejianc.business.signaturemanage.service.ISignMgrService;
import com.ejianc.business.signaturemanage.service.ISignMgrSignatoryService;
import com.ejianc.business.signaturemanage.service.ISignatureCommonService;
import com.ejianc.business.signaturemanage.utils.UploadFileCenter;
import com.ejianc.business.signaturemanage.utils.WatermarkConfigConvert;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.business.signaturemanage.vo.WatermarkConfigVO;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.bean.contract.ContractDetail;
import net.qiyuesuo.sdk.bean.contract.ContractQueryDTO;
import net.qiyuesuo.sdk.bean.contract.ContractStatus;
import net.qiyuesuo.sdk.bean.contract.WaterMarkContent;
import net.qiyuesuo.sdk.bean.contract.WaterMarkLocation;
import net.qiyuesuo.sdk.bean.contract.WaterMarkType;
import net.qiyuesuo.sdk.bean.document.DocumentCreateByUrl;
import net.qiyuesuo.sdk.bean.document.DownloadDocRequest;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.impl.ContractServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="signatureCommonService")
public class SignatureCommonServiceImpl
implements ISignatureCommonService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Function<WatermarkVO, File>> watermarkMap = new HashMap<String, Function<WatermarkVO, File>>();
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Value(value="${ejc.fileServerUrl}")
    private String FILE_HOST;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private UploadFileCenter upload;
    @Autowired
    private ISignMgrPreviewService signMgrPreviewService;
    @Autowired
    private ISignMgrService signMgrService;
    @Autowired
    private WatermarkConfigConvert watermarkConfigConvert;
    @Autowired
    private ISignMgrSignatoryService signMgrSignatoryService;
    @Autowired
    private CacheManager cacheManager;
    @Value(value="${qiyuesuo.client.url}")
    private String url;
    @Value(value="${qiyuesuo.client.accessKey}")
    private String accessKey;
    @Value(value="${qiyuesuo.client.accessSecret}")
    private String accessSecret;

    @PostConstruct
    public void watermarkDispatcher() {
        this.watermarkMap.put(WatermarkSchemeEnum.QI_YUE_SUO.getCode(), watermarkVO -> {
            try {
                return this.addWatermarkIfQiyuesuo((WatermarkVO)watermarkVO);
            }
            catch (IOException iOException) {
                return null;
            }
        });
    }

    @Override
    public File addWatermark(WatermarkVO watermarkVO) {
        Function<WatermarkVO, File> res = this.watermarkMap.get(watermarkVO.getScheme());
        Assert.notNull(res, (String)"\u5408\u540c\u6dfb\u52a0\u6c34\u5370\u7684\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        return res.apply(watermarkVO);
    }

    @Override
    @Async(value="commonTask")
    public void cleanFile(File file) throws IOException {
        Files.delete(Paths.get(file.getPath(), new String[0]));
    }

    private SDKClient getSdkClient() {
        SDKClient client = new SDKClient(this.url, this.accessKey, this.accessSecret);
        client.enableNonce();
        return client;
    }

    private File addWatermarkIfQiyuesuo(WatermarkVO watermarkVO) throws IOException {
        this.logger.info("\u5408\u540c\u6587\u4ef6\u6dfb\u52a0\u6c34\u5370\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)watermarkVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat}));
        CommonResponse res = this.attachmentApi.queryDetail(String.valueOf(watermarkVO.getFileId()));
        if (!res.isSuccess()) {
            this.logger.error("\u8c03\u7528\u6587\u4ef6\u4e2d\u5fc3\u63a5\u53e3\uff0c\u83b7\u53d6\u9644\u4ef6\u5931\u8d25\uff01\u539f\u56e0\uff1a{}", (Object)res.getMsg());
            throw new BusinessException("\u8c03\u7528\u6587\u4ef6\u4e2d\u5fc3\u63a5\u53e3\uff0c\u83b7\u53d6\u9644\u4ef6\u5931\u8d25\uff01");
        }
        AttachmentVO attachmentVO = (AttachmentVO)res.getData();
        this.logger.info("\u5408\u540c\u6587\u4ef6\u8be6\u60c5\uff1a{}", (Object)JSON.toJSONString((Object)attachmentVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat}));
        String contractUrl = this.FILE_HOST + attachmentVO.getFilePath();
        Assert.hasText((String)contractUrl, (String)"\u5408\u540c\u6587\u4ef6\u7f51\u7edc\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String fullName = attachmentVO.getFileName();
        String contractTitle = fullName.substring(0, fullName.lastIndexOf("."));
        Assert.hasText((String)contractTitle, (String)"\u5408\u540c\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String contractFileType = fullName.substring(fullName.lastIndexOf(".") + 1);
        Assert.hasText((String)contractFileType, (String)"\u5408\u540c\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (contractTitle.length() < 3) {
            contractTitle = contractTitle + "-" + DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)new Date());
        }
        SDKClient sdkClient = this.getSdkClient();
        ContractServiceImpl contractService = new ContractServiceImpl(sdkClient);
        DocumentCreateByUrl documentCreateByUrl = new DocumentCreateByUrl(contractUrl, contractTitle, contractFileType, null);
        Long documentId = null;
        try {
            documentId = contractService.createDocumentByUrl(documentCreateByUrl);
        }
        catch (PrivateAppException e) {
            throw new BusinessException(e.getMessage());
        }
        this.logger.info("\u5408\u540c\u6587\u6863id--{}", (Object)documentId);
        for (WatermarkConfigVO vo : watermarkVO.getWatermarkConfigs()) {
            WaterMarkContent waterMarkContent = new WaterMarkContent();
            waterMarkContent.setDocumentId(documentId);
            waterMarkContent.setType(WaterMarkType.valueOf((String)vo.getType()));
            waterMarkContent.setContent(vo.getContent());
            waterMarkContent.setImageBase64(vo.getImageBase64());
            waterMarkContent.setFontSize(vo.getFontSize());
            waterMarkContent.setColor(vo.getColor());
            waterMarkContent.setRotateAngle(vo.getRotateAngle());
            waterMarkContent.setTransparency(vo.getTransparency());
            waterMarkContent.setLocation(WaterMarkLocation.valueOf((String)vo.getLocation()));
            try {
                contractService.addWatermark(waterMarkContent);
            }
            catch (PrivateAppException e) {
                throw new BusinessException("\u8c03\u7528\u5951\u7ea6\u9501\u52a0\u6c34\u5370\u63a5\u53e3\u5931\u8d25\uff0c\u539f\u56e0\uff1a{} " + e.getMessage());
            }
        }
        DownloadDocRequest request = new DownloadDocRequest();
        File file = File.createTempFile(contractTitle, ".pdf");
        BufferedOutputStream out = FileUtil.getOutputStream((File)file);
        request.setDocumentId(documentId);
        request.setContact(contractTitle);
        request.setOutputStream((OutputStream)out);
        try {
            contractService.downloadDoc(request);
        }
        catch (PrivateAppException e) {
            throw new BusinessException("\u8c03\u7528\u5951\u7ea6\u9501\u4e0b\u8f7d\u5408\u540c\u6587\u6863\u63a5\u53e3\u5931\u8d25\uff0c\u539f\u56e0\uff1a{} " + e.getMessage());
        }
        Path target = Paths.get(file.getParent() + "/" + contractTitle + ".pdf", new String[0]);
        Files.move(file.toPath(), target, StandardCopyOption.REPLACE_EXISTING);
        return new File(String.valueOf(target));
    }

    @Override
    public AttachmentVO fetchAttachment(File file, String authority, WatermarkVO watermarkVO) {
        CommonResponse<List<AttachmentVO>> res = this.upload.uploadFile(file, authority, watermarkVO.getSourceType(), watermarkVO.getBillId(), watermarkVO.getBillType(), "false", this.BASE_HOST);
        if (!res.isSuccess() || res.getData() == null) {
            this.logger.error("\u6c34\u5370\u6587\u4ef6\u4e0a\u4f20\u6587\u4ef6\u4e2d\u5fc3\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}\uff0c\u8bf7\u6c42\u6587\u4ef6\u4e2d\u5fc3\u5165\u53c2\uff1aWatermarkVO--{}", (Object)res.getMsg(), (Object)JSON.toJSONString((Object)watermarkVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            throw new BusinessException("\u6c34\u5370\u6587\u4ef6\u4e0a\u4f20\u6587\u4ef6\u4e2d\u5fc3\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg());
        }
        return (AttachmentVO)JSON.parseObject((String)JSON.toJSONString(((List)res.getData()).get(0)), AttachmentVO.class);
    }

    @Override
    public WatermarkVO watermarkConfigConvert(Long fileId, Long billId, String billCode, String billType, String sourceType) {
        return this.watermarkConfigConvert.convert(fileId, billId, billCode, billType, sourceType);
    }

    @Override
    public List<SignMgrPreviewVO> fetchSignedContract(List<ContractVO> contracts) {
        List contractIds = contracts.stream().map(ContractVO::getContractId).collect(Collectors.toList());
        contracts.forEach(contract -> {
            LambdaQueryWrapper sm = new LambdaQueryWrapper();
            sm.eq(SignMgrEntity::getDelFlag, (Object)DelFlagEnum.NORMAL.getDelFlag());
            sm.eq(SignMgrEntity::getBillId, (Object)contract.getContractId());
            SignMgrEntity entity = (SignMgrEntity)((Object)((Object)this.signMgrService.getOne((Wrapper)sm)));
            Assert.notNull((Object)((Object)entity), (String)("PM\u7cfb\u7edf\u5408\u540cid--" + contract.getContractId() + "\uff0c\u67e5\u8be2\u4e0d\u5230\u7b7e\u7ae0\u8bb0\u5f55\uff01"));
            contract.setThirdContractId(entity.getSourceBillId());
            ContractDetail detail = this.signMgrService.detail(entity.getSourceBillId(), false);
            Assert.notNull((Object)detail, (String)("PM\u7cfb\u7edf\u5408\u540cid--" + contract.getContractId() + "\u5951\u7ea6\u9501\u5408\u540cid--" + entity.getSourceBillId() + "\uff0c\u67e5\u8be2\u4e0d\u5230\u5408\u540c\u4fe1\u606f\uff01"));
            if (!ContractStatus.COMPLETE.equals((Object)detail.getStatus())) {
                throw new BusinessException("PM\u7cfb\u7edf\u5408\u540cid--" + contract.getContractId() + "\u5951\u7ea6\u9501\u5408\u540cid--" + entity.getSourceBillId() + "\uff0c\u5408\u540c\u72b6\u6001\u4e0d\u662f\u5df2\u7b7e\u7ae0\uff01");
            }
        });
        LambdaQueryWrapper spWrapper = new LambdaQueryWrapper();
        spWrapper.eq(SignMgrPreviewEntity::getDelFlag, (Object)0);
        spWrapper.in(SignMgrPreviewEntity::getBillId, contractIds);
        List sps = BeanMapper.mapList((Iterable)this.signMgrPreviewService.list((Wrapper)spWrapper), SignMgrPreviewVO.class);
        if (CollectionUtils.isEmpty((Collection)sps)) {
            sps.addAll(this.syncSignedContract(contracts));
        } else {
            contractIds.removeAll(sps.stream().map(SignMgrPreviewVO::getBillId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(contractIds)) {
                sps.addAll(this.syncSignedContract(contracts));
            }
        }
        return sps;
    }

    @Override
    public String notifySignOperatorByBillId(Long billId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bill_id", (Object)billId);
        queryWrapper.eq((Object)"del_flag", (Object)0);
        SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)this.signMgrService.getOne((Wrapper)queryWrapper));
        return this.notifySignOperator(signMgrEntity);
    }

    @Override
    public String notifySignOperatorById(Long id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"id", (Object)id);
        SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)this.signMgrService.getOne((Wrapper)queryWrapper));
        return this.notifySignOperator(signMgrEntity);
    }

    private String notifySignOperator(SignMgrEntity signMgrEntity) {
        if (signMgrEntity == null) {
            return "\u53d1\u9001\u901a\u77e5\u5931\u8d25\uff0c\u8be5\u5355\u636e\u7684\u7b7e\u7ae0\u4fe1\u606f\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01";
        }
        if (null == signMgrEntity.getSourceBillId()) {
            this.logger.error("\u5355\u636e-\u3010id:{}\u3011\u7b7e\u7ae0\u4fe1\u606f\u4e2d\u65e0\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid", (Object)signMgrEntity.getBillId());
            return "\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\u4e0d\u5b58\u5728!";
        }
        ContractDetail contractDetail = this.thirdContractDetail(signMgrEntity.getSourceBillId(), false);
        this.logger.info("\u5355\u636e-\u3010id:{}\u3011\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540c\u8be6\u60c5: {}", (Object)JSONObject.toJSONString((Object)contractDetail));
        if (!contractDetail.getStatus().getDescription().equals(ContractStatus.SIGNING.getDescription())) {
            return "\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540c\u4e0d\u662f\u7b7e\u7f72\u4e2d\u72b6\u6001\uff0c\u4e0d\u80fd\u6267\u884c\u50ac\u7b7e\u64cd\u4f5c\uff01";
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"pid", (Object)signMgrEntity.getId());
        queryWrapper.eq((Object)"del_flag", (Object)0);
        queryWrapper.eq((Object)"job_status", (Object)1);
        SignMgrSignatoryEntity signMgrSignatoryEntity = (SignMgrSignatoryEntity)((Object)this.signMgrSignatoryService.getOne((Wrapper)queryWrapper));
        if (null == signMgrSignatoryEntity) {
            return "\u53ea\u80fd\u5bf9\u7b7e\u7f72\u4e2d\u7684\u5355\u636e\u6267\u884c\u53d1\u9001\u7b7e\u7ae0\u901a\u77e5\u64cd\u4f5c\uff01";
        }
        ContractServiceImpl contractService = new ContractServiceImpl(this.getSdkClient());
        try {
            if (signMgrSignatoryEntity.getSignatureType() == 0) {
                contractService.notify(signMgrEntity.getSourceBillId());
            } else {
                ContractQueryDTO dto = new ContractQueryDTO();
                dto.setContactId(signMgrEntity.getSourceBillId());
                contractService.notifyCloud(dto);
            }
        }
        catch (PrivateAppException e) {
            this.logger.error("\u5355\u636eid-\u3010{}\u3011\uff0c\u7f16\u7801-\u3010{}\u3011,\u540d\u79f0-\u3010{}\u3011\u8fdb\u884c\u50ac\u7b7e\u64cd\u4f5c\u8c03\u7528\u5951\u7ea6\u9501\u670d\u52a1\u5f02\u5e38\uff1a", new Object[]{signMgrEntity.getBillId(), signMgrEntity.getBillName(), signMgrEntity.getBillCode(), e});
            return null != e.getMessage() ? e.getMessage() : "\u8c03\u7528\u5951\u7ea6\u9501\u670d\u52a1\u53d1\u9001\u7b7e\u7ae0\u901a\u77e5\u5931\u8d25\uff01";
        }
        this.logger.info("\u5355\u636eid-\u3010{}\u3011\uff0c\u7f16\u7801-\u3010{}\u3011,\u540d\u79f0-\u3010{}\u3011\u8fdb\u884c\u50ac\u7b7e\u64cd\u4f5c\u8c03\u7528\u5951\u7ea6\u9501\u670d\u52a1\u6210\u529f\uff01", new Object[]{signMgrEntity.getBillId(), signMgrEntity.getBillName(), signMgrEntity.getBillCode()});
        return null;
    }

    private ContractDetail thirdContractDetail(Long sourceBillId, boolean countSeal) {
        ContractDetail detail;
        Assert.notNull((Object)sourceBillId, (String)"\u6839\u636e\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\u67e5\u8be2\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540c\u8be6\u60c5\uff0c\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)countSeal, (String)"\u6839\u636e\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\u67e5\u8be2\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540c\u8be6\u60c5\uff0c\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u662f\u5426\u7edf\u8ba1\u5370\u7ae0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ContractServiceImpl contractService = new ContractServiceImpl(this.getSdkClient());
        try {
            detail = contractService.detail(sourceBillId, Boolean.valueOf(true));
        }
        catch (PrivateAppException e) {
            this.logger.error("\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\uff1a{}\uff0c\u67e5\u8be2\u5408\u540c\u8be6\u60c5\u5f02\u5e38\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)sourceBillId, (Object)e);
            throw new BusinessException("\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u6839\u636e\u5408\u540cid\u67e5\u8be2\u5408\u540c\u8be6\u60c5\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
        }
        return detail;
    }

    private List<SignMgrPreviewVO> syncSignedContract(List<ContractVO> contracts) {
        ArrayList res = new ArrayList();
        SignMgrPreviewEntity spv = new SignMgrPreviewEntity();
        contracts.forEach(contract -> {
            try {
                File file = File.createTempFile(contract.getContractName(), ".pdf");
                OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);
                this.signMgrService.downloadHasSignedFile(contract.getThirdContractId(), out);
                Path target = Paths.get(file.getParent() + "/" + contract.getContractName() + ".pdf", new String[0]);
                Files.move(file.toPath(), target, StandardCopyOption.REPLACE_EXISTING);
                File file1 = new File(target.toString());
                String authority = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest().getHeader("authority");
                CommonResponse<List<AttachmentVO>> result = this.upload.uploadFile(file1, authority, contract.getSourceType(), contract.getContractId(), contract.getBillType(), "true", this.BASE_HOST);
                if (!result.isSuccess() || result.getData() == null) {
                    this.logger.error("\u6c34\u5370\u6587\u4ef6\u4e0a\u4f20\u6587\u4ef6\u4e2d\u5fc3\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}\uff0c\u8bf7\u6c42\u6587\u4ef6\u4e2d\u5fc3\u5165\u53c2\uff1acontract--{}", (Object)result.getMsg(), (Object)JSON.toJSONString((Object)contract, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
                    throw new BusinessException("\u6c34\u5370\u6587\u4ef6\u4e0a\u4f20\u6587\u4ef6\u4e2d\u5fc3\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + result.getMsg());
                }
                AttachmentVO attachment = (AttachmentVO)JSON.parseObject((String)JSON.toJSONString(((List)result.getData()).get(0)), AttachmentVO.class);
                spv.setDelFlag(DelFlagEnum.NORMAL.getDelFlag());
                spv.setBillId(attachment.getSourceId());
                spv.setBillType(attachment.getBillType());
                spv.setSourceType(attachment.getSourceType());
                spv.setFileId(attachment.getId());
                spv.setFileName(attachment.getFileName());
                spv.setFilePath(attachment.getFilePath());
                spv.setFileSize(attachment.getFileSize());
                spv.setOnlinePath(attachment.getOnlinePath());
                spv.setTruePath(attachment.getTruePath());
                res.add(spv);
                this.cleanFile(file1);
            }
            catch (IOException e) {
                throw new BusinessException(e.getMessage());
            }
        });
        Assert.notEmpty(res, (String)"\u540c\u6b65\u5408\u540c\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        this.signMgrPreviewService.saveBatch(res, 5);
        return BeanMapper.mapList(res, SignMgrPreviewVO.class);
    }

    private List<AttachmentVO> syncDownloadAndUploadSignedContract(List<ContractVO> contracts) {
        ArrayList<AttachmentVO> attachments = new ArrayList<AttachmentVO>();
        contracts.forEach(contract -> {
            try {
                File file = File.createTempFile(contract.getContractName(), ".pdf");
                OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);
                this.signMgrService.downloadHasSignedFile(contract.getThirdContractId(), out);
                Path target = Paths.get(file.getParent() + "/" + contract.getContractName() + ".pdf", new String[0]);
                Files.move(file.toPath(), target, StandardCopyOption.REPLACE_EXISTING);
                File file1 = new File(target.toString());
                String authority = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest().getHeader("authority");
                CommonResponse<List<AttachmentVO>> res = this.upload.uploadFile(file1, authority, contract.getSourceType(), contract.getContractId(), contract.getBillType(), "true", this.BASE_HOST);
                if (!res.isSuccess() || res.getData() == null) {
                    this.logger.error("\u6c34\u5370\u6587\u4ef6\u4e0a\u4f20\u6587\u4ef6\u4e2d\u5fc3\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}\uff0c\u8bf7\u6c42\u6587\u4ef6\u4e2d\u5fc3\u5165\u53c2\uff1acontract--{}", (Object)res.getMsg(), (Object)JSON.toJSONString((Object)contract, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
                    throw new BusinessException("\u6c34\u5370\u6587\u4ef6\u4e0a\u4f20\u6587\u4ef6\u4e2d\u5fc3\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg());
                }
                attachments.add((AttachmentVO)JSON.parseObject((String)JSON.toJSONString(((List)res.getData()).get(0)), AttachmentVO.class));
                this.cleanFile(file1);
            }
            catch (IOException e) {
                throw new BusinessException(e.getMessage());
            }
        });
        return attachments;
    }
}

