package com.ejianc.business.signaturemanage.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.signaturemanage.bean.SignMgrEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrLogEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrPreviewEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.enums.DelFlagEnum;
import com.ejianc.business.signaturemanage.enums.SignMgrSignatoryEnum;
import com.ejianc.business.signaturemanage.mapper.GlobalCallBackMapper;
import com.ejianc.business.signaturemanage.service.*;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.*;
import java.util.stream.Collectors;

@Service("globalCallBackService")
public class GlobalCallBackService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ISignMgrService signMgrService;
    private final ISignMgrSignatoryService signMgrSignatoryService;
    private final ISignMgrLogService signMgrLogService;
    private final ISignMgrPreviewService signMgrPreviewService;
    private final GlobalCallBackMapper globalCallBackMapper;
    // 外部系统接口
    private final IBillTypeApi billTypeApi; // 根据billType找工程名
    private final IUserApi userApi; //获取用户
    private final IPushMessageApi pushMessageApi; // 发送消息

    // 配置文件
    @Value("${common.env.base-host}")
    private String BASE_HOST;

	private final IAsyncInformService asyncInformService;

	public GlobalCallBackService(ISignMgrService signMgrService, ISignMgrSignatoryService signMgrSignatoryService, ISignMgrLogService signMgrLogService, ISignMgrPreviewService signMgrPreviewService, GlobalCallBackMapper globalCallBackMapper, IBillTypeApi billTypeApi, IUserApi userApi, IPushMessageApi pushMessageApi, IAsyncInformService asyncInformService) {
		this.signMgrService = signMgrService;
		this.signMgrSignatoryService = signMgrSignatoryService;
		this.signMgrLogService = signMgrLogService;
		this.signMgrPreviewService = signMgrPreviewService;
		this.globalCallBackMapper = globalCallBackMapper;
		this.billTypeApi = billTypeApi;
		this.userApi = userApi;
		this.pushMessageApi = pushMessageApi;
		this.asyncInformService = asyncInformService;
	}

	/**
     * 全局回调-文件作废
     *
     * @param map 回调参数
     * @return 回调参数
     */
    public Map<String, String> contractTerminate(Map<String, String> map) {
        logger.info("全局回调-文件作废，入参：map--{}", JSON.toJSONString(map, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        // todo : 全局回调-文件作废
        return map;
    }


    /**
     * 全局回调-文件过期
     *
     * @param map 回调参数
     * @return 回调参数
     */
    public Map<String, String> contractExpired(Map<String, String> map) {
        logger.info("全局回调-文件过期，入参：map--{}", JSON.toJSONString(map, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        // 逻辑删除签章信息
        // this.tombstoneSignData(map.get("contractId"), SignMgrSignatoryEnum.COMPLETED.getValue(), SignMgrSignatoryEnum.EXPIRED.getValue());
        this.tombstoneSignData(map.get("contractId"), SignMgrSignatoryEnum.COMPLETED.getValue(), SignMgrSignatoryEnum.EXPIRED.getValue());
        // 查询已经逻辑删除签署人信息
        List<SignMgrSignatoryEntity> signatoryEntityList = this.selectSignMgrSignatory(Long.valueOf(map.get("pid")));
        // 通知业务系统
        this.sendStatus(map.get("authority"), Long.valueOf(map.get("billId")), map.get("billType"),
                map.get("billRefCode"), SignMgrSignatoryEnum.EXPIRED.getValue(), Long.valueOf(map.get("pid")));
        logger.info("全局回调-文件过期，通知业务系统成功！");
        // 通知相关签署人
        this.sendMessage(signatoryEntityList, map.get("billType"), map.get("billCode"), map.get("contractName"), SignMgrSignatoryEnum.EXPIRED.getDescription());
        logger.info("全局回调-文件过期，通知相关签署人成功！");
        return map;
    }


    /**
     * 全局回调-文件全部签署完成
     *
     * @param map 回调参数
     * @return 回调参数
     */
    public Map<String, String> contractComplete(Map<String, String> map) {
        // 文件全部签署完成回调成功--{
        //     "callbackBusinessType":"CONTRACT",
        //             "tenantName":"云南工程建设总承包股份有限公司",
        //             "signatoriesInfo":"[{\"tenantId\":\"2940149858777051390\",\"tenantName\":\"\\u5317\\u4EAC\\u76CA\\u4F01\\u8054\\u79D1\\u6280\\u6709\\u9650\\u516C\\u53F8\",\"tenantType\":\"COMPANY\",\"receiverId\":\"2940148477009735713\",\"receiverName\":\"\\u90B9\\u5BCC\\u96C4\",\"receiverContact\":\"17600548718\",\"receiverType\":\"PERSONAL\",\"status\":\"COMPLETE\",\"serialNo\":1,\"sponsor\":false,\"operatorInfos\":[]},{\"tenantId\":\"2905355236628385838\",\"tenantName\":\"\\u4E91\\u5357\\u5DE5\\u7A0B\\u5EFA\\u8BBE\\u603B\\u627F\\u5305\\u80A1\\u4EFD\\u6709\\u9650\\u516C\\u53F8\",\"tenantType\":\"INNER_COMPANY\",\"receiverId\":\"2940148474610593798\",\"receiverName\":\"\\u7CFB\\u7EDF\\u7BA1\\u7406\\u5458\",\"receiverContact\":\"13120319591\",\"receiverType\":\"PERSONAL\",\"status\":\"COMPLETE\",\"serialNo\":2,\"sponsor\":true,\"operatorInfos\":[]}]",
        //             "contractId":"2940234542370402615",
        //             "tenantId":"2905355236628385838",
        //             "completeTime":"Sat Mar 12 20:07:01 GMT+08:00 2022",
        //             "callbackHeader":"{}",
        //             "documentId":"2940234541841920308",
        //             "callbackEventType":"ELECTRONIC",
        //             "sn":"null",
        //             "type":"CONTRACT_COMPLETE",
        //             "status":"COMPLETE"
        // }
        logger.info("全局回调-文件全部签署完成，入参：map--{}", JSON.toJSONString(map, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        // todo : 全局回调-文件全部签署完成
	    // 0.校验参数
	    Assert.notNull(map.get("contractId"), "全局回调-文件全部签署完成，第三方电子签章contractId不能为空！");
		Assert.hasText(map.get("authority"), "全局回调-文件全部签署完成，第三方电子签章authority不能为空！");

	    // 1.更新签章信息
	    LambdaQueryWrapper<SignMgrEntity> queryWrapper = new LambdaQueryWrapper<>();
	    queryWrapper.eq(SignMgrEntity::getDelFlag, DelFlagEnum.NORMAL.getDelFlag());
	    queryWrapper.eq(SignMgrEntity::getSourceBillId, map.get("contractId"));
	    SignMgrEntity entity = signMgrService.getOne(queryWrapper);
	    Assert.notNull(entity, "全局回调-文件全部签署完成，第三方电子签章信息不存在！");
	    if(!SignMgrSignatoryEnum.SIGNED.getValue().equals(entity.getSignStatus())) {
	        //更新主表签章状态
            LambdaUpdateWrapper<SignMgrEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(SignMgrEntity::getId, entity.getId());
            updateWrapper.set(SignMgrEntity::getSignStatus, SignMgrSignatoryEnum.SIGNED.getValue());
            updateWrapper.set(SignMgrEntity::getFinishTime, new Date());
            signMgrService.update(updateWrapper);
        }

	    LambdaUpdateWrapper<SignMgrSignatoryEntity> updateWrapper = new LambdaUpdateWrapper<>();
	    updateWrapper.eq(SignMgrSignatoryEntity::getDelFlag, DelFlagEnum.NORMAL.getDelFlag());
	    updateWrapper.eq(SignMgrSignatoryEntity::getPid, entity.getId());
	    updateWrapper.set(SignMgrSignatoryEntity::getJobStatus, SignMgrSignatoryEnum.COMPLETED.getValue());
	    updateWrapper.set(SignMgrSignatoryEntity::getSignResult, SignMgrSignatoryEnum.SIGNED.getValue());
	    boolean updateFlag = signMgrSignatoryService.update(updateWrapper);
	    Assert.isTrue(updateFlag, "全局回调-文件全部签署完成，更新签署动作签章状态失败！");

	    // 2.通知业务系统
	    asyncInformService.informBusinessSystem(entity.getBillType(), entity.getBillId(), entity.getBillRefCode(), SignMgrSignatoryEnum.SIGNED.getValue(),map.get("authority"));

        // 3.通知相关签署人(暂时不做)
        return map;
    }


    /**
     * 发起方回调-文件撤回
     *
     * @param map 回调参数
     * @return 回调参数
     */
    public Map<String, String> contractRecall(Map<String, String> map) {
        logger.info("发起方回调-文件撤回，入参：map--{}", JSON.toJSONString(map, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        // 逻辑删除签章信息
        this.tombstoneSignData(map.get("contractId"), SignMgrSignatoryEnum.COMPLETED.getValue(), SignMgrSignatoryEnum.WITHDRAWN.getValue());
        // 查询已经逻辑删除签署人信息
        List<SignMgrSignatoryEntity> signatoryEntityList = this.selectSignMgrSignatory(Long.valueOf(map.get("pid")));
        // 通知业务系统
        this.sendStatus(map.get("authority"), Long.valueOf(map.get("billId")), map.get("billType"),
                map.get("billRefCode"), SignMgrSignatoryEnum.WITHDRAWN.getValue(), Long.valueOf(map.get("pid")));
        logger.info("全局回调-文件过期，通知业务系统成功！");
        // 通知相关签署人
        this.sendMessage(signatoryEntityList, map.get("billType"), map.get("billCode"), map.get("contractName"), SignMgrSignatoryEnum.WITHDRAWN.getDescription());
        logger.info("全局回调-文件过期，通知相关签署人成功！");
        return map;
    }

    /**
     * // 接收方回调-文件退回
     *
     * @param map 回调参数
     * @return 回调参数
     */
    public Map<String, String> contractRejected(Map<String, String> map) {
        logger.info("接收方回调-文件退回，入参：map--{}", JSON.toJSONString(map, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        // 逻辑删除签章信息
        this.tombstoneSignData(map.get("contractId"), SignMgrSignatoryEnum.COMPLETED.getValue(), SignMgrSignatoryEnum.RETURNED.getValue());
        // 查询已经逻辑删除签署人信息
        List<SignMgrSignatoryEntity> signatoryEntityList = this.selectSignMgrSignatory(Long.valueOf(map.get("pid")));
        // 通知业务系统
        this.sendStatus(map.get("authority"), Long.valueOf(map.get("billId")), map.get("billType"),
                map.get("billRefCode"), SignMgrSignatoryEnum.RETURNED.getValue(), Long.valueOf(map.get("pid")));
        logger.info("全局回调-文件过期，通知业务系统成功！");
        // 通知相关签署人
        this.sendMessage(signatoryEntityList, map.get("billType"), map.get("billCode"), map.get("contractName"), SignMgrSignatoryEnum.RETURNED.getDescription());
        logger.info("全局回调-文件过期，通知相关签署人成功！");
        return map;
    }


    /**
     * 接收方回调-所有接收方签署完成
     *
     * @param map 回调参数
     * @return 回调结果
     */
    public Map<String, String> contractAllReceiverSignatoryComplete(Map<String, String> map) {
        logger.info("接收方回调-所有接收方签署完成，入参：map--{}", JSON.toJSONString(map, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        // todo : 接收方回调-所有接收方签署完成
        return map;
    }


    /**
     * 逻辑删除签章数据并修改状态
     *
     * @param sourceBillId 契约锁合同id
     * @param jobStatus    实际签章状态
     * @param status       状态
     */
    public void tombstoneSignData(String sourceBillId, Integer jobStatus, Integer status) {
        logger.info("逻辑删除签章数据，入参：sourceBillId--{}，jobStatus--{}，status--{}", sourceBillId, jobStatus, status);
        // globalCallBackMapper.tombstoneSignData(Long.valueOf(sourceBillId), jobStatus, status);

        QueryWrapper<SignMgrEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("del_flag", 0);
        queryWrapper.eq("source_bill_id", sourceBillId);
        SignMgrEntity signMgrEntity = signMgrService.getOne(queryWrapper);

        // 主表
        LambdaUpdateWrapper<SignMgrEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SignMgrEntity::getId, signMgrEntity.getId());
        updateWrapper.set(SignMgrEntity::getDelFlag, DelFlagEnum.DELETE.getDelFlag());
        updateWrapper.set(SignMgrEntity::getSignStatus, status);
        boolean updateFlag = signMgrService.update(updateWrapper);
        Assert.isTrue(updateFlag, "逻辑删除签章数据，更新签章流程主表签章状态失败！");

        // 子表
        QueryWrapper<SignMgrSignatoryEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("del_flag", 0);
        queryWrapper1.eq("pid", signMgrEntity.getId());
        List<SignMgrSignatoryEntity> signatoryList = signMgrSignatoryService.list(queryWrapper1);
        signatoryList.parallelStream().peek(e -> {
            e.setDelFlag(1);
            e.setJobStatus(jobStatus);
            e.setSignResult(status);
        }).collect(Collectors.toList());
        signMgrSignatoryService.saveOrUpdateBatch(signatoryList);

        // 日志表
        QueryWrapper<SignMgrLogEntity> queryWrapper2 = new QueryWrapper<>();
        queryWrapper2.eq("del_flag", 0);
        queryWrapper2.eq("bill_id", signMgrEntity.getBillId());
        List<SignMgrLogEntity> logList = signMgrLogService.list(queryWrapper2);
        if (!logList.isEmpty()) {
            logList.parallelStream().peek(e -> {
                e.setDelFlag(1);
            }).collect(Collectors.toList());
            // todo : 是否存异常记录日志
            signMgrLogService.saveOrUpdateBatch(logList);
        }


        // 预览表
        QueryWrapper<SignMgrPreviewEntity> queryWrapper3 = new QueryWrapper<>();
        queryWrapper3.eq("del_flag", 0);
        queryWrapper3.eq("bill_id", signMgrEntity.getBillId());
        List<SignMgrPreviewEntity> previewList = signMgrPreviewService.list(queryWrapper3);
        if (!previewList.isEmpty()) {
            previewList.parallelStream().peek(e -> {
                e.setDelFlag(1);
            }).collect(Collectors.toList());
            signMgrPreviewService.saveOrUpdateBatch(previewList);
        }

    }


    /**
     * 查询逻辑删除的签署动作
     *
     * @param pid 父id
     * @return List<SignMgrSignatoryEntity>
     */
    public List<SignMgrSignatoryEntity> selectSignMgrSignatory(Long pid) {
        QueryWrapper<SignMgrSignatoryEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("pid", pid);
        return signMgrSignatoryService.list(queryWrapper);
    }


    /**
     * 通知业务系统
     *  @param authority   上下文
     * @param billId      单据id
     * @param billType    单据类型
     * @param billRefCode 单据参考码
     * @param status      状态
     * @param pid
     */
    public void sendStatus(String authority, Long billId, String billType, String billRefCode, Integer status, Long pid) {
        //更新主表签章流程状态
        LambdaQueryWrapper<SignMgrEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SignMgrEntity::getId, pid);
        SignMgrEntity signMgrEntity = signMgrService.getOne(queryWrapper);

        //更新
        LambdaUpdateWrapper<SignMgrEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SignMgrEntity::getId, signMgrEntity.getId());
        updateWrapper.set(SignMgrEntity::getSignStatus, status);
        if(SignMgrSignatoryEnum.WITHDRAWN.getValue().equals(status) && DelFlagEnum.NORMAL.getDelFlag().equals(signMgrEntity.getDelFlag())) {
            updateWrapper.set(SignMgrEntity::getDelFlag, DelFlagEnum.DELETE.getDelFlag());
        }
        if(SignMgrSignatoryEnum.getFinishStatus().contains(status)) {
            //如果流程已结束，则设置流程结束时间
            updateWrapper.set(SignMgrEntity::getFinishTime, new Date());
        }
        boolean updateMainSignStatusFlag = signMgrService.update(updateWrapper);
        Assert.isTrue(updateMainSignStatusFlag, "通知业务系统签章状态，更新签章流程主表签章状态失败！");

        //根据单据类型查询元数据信息
        CommonResponse<MdReferVO> mdRefResp = billTypeApi.queryMetadataByBillType(billType);
        if (!mdRefResp.isSuccess()) {
            logger.error("签章状态更新失败,根据billType-{}查询元数据信息失败,原因：{}！", billType, mdRefResp.getMsg());
        }
        MdReferVO mdRef = mdRefResp.getData();
        String entityName = mdRef.getEntityName().replace("Entity", "") + "Signature";
        String apiUrl = entityName.substring(0, 1).toLowerCase() + entityName.substring(1);
        //获取到对应工程信息，调用指定工程
        String sendUrl = BASE_HOST + mdRef.getProjectName() + "/" + apiUrl + "/changeStatus";
        Map<String, Object> param = new HashMap<>();
        param.put("billId", billId);
        // 合同和变更合同区分字段
        param.put("refCode", billRefCode);
        param.put("status", status);

        try {
            Map<String, String> headerMap = new HashMap<>();
            headerMap.put("authority", authority);
            headerMap.put("content-type", "application/json;charset=UTF-8");
            String httpRespStr = HttpTookit.postByJson(Objects.requireNonNull(sendUrl), JSONObject.toJSONString(param), headerMap, 10000, 10000);
            logger.info("调用业务系统url-{},param-{},签章状态结果：{}", sendUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue), httpRespStr);
            if (!StringUtils.isEmpty(httpRespStr)) {
                JSONObject resultJson = JSONObject.parseObject(httpRespStr);
                String code = resultJson.getString("code");
                if (Integer.parseInt(code) != 0) {
                    // 业务系统处理失败，补偿机制
                    logger.error("调用业务系统成功，返回结果失败!");
                }
            }

        } catch (Exception e) {
            logger.error("调用业务系统url-{},param-{},签章状态异常：", sendUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue), e);
        }
    }


    /**
     * 消息通知
     *
     * @param s            签署动作
     * @param billType     单据类型
     * @param billCode     单据编号
     * @param contractName 合同名称
     * @param status       状态
     */
    public void sendMessage(List<SignMgrSignatoryEntity> s, String billType, String billCode, String contractName, String status) {
        PushMsgParameter parameter = new PushMsgParameter();
        // 消息发送渠道类型
        String[] channel;
        // 消息类型(应该是枚举)
        String msgType = "notice";
        // 接收人
        String[] receivers;
        // 消息主题
        String subject = "电子签章-" + status;
        // 消息内容
        String content = "你的文件【" + billType + "_" + billCode + "_" + contractName + "】 " + status + "!";

        ArrayList<String> lst = new ArrayList<>();
        lst.add("sys");
        channel = lst.toArray(new String[lst.size()]);

        Set<String> userIds = s.parallelStream().filter(e -> SignMgrSignatoryEnum.INTERNAL_UNIT.getValue().equals(e.getSignatureType())).map(e -> String.valueOf(e.getSignatureId())).collect(Collectors.toSet());
        receivers = userIds.toArray(new String[userIds.size()]);

        // 租户ID
        CommonResponse<UserVO> user = userApi.findUserByUserId(Long.valueOf(userIds.iterator().next()));
        if (!user.isSuccess()) {
            logger.error("消息推送失败，无法获取用户信息，原因：{}", JSONObject.toJSONString(user, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        }
        String tenantId = String.valueOf(user.getData().getTenantId());

        parameter.setChannel(channel);
        parameter.setReceivers(receivers);
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(tenantId);

        CommonResponse<String> response = pushMessageApi.pushMessage(parameter);
        if (!response.isSuccess()) {
            logger.error("消息推送失败，原因：{}", JSONObject.toJSONString(response, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        }
    }


}
