package com.ejianc.business.signaturemanage.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.mapper.SignMgrSignatoryMapper;
import com.ejianc.business.signaturemanage.service.ISignMgrSignatoryService;
import com.ejianc.business.signaturemanage.vo.SignatureCenterVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 签章管理-签署方子表
 *
 * @author generator
 */
@Service("signMgrSignatoryService")
public class SignMgrSignatoryServiceImpl extends BaseServiceImpl<SignMgrSignatoryMapper, SignMgrSignatoryEntity> implements ISignMgrSignatoryService {

	@Autowired
	private SignMgrSignatoryMapper mapper;


	/**
	 * 签章中心分页查询
	 *
	 * @param tenantId         租户ID
	 * @param signatureContact 签署人手机号
	 * @param jobStatus        签章状态
	 *
	 * @return 签章中心分页
	 */
	@Override
	public IPage<SignatureCenterVO> querySignCenterPage(Page<SignatureCenterVO> page,
	                                                    Long tenantId,
	                                                    String signatureContact,
	                                                    Integer jobStatus,
	                                                    String billName,
	                                                    String billCode,
	                                                    String contractName,
	                                                    String projectName,
	                                                    String useSealType,
	                                                    String sortField) {
		return mapper.querySignCenterPage(page, tenantId, signatureContact, jobStatus, billName, billCode, contractName, projectName, useSealType, sortField);
	}

	@Override
	public String getFirstNoPsSealSourceCompanyName(Long contractId) {
		 List<String> sourceCompanyNames = mapper.getFirstNoPsSealSourceCompanyName(contractId);
		return CollectionUtils.isNotEmpty(sourceCompanyNames) ? sourceCompanyNames.get(0) : null;
	}
}
