package com.ejianc.business.signaturemanage.service;

import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.foundation.file.vo.AttachmentVO;

import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 * @author baipengyan
 * @date 2022/5/17
 * @description
 */
public interface ISignatureCommonService {

	/**
	 * 合同添加水印
	 *
	 * @param watermarkVO 合同文件添加水印参数
	 */
	File addWatermark(WatermarkVO watermarkVO);

	/**
	 * 删除临时文件
	 *
	 * @param file 要删除的文件
	 */
	void cleanFile(File file) throws IOException;

	/**
	 * 水印文件上传文件中心
	 *
	 * @param file        水印文件
	 * @param authority   上下文
	 * @param watermarkVO 合同文件添加水印参数
	 *
	 * @return AttachmentVO 水印附件
	 */
	AttachmentVO fetchAttachment(File file, String authority, WatermarkVO watermarkVO);

	/**
	 * @param fileId     要加水印的文件id
	 * @param billId     业务id
	 * @param billCode   合同编码
	 * @param billType   单据类型编码
	 * @param sourceType 业务类型编码
	 *
	 * @return WatermarkVO 水印配置
	 */
	WatermarkVO watermarkConfigConvert(Long fileId, Long billId, String billCode, String billType, String sourceType);

	/**
	 * 根据合同ids获取文件中心已签章的合同信息
	 *
	 * @param contracts 合同
	 *
	 * @return List<SignMgrPreviewVO> 已签章的合同信息
	 */
	List<SignMgrPreviewVO> fetchSignedContract(List<ContractVO> contracts);

	/**
	 * 根据单据Id向当前签章节点操作人发送签署短信
	 *
	 * @param billId
	 * @return
	 */
    String notifySignOperatorByBillId(Long billId);

	/**
	 * 根据签章流程Id向当前签章节点操作人发送签署短信
	 *
	 * @param id
	 * @return
	 */
	String notifySignOperatorById(Long id);
}
