/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConvert {
    private final Logger logger = LoggerFactory.getLogger(FileConvert.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileToBase64(File file) {
        String base64 = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] bytes = new byte[((InputStream)in).available()];
            ((InputStream)in).read(bytes);
            base64 = Base64.getEncoder().encodeToString(bytes);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return base64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File base64ToFile(String base64, String fileName) {
        File file = null;
        FileOutputStream out = null;
        try {
            file = File.createTempFile(fileName, ".pdf");
            byte[] bytes = Base64.getDecoder().decode(base64);
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            byte[] buffer = new byte[1024];
            out = new FileOutputStream(file);
            int bytesum = 0;
            int byteread = 0;
            while ((byteread = in.read(buffer)) != -1) {
                bytesum += byteread;
                out.write(buffer, 0, byteread);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    @Test
    void test() {
        String base64 = FileConvert.fileToBase64(new File("/Users/baipengyan/Downloads/test.pdf"));
        this.logger.info("base64:{}", (Object)base64);
        File file = FileConvert.base64ToFile(base64, "test----");
        if (file != null && file.exists()) {
            this.logger.info("filePath:{}", (Object)file.getAbsolutePath());
            file.delete();
        }
    }
}

