/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.controller.api;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.signaturemanage.enums.WatermarkSchemeEnum;
import com.ejianc.business.signaturemanage.service.IManagementService;
import com.ejianc.business.signaturemanage.service.ISignatureCommonService;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.ManagementVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.google.common.base.Stopwatch;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common"})
public class SignatureCommonApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISignatureCommonService service;
    @Autowired
    private IManagementService managementService;
    @Autowired
    private IOrgApi iOrgApi;

    @PostMapping(value={"/addWatermark"}, consumes={"application/json;charset=UTF-8"})
    public void addWatermark(@Validated @RequestBody WatermarkVO watermarkVO, HttpServletResponse response) throws IOException {
        watermarkVO = this.service.addWatermark(watermarkVO);
        File file = watermarkVO.getResultFile();
        Assert.notNull((Object)file, (String)"\u5408\u540c\u6587\u4ef6\u6dfb\u52a0\u6c34\u5370\u5931\u8d25\uff01");
        BufferedInputStream in = FileUtil.getInputStream((File)watermarkVO.getResultFile());
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Disposition", "attachment;fileName=" + file.getName());
        response.setContentType("application/pdf");
        ServletOutputStream out = response.getOutputStream();
        IoUtil.copy((InputStream)in, (OutputStream)out);
        out.flush();
        in.close();
        out.close();
        this.service.cleanFile(file);
    }

    @PostMapping(value={"/fetchWatermarkAttachment"})
    public AttachmentVO fetchWatermarkAttachment(@Validated @RequestBody WatermarkVO watermarkVO, HttpServletRequest request) throws IOException {
        this.logger.info("\u83b7\u53d6\u52a0\u6c34\u5370\u7684\u5408\u540c\u9644\u4ef6\uff0c\u5f00\u59cb");
        Stopwatch start = Stopwatch.createStarted();
        String authority = request.getHeader("authority");
        Assert.hasText((String)authority, (String)"\u83b7\u53d6\u52a0\u6c34\u5370\u7684\u5408\u540c\u9644\u4ef6\uff0c\u4e0a\u4e0b\u6587\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        watermarkVO = this.service.addWatermark(watermarkVO);
        if (!WatermarkSchemeEnum.PM_FILE_SYSTEM.getCode().equals(watermarkVO.getScheme())) {
            Assert.notNull((Object)watermarkVO.getResultFile(), (String)"\u5408\u540c\u6587\u4ef6\u6dfb\u52a0\u6c34\u5370\u5931\u8d25\uff01");
            Stopwatch end = start.stop();
            this.logger.info("\u6dfb\u52a0\u6c34\u5370\uff0c\u7ed3\u675f\u3002\u5171\u8ba1\u8017\u65f6\uff1a\u300c{}\u300d\u79d2", (Object)end.elapsed(TimeUnit.SECONDS));
            Stopwatch start1 = Stopwatch.createStarted();
            Assert.notNull((Object)watermarkVO.getBillId(), (String)"\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.hasText((String)watermarkVO.getBillType(), (String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.hasText((String)watermarkVO.getSourceType(), (String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            AttachmentVO attachmentVO = this.service.fetchAttachment(watermarkVO.getResultFile(), authority, watermarkVO);
            watermarkVO.setResultAttach(attachmentVO);
            this.service.cleanFile(watermarkVO.getResultFile());
            Stopwatch end1 = start1.stop();
            this.logger.info("\u83b7\u53d6\u52a0\u6c34\u5370\u7684\u5408\u540c\u9644\u4ef6\uff0c\u7ed3\u675f\u3002\u5171\u8ba1\u8017\u65f6\uff1a\u300c{}\u300d\u79d2", (Object)end1.elapsed(TimeUnit.SECONDS));
        }
        return watermarkVO.getResultAttach();
    }

    @GetMapping(value={"/fetchWatermarkConfig"})
    public WatermarkVO fetchWatermarkConfig(@RequestParam(value="fileId", required=true) Long fileId, @RequestParam(value="billId", required=true) Long billId, @RequestParam(value="billCode", required=true) String billCode, @RequestParam(value="billType", required=true) String billType, @RequestParam(value="sourceType", required=true) String sourceType) {
        return this.service.watermarkConfigConvert(fileId, billId, billCode, billType, sourceType);
    }

    @PostMapping(value={"/fetchSignedContract"})
    public CommonResponse<List<SignMgrPreviewVO>> fetchSignedContract(@Validated @RequestBody List<ContractVO> contracts) {
        return CommonResponse.success(this.service.fetchSignedContract(contracts));
    }

    @GetMapping(value={"/signatureManagementRef"})
    public CommonResponse<IPage<ManagementVO>> signatureManagementRef(@RequestParam(value="pageNumber", required=true) Integer pageNumber, @RequestParam(value="pageSize", required=true) Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchObject", required=false) String searchObject, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("sourceSealName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", (Object)this.iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId())));
        IPage page = this.managementService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ManagementVO.class));
        return CommonResponse.success((String)"\u5370\u7ae0\u7ba1\u7406\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)pageData);
    }
}

