/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.signaturemanage.service.ISignatureRectService;
import com.ejianc.business.signaturemanage.vo.SignatureVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/signatureRect"})
public class SignatureRectController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ISignatureRectService service;

    public SignatureRectController(ISignatureRectService service) {
        this.service = service;
    }

    @GetMapping(value={"/deleteSignatureRect"})
    public CommonResponse<String> deleteSignatureRect(@NotNull(message="PM\u7cfb\u7edf\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\uff01") @RequestParam(value="contractId") @NotNull(message="PM\u7cfb\u7edf\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\uff01") Long contractId) {
        this.service.deleteSignatureRect(contractId);
        return CommonResponse.success((String)"\u5220\u9664\u7b7e\u7ae0\u5408\u540c\u6570\u636e\u6210\u529f");
    }

    @PostMapping(value={"/fetchPreSignUrl"})
    public CommonResponse<String> fetchPreSignUrl(@Valid @RequestBody SignatureVO signatureVO) {
        return CommonResponse.success((String)"\u83b7\u53d6\u9884\u7b7e\u7f72\u94fe\u63a5\uff0c\u8bf7\u6c42\u6210\u529f\uff01", (Object)this.service.fetchPreSignUrl(signatureVO));
    }

    @GetMapping(value={"/sendSignature"})
    public CommonResponse<String> sendSignature(@NotNull(message="PM\u7cfb\u7edf\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\uff01") @RequestParam(value="contractId") @NotNull(message="PM\u7cfb\u7edf\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\uff01") Long contractId) {
        this.service.sendSignature(contractId);
        return CommonResponse.success((String)("\u5f53\u524d\u5408\u540cid\uff1a" + contractId + "\uff0c\u53d1\u8d77\u7b7e\u7ae0\u6210\u529f\uff01"));
    }

    @PostMapping(value={"/recallContract"})
    public CommonResponse<String> recallContract(@RequestBody String contractRecallParamStr) {
        String rs;
        this.logger.info("\u3010\u7b7e\u7ae0\u64a4\u56de\u3011\u7528\u6237-{}\u6267\u884c\u5355\u636e\u7b7e\u7ae0\u64a4\u56de\u64cd\u4f5c\uff0c\u53c2\u6570-{}", (Object)InvocationInfoProxy.getUserid(), (Object)contractRecallParamStr);
        if (StringUtils.isBlank((CharSequence)contractRecallParamStr)) {
            return CommonResponse.error((String)"\u5408\u540c\u7b7e\u7ae0\u64a4\u56de\u5931\u8d25\uff0c\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        JSONObject jsonParam = JSONObject.parseObject((String)contractRecallParamStr);
        Long billId = jsonParam.getLong("contractId");
        String recallReason = jsonParam.getString("recallReason");
        if (StringUtils.isBlank((CharSequence)recallReason)) {
            recallReason = "PM\u5e73\u53f0\u7528\u6237\u64a4\u56de\u7b7e\u7ae0";
        }
        if (StringUtils.isNotBlank((CharSequence)(rs = this.service.recallContract(billId, recallReason)))) {
            return CommonResponse.error((String)rs);
        }
        return CommonResponse.success((String)"\u64a4\u56de\u5408\u540c\u6210\u529f\uff01");
    }
}

