package com.ejianc.business.signaturemanage.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.util.Date;

/**
 * 签章管理-签署方子表
 *
 * @author generator
 */
@TableName("ejc_signmgr_signatory")
public class SignMgrSignatoryEntity extends BaseEntity {
	private static final long serialVersionUID = 1L;

	@TableField("del_flag")
	private Integer delFlag; // 0-未删除，1-已删除
	@TableField(value = "signature_type")
	private Integer signatureType; // 签署方类型：0-内部单位，1-外部单位
	@TableField(value = "tenant_name")
	private String tenantName; // 签约主体名称
	@TableField(value = "tenant_type")
	private String tenantType; // 签约主体类型：COMPANY（外部企业），PERSONAL（个人）

	@TableField(value = "receiver_name")
	private String receiverName; // 接收人姓名
	@TableField(value = "contact")
	private String contact; // 接收人手机号

	@TableField(value = "signature_id")
	private Long signatureId; // 签署方Id，我们平台内的签署方id（外部单位为空）
	@TableField(value = "signature_name")
	private String signatureName; // 签署方名称,我们平台内的签署方名称
	@TableField(value = "signature_contact")
	private String signatureContact; // 签署方手机号
	@TableField(value = "sign_order")
	private Integer signOrder; // 签署顺序,前置设置1，后置逐渐增大，无序设置相同
	@TableField(value = "sign_action_type")
	private String signActionType; // 签署动作类型:CORPORATE（企业签 章），PERSONAL（个人签字），LP（法 定代表人签字）
	@TableField(value = "name")
	private String name; // 签署动作名称,根据签署动作类型填写
	@TableField(value = "source_seal_id")
	private String sourceSealId; // 印章id第三方系统返回的）
	@TableField(value = "source_seal_name")
	private String sourceSealName; // 印章name（第三方系统返回的）
	@TableField(value = "seal_id")
	private String sealId; // 平台印章id
	@TableField(value = "seal_name")
	private String sealName; // 平台印章name
	@TableField(value = "signature_user_ids")
	private String signatureUserIds; // 印章使用平台用户id范围（静态）多个逗号分隔

	@TableField(value = "signatory_no")
	private String signatoryNo; // 签署方编号
	@TableField(value = "action_no")
	private String actionNo; // 签署动作编号，唯一

	@TableField(value = "actual_signatory_id")
	private Long actualSignatoryId; // 实际签署方Id，我们平台内的签署方id（外部单位为空）
	@TableField(value = "actual_signatory_name")
	private String actualSignatoryName; // 实际签署人
	@TableField(value = "actual_signatory_contact")
	private String actualSignatoryContact; // 实际签署人联系方式
	@TableField(value = "seal_sign_order")
	private Integer sealSignOrder; // 签章顺序,前置设置1，后置逐渐增大，无序设置相同
	@TableField(value = "job_status")
	private Integer jobStatus; // 0-待激活，1-待签章，2-已完成
	@TableField(value = "sign_result")
	private Integer signResult; // 1-待签章,2-待乙方签章,3-待甲方签章,4-已签章（已完成）,5-已退回（已拒签）,6-已撤回,7-已过期,8-其他
	@TableField(value = "mark")
	private String mark; // 备注，描述签署状态
	@TableField(value = "start_time")
	private Date startTime; // 开始时间：状态由待激活变为待签章，可以开始签署动作的时间
	@TableField(value = "end_time")
	private Date endTime; // 结束时间：状态为完成签署动作的时间
	@TableField(value = "accept_time")
	private Date acceptTime; // 接收时间
	@TableField(value = "pid")
	private Long pid; // 签章管理表id


	@TableField(value = "offset_x")
	private Double offsetX; // 指定签署位置的X轴坐标（以文档左下角为原点）
	@TableField(value = "offset_y")
	private Double offsetY; // 指定签署位置的Y轴坐标（以文档左下角为原点）
	@TableField(value = "page")
	private Integer page; // 签署页码，坐标指定位置时必须，0:全部页，-1:最后一页，其他:第page页
	@TableField(value = "keywords")
	private String keywords; // 定位到合同文档中的关键字
	@TableField(value = "keyword_index")
	private Integer keywordIndex; // 第几个关键字,0:全部,-1:最后一个,其他:第keyIndex个,默认为1
	@TableField(value = "time_stamp_flag")
	private Boolean timeStampFlag;// 是否启用时间戳，0-否，1-是
	@TableField(value = "time_stamp_key_words")
	private String timeStampKeyWords;// 时间戳关键字
	@TableField(value = "across_flag")
	private Boolean acrossFlag;// 是否开启骑缝章，0-否，1-是
	@TableField(value = "across_setting")
	private String acrossSetting;// 骑缝章设置，ACROSS_PAGE-添加至全部页；ACROSS_PAGE_ODD-添加至奇数页；默认全页


	public Integer getDelFlag() {
		return delFlag;
	}

	public void setDelFlag(Integer delFlag) {
		this.delFlag = delFlag;
	}

	/**
	 * 签署方类型：0-内部单位，1-外部单位
	 */
	public Integer getSignatureType() {
		return signatureType;
	}

	/**
	 * 签署方类型：0-内部单位，1-外部单位
	 */
	public void setSignatureType(Integer signatureType) {
		this.signatureType = signatureType;
	}

	/**
	 * 签约主体名称
	 */
	public String getTenantName() {
		return tenantName;
	}

	/**
	 * 签约主体名称
	 */
	public void setTenantName(String tenantName) {
		this.tenantName = tenantName;
	}

	/**
	 * 签约主体类型：COMPANY（外部企业），PERSONAL（个人）
	 */
	public String getTenantType() {
		return tenantType;
	}

	/**
	 * 签约主体类型：COMPANY（外部企业），PERSONAL（个人）
	 */
	public void setTenantType(String tenantType) {
		this.tenantType = tenantType;
	}

	/**
	 * 接收人姓名
	 */
	public String getReceiverName() {
		return receiverName;
	}

	/**
	 * 接收人姓名
	 */
	public void setReceiverName(String receiverName) {
		this.receiverName = receiverName;
	}

	/**
	 * 接收人手机号
	 */
	public String getContact() {
		return contact;
	}

	/**
	 * 接收人手机号
	 */
	public void setContact(String contact) {
		this.contact = contact;
	}

	/**
	 * 签署方Id，我们平台内的签署方id（外部单位为空）
	 */
	public Long getSignatureId() {
		return signatureId;
	}

	/**
	 * 签署方Id，我们平台内的签署方id（外部单位为空）
	 */
	public void setSignatureId(Long signatureId) {
		this.signatureId = signatureId;
	}

	/**
	 * 签署方名称,我们平台内的签署方名称
	 */
	public String getSignatureName() {
		return signatureName;
	}

	/**
	 * 签署方名称,我们平台内的签署方名称
	 */
	public void setSignatureName(String signatureName) {
		this.signatureName = signatureName;
	}

	/**
	 * 签署方手机号
	 */
	public String getSignatureContact() {
		return signatureContact;
	}

	/**
	 * 签署方手机号
	 */
	public void setSignatureContact(String signatureContact) {
		this.signatureContact = signatureContact;
	}

	/**
	 * 签署顺序,前置设置1，后置逐渐增大，无序设置相同
	 */
	public Integer getSignOrder() {
		return signOrder;
	}

	/**
	 * 签署顺序,前置设置1，后置逐渐增大，无序设置相同
	 */
	public void setSignOrder(Integer signOrder) {
		this.signOrder = signOrder;
	}

	/**
	 * 签署动作类型:CORPORATE（企业签 章），PERSONAL（个人签字），LP（法 定代表人签字）
	 */
	public String getSignActionType() {
		return signActionType;
	}

	/**
	 * 签署动作类型:CORPORATE（企业签 章），PERSONAL（个人签字），LP（法 定代表人签字）
	 */
	public void setSignActionType(String signActionType) {
		this.signActionType = signActionType;
	}

	/**
	 * 签署动作名称,根据签署动作类型填写
	 */
	public String getName() {
		return name;
	}

	/**
	 * 签署动作名称,根据签署动作类型填写
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * 印章id第三方系统返回的）
	 */
	public String getSourceSealId() {
		return sourceSealId;
	}

	/**
	 * 印章id第三方系统返回的）
	 */
	public void setSourceSealId(String sourceSealId) {
		this.sourceSealId = sourceSealId;
	}

	/**
	 * 印章name（第三方系统返回的）
	 */
	public String getSourceSealName() {
		return sourceSealName;
	}

	/**
	 * 印章name（第三方系统返回的）
	 */
	public void setSourceSealName(String sourceSealName) {
		this.sourceSealName = sourceSealName;
	}

	/**
	 * 平台印章id
	 */
	public String getSealId() {
		return sealId;
	}

	/**
	 * 平台印章id
	 */
	public void setSealId(String sealId) {
		this.sealId = sealId;
	}

	/**
	 * 平台印章name
	 */
	public String getSealName() {
		return sealName;
	}

	/**
	 * 平台印章name
	 */
	public void setSealName(String sealName) {
		this.sealName = sealName;
	}

	/**
	 * 印章使用平台用户id范围（静态）多个逗号分隔
	 */
	public String getSignatureUserIds() {
		return signatureUserIds;
	}

	/**
	 * 印章使用平台用户id范围（静态）多个逗号分隔
	 */
	public void setSignatureUserIds(String signatureUserIds) {
		this.signatureUserIds = signatureUserIds;
	}

	/**
	 * 签署方编号
	 */
	public String getSignatoryNo() {
		return signatoryNo;
	}

	/**
	 * 签署方编号
	 */
	public void setSignatoryNo(String signatoryNo) {
		this.signatoryNo = signatoryNo;
	}

	/**
	 * 签署动作编号，唯一
	 */
	public String getActionNo() {
		return actionNo;
	}

	/**
	 * 签署动作编号，唯一
	 */
	public void setActionNo(String actionNo) {
		this.actionNo = actionNo;
	}

	/**
	 * 实际签署方Id，我们平台内的签署方id（外部单位为空）
	 */
	public Long getActualSignatoryId() {
		return actualSignatoryId;
	}

	/**
	 * 实际签署方Id，我们平台内的签署方id（外部单位为空）
	 */
	public void setActualSignatoryId(Long actualSignatoryId) {
		this.actualSignatoryId = actualSignatoryId;
	}

	/**
	 * 实际签署人
	 */
	public String getActualSignatoryName() {
		return actualSignatoryName;
	}

	/**
	 * 实际签署人
	 */
	public void setActualSignatoryName(String actualSignatoryName) {
		this.actualSignatoryName = actualSignatoryName;
	}

	/**
	 * 实际签署人联系方式
	 */
	public String getActualSignatoryContact() {
		return actualSignatoryContact;
	}

	/**
	 * 实际签署人联系方式
	 */
	public void setActualSignatoryContact(String actualSignatoryContact) {
		this.actualSignatoryContact = actualSignatoryContact;
	}

	/**
	 * 签章顺序,前置设置1，后置逐渐增大，无序设置相同
	 */
	public Integer getSealSignOrder() {
		return sealSignOrder;
	}

	/**
	 * 签章顺序,前置设置1，后置逐渐增大，无序设置相同
	 */
	public void setSealSignOrder(Integer sealSignOrder) {
		this.sealSignOrder = sealSignOrder;
	}

	/**
	 * 0-待激活，1-待签章，2-已完成
	 */
	public Integer getJobStatus() {
		return jobStatus;
	}

	/**
	 * 0-待激活，1-待签章，2-已完成
	 */
	public void setJobStatus(Integer jobStatus) {
		this.jobStatus = jobStatus;
	}

	/**
	 * 已签章（已完成）-1，已退回（已拒签）-2，已撤回-3，已过期-4，其他-5
	 */
	public Integer getSignResult() {
		return signResult;
	}

	/**
	 * 已签章（已完成）-1，已退回（已拒签）-2，已撤回-3，已过期-4，其他-5
	 */
	public void setSignResult(Integer signResult) {
		this.signResult = signResult;
	}

	/**
	 * 备注，描述签署状态
	 */
	public String getMark() {
		return mark;
	}

	/**
	 * 备注，描述签署状态
	 */
	public void setMark(String mark) {
		this.mark = mark;
	}

	/**
	 * 开始时间：状态由待激活变为待签章，可以开始签署动作的时间
	 */
	public Date getStartTime() {
		return startTime;
	}

	/**
	 * 开始时间：状态由待激活变为待签章，可以开始签署动作的时间
	 */
	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	/**
	 * 结束时间：状态为完成签署动作的时间
	 */
	public Date getEndTime() {
		return endTime;
	}

	/**
	 * 结束时间：状态为完成签署动作的时间
	 */
	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Date getAcceptTime() {
		return acceptTime;
	}

	public void setAcceptTime(Date acceptTime) {
		this.acceptTime = acceptTime;
	}

	/**
	 * 签章管理表id
	 */
	public Long getPid() {
		return pid;
	}

	/**
	 * 签章管理表id
	 */
	public void setPid(Long pid) {
		this.pid = pid;
	}

	public Double getOffsetX() {
		return offsetX;
	}

	public void setOffsetX(Double offsetX) {
		this.offsetX = offsetX;
	}

	public Double getOffsetY() {
		return offsetY;
	}

	public void setOffsetY(Double offsetY) {
		this.offsetY = offsetY;
	}

	public Integer getPage() {
		return page;
	}

	public void setPage(Integer page) {
		this.page = page;
	}

	public String getKeywords() {
		return keywords;
	}

	public void setKeywords(String keywords) {
		this.keywords = keywords;
	}

	public Integer getKeywordIndex() {
		return keywordIndex;
	}

	public void setKeywordIndex(Integer keywordIndex) {
		this.keywordIndex = keywordIndex;
	}

	public Boolean getTimeStampFlag() {
		return timeStampFlag;
	}

	public void setTimeStampFlag(Boolean timeStampFlag) {
		this.timeStampFlag = timeStampFlag;
	}

	public String getTimeStampKeyWords() {
		return timeStampKeyWords;
	}

	public void setTimeStampKeyWords(String timeStampKeyWords) {
		this.timeStampKeyWords = timeStampKeyWords;
	}

	public Boolean getAcrossFlag() {
		return acrossFlag;
	}

	public void setAcrossFlag(Boolean acrossFlag) {
		this.acrossFlag = acrossFlag;
	}

	public String getAcrossSetting() {
		return acrossSetting;
	}

	public void setAcrossSetting(String acrossSetting) {
		this.acrossSetting = acrossSetting;
	}
}
