package com.ejianc.business.signaturemanage.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * @author:刘家乐
 * @version: 1
 * @date:2021/11/20
 * @document: 签章设置子表
 */
@TableName("ejc_signmgr_signature_setting_sub")
public class SignatureSettingSubEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 印章id,印章管理主键id
     */
    @TableField(value = "seal_id")
    private Long sealId;
    /**
     *印章ID（第三方返回）
     */
    @TableField(value = "source_seal_id")
    private Long sourceSealId;
    /**
     *'印章名称'
     */
    @TableField(value = "source_seal_name")
    private String sourceSealName;
    /**
     *'印章类别'
     */
    @TableField(value = "seal_category")
    private String sealCategory;

    /**
     * 签章类型，COMPANY("企业公章"),LP("法定代表人章")
     */
    @TableField(value = "seal_type")
    private String sealType;
    /**
     *'签章设置表id'
     */
    @TableField(value = "pid")
    private Long pid;
    /**
     * 印章类型
     * 第三方返回的印章状态，NORMAL("正 常"),FREEZE("冻结"),DELETE("删 除"),INVALID("失效")
     */
    @TableField(value = "source_status")
    private String sourceStatus;

    public String getSealType() {
        return sealType;
    }

    public void setSealType(String sealType) {
        this.sealType = sealType;
    }

    public String getSourceStatus() {
        return sourceStatus;
    }

    public void setSourceStatus(String sourceStatus) {
        this.sourceStatus = sourceStatus;
    }

    public Long getSealId() {
        return sealId;
    }

    public void setSealId(Long sealId) {
        this.sealId = sealId;
    }

    public Long getSourceSealId() {
        return sourceSealId;
    }

    public void setSourceSealId(Long sourceSealId) {
        this.sourceSealId = sourceSealId;
    }

    public String getSourceSealName() {
        return sourceSealName;
    }

    public void setSourceSealName(String sourceSealName) {
        this.sourceSealName = sourceSealName;
    }

    public String getSealCategory() {
        return sealCategory;
    }

    public void setSealCategory(String sealCategory) {
        this.sealCategory = sealCategory;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
}
