package com.ejianc.business.signaturemanage.utils;


import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.util.Base64;

/**
 * 文件和Base64互转
 */
public class FileConvert {

    private final Logger logger = LoggerFactory.getLogger(FileConvert.class);

    /**
     * 文件转base64字符串
     *
     * @param file 文件
     * @return String  base64字符串
     */
    public static String fileToBase64(File file) {
        String base64 = null;
        InputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] bytes = new byte[in.available()];
            in.read(bytes);
            base64 = Base64.getEncoder().encodeToString(bytes);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (in != null) {
                    in.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return base64;
    }


    /**
     * base64字符串转文件
     *
     * @param base64 base64字符串
     * @return file   文件
     */
    public static File base64ToFile(String base64, String fileName) {
        File file = null;
        FileOutputStream out = null;
        try {
            // 解码，然后将字节转换为文件
            file = File.createTempFile(fileName, ".pdf");
            byte[] bytes = Base64.getDecoder().decode(base64);
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            byte[] buffer = new byte[1024];
            out = new FileOutputStream(file);
            int bytesum = 0;
            int byteread = 0;
            while ((byteread = in.read(buffer)) != -1) {
                bytesum += byteread;
                out.write(buffer, 0, byteread); // 文件写操作
            }
        } catch (IOException ioe) {
            ioe.printStackTrace();
        } finally {
            try {
                if (out != null) {
                    out.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    @Test
    void test() {
        String base64 = fileToBase64(new File("/Users/baipengyan/Downloads/test.pdf"));
        logger.info("base64:{}", base64);
        File file = base64ToFile(base64, "test----");
        if (file != null && file.exists()) {
            logger.info("filePath:{}", file.getAbsolutePath());
            file.delete();
        }
    }

}
