package com.ejianc.business.signaturemanage.utils;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

/**
 * @author baipengyan
 * @date 2022/5/30
 * @description 文件上传工具类
 */
@Component
public class UploadFile {

	@Value("${common.env.base-host}")
	private String BASE_HOST; // 域名

	public AttachmentVO upload(String authority, File file, Long sourceId, String billType, String sourceType, String replace) {
		Map<String, Object> params = new HashMap<>();
		params.put("sourceId", sourceId);
		params.put("billType", billType);
		params.put("sourceType", sourceType);
		params.put("originalFileNameStr", file.getName());
		params.put("replace", replace);

		String attachmentJson = HttpRequest.post(BASE_HOST + "ejc-file-web/attachment/upload")
				.header("authority", authority)
				.form(params)
				.form("file", file)
				.timeout(60 * 1000)
				.execute().body();

		if (StringUtils.isBlank(attachmentJson)) {
			throw new BusinessException("合同附件上传失败！");
		}
		return JSON.parseObject(attachmentJson, AttachmentVO.class);
	}

}
