/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.signaturemanage.bean.ManagementEntity;
import com.ejianc.business.signaturemanage.bean.ManagementUserEntity;
import com.ejianc.business.signaturemanage.service.IManagementService;
import com.ejianc.business.signaturemanage.service.IManagementUserService;
import com.ejianc.business.signaturemanage.service.ISealManageService;
import com.ejianc.business.signaturemanage.vo.ManagementUserVO;
import com.ejianc.business.signaturemanage.vo.ManagementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.foundation.tenant.api.IidmWebEnterpriseApi;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"management"})
public class ManagementController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IManagementService service;
    @Autowired
    private ISealManageService sealService;
    @Autowired
    private IManagementUserService userService;
    @Autowired
    private IidmWebEnterpriseApi idmWebEnterpriseApi;
    private final String SEAL_CHOOSE_RANGE_PARAM = "P-eF363d0191";
    @Autowired
    private IParamConfigApi paramConfigApi;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<ManagementVO>> queryList(@RequestBody QueryParam queryParam) {
        String checkSearch = "orgName";
        ArrayList orgIdList = new ArrayList();
        if (null != queryParam.getParams().get(checkSearch)) {
            String requestOrgId = String.valueOf(((Parameter)queryParam.getParams().get(checkSearch)).getValue());
            queryParam.getParams().remove(checkSearch);
            queryParam.getParams().put("orgId", new Parameter("eq", (Object)requestOrgId));
        } else {
            CommonResponse orgResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
            if (!orgResp.isSuccess()) {
                Page pageData = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize(), 0L);
                return CommonResponse.success((String)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u5931\u8d25\uff0c\u9879\u76ee\u7ec4\u7ec7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01", (Object)pageData);
            }
            List orgList = (List)orgResp.getData();
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("and");
            ComplexParam c2 = new ComplexParam();
            c2.setLogic("or");
            if (CollectionUtils.isNotEmpty((Collection)orgList)) {
                orgList.forEach(orgVO -> orgIdList.add(orgVO.getId()));
                if (CollectionUtils.isNotEmpty(orgIdList)) {
                    c2.getParams().put("orgId", new Parameter("in", orgIdList));
                }
            }
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("isMatch", new Parameter("eq", (Object)"0"));
            c1.getComplexParams().add(c2);
            c1.getComplexParams().add(c3);
            queryParam.getComplexParams().add(c1);
        }
        queryParam.getOrderMap().put("id", "asc");
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("sourceSealName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("sealSubType");
        fuzzyFields.add("sealType");
        fuzzyFields.add("sealUseName");
        IPage page = this.service.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ManagementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<ManagementVO> queryDetail(@RequestParam String id) {
        ManagementEntity managementEntity = (ManagementEntity)((Object)this.service.selectById((Serializable)((Object)id)));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter("eq", (Object)managementEntity.getId()));
        queryParam.getParams().put("user_type", new Parameter("eq", (Object)"user"));
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List managementUserEntities = this.userService.queryList(queryParam);
        Map managementUserEntityMap = managementUserEntities.stream().collect(Collectors.toMap(ManagementUserEntity::getUserId, Function.identity(), (k1, k2) -> k2));
        managementEntity.setUserEntityList(new ArrayList<ManagementUserEntity>(managementUserEntityMap.values()));
        ManagementVO map = (ManagementVO)BeanMapper.map((Object)((Object)managementEntity), ManagementVO.class);
        return CommonResponse.success((Object)map);
    }

    @RequestMapping(value={"/querySealByOrgId"}, method={RequestMethod.GET})
    public CommonResponse<List<ManagementVO>> querySealByOrgId(@RequestParam(value="orgId") Long orgId) {
        if (null == orgId) {
            throw new BusinessException("\u5f53\u524d\u63a5\u53e3\u5355\u4f4d\u7c7b\u578b\u4e3a\u7a7a");
        }
        CommonResponse parentsByOrgId = this.orgApi.findParentsByOrgId(orgId);
        List<Object> OrgIdList = new ArrayList();
        if (!parentsByOrgId.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u9519\u8bef \u67e5\u8be2\u7ec4\u7ec7\u9519\u8bef");
        }
        OrgIdList = ((List)parentsByOrgId.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("org_id", new Parameter("in", OrgIdList));
        String range = "part";
        CommonResponse response = this.paramConfigApi.getByCode("P-eF363d0191");
        if (!response.isSuccess() || null == response.getData()) {
            this.logger.info("\u83b7\u53d6\u7b7e\u7ae0\u53ef\u9009\u7ae0\u8303\u56f4\u63a7\u5236\u53c2\u6570\u5931\u8d25\u6216\u4e3a\u7a7a\uff0c", (Object)JSONObject.toJSONString((Object)response));
        }
        if ("1".equals(((ParamRegisterSetVO)response.getData()).getValueData())) {
            range = "all";
        }
        if (!"all".equals(range)) {
            queryParam.getParams().put("sealSubTypeName", new Parameter("in", (Object)"\u516c\u7ae0,\u5408\u540c\u4e13\u7528\u7ae0,\u6cd5\u5b9a\u4ee3\u8868\u4eba\u7ae0,\u4e2a\u4eba,\u5206\u516c\u53f8\u516c\u7ae0"));
        }
        queryParam.getParams().put("sourceStatus", new Parameter("eq", (Object)"NORMAL"));
        List managementEntities = this.service.queryList(queryParam, false);
        List mapList = BeanMapper.mapList((Iterable)managementEntities, ManagementVO.class);
        if (mapList.isEmpty()) {
            return CommonResponse.success((String)"\u5f53\u524d\u5355\u4f4d\u4e0b\u6ca1\u6709\u5370\u7ae0");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5370\u7ae0\u6210\u529f", (Object)mapList);
    }

    @RequestMapping(value={"/querySeals"}, method={RequestMethod.GET})
    public CommonResponse<IPage<ManagementVO>> querySeals(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        String range = "part";
        CommonResponse response = this.paramConfigApi.getByCode("P-eF363d0191");
        if (!response.isSuccess() || null == response.getData()) {
            this.logger.info("\u83b7\u53d6\u7b7e\u7ae0\u53ef\u9009\u7ae0\u8303\u56f4\u63a7\u5236\u53c2\u6570\u5931\u8d25\u6216\u4e3a\u7a7a\uff0c", (Object)JSONObject.toJSONString((Object)response));
        }
        if ("1".equals(((ParamRegisterSetVO)response.getData()).getValueData())) {
            range = "all";
        }
        if (!"all".equals(range)) {
            queryParam.getParams().put("sealSubTypeName", new Parameter("in", (Object)"\u516c\u7ae0,\u5408\u540c\u4e13\u7528\u7ae0,\u6cd5\u5b9a\u4ee3\u8868\u4eba\u7ae0,\u4e2a\u4eba,\u5206\u516c\u53f8\u516c\u7ae0"));
        }
        queryParam.getParams().put("sourceStatus", new Parameter("eq", (Object)"NORMAL"));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("orgId")) {
                Long id = Long.parseLong(conditionMap.get("orgId").toString());
                CommonResponse parentsByOrgId = this.orgApi.findParentsByOrgId(id);
                List<Object> OrgIdList = new ArrayList();
                if (!parentsByOrgId.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u9519\u8bef \u67e5\u8be2\u7ec4\u7ec7\u9519\u8bef");
                }
                OrgIdList = ((List)parentsByOrgId.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
                queryParam.getParams().put("orgId", new Parameter("in", OrgIdList));
            }
        } else {
            return CommonResponse.success((String)"\u6570\u636e\u4e3a\u7a7a", (Object)new Page(0L, 1L, 0L));
        }
        queryParam.getOrderMap().put("create_time", "desc");
        IPage pageData = this.service.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), ManagementVO.class));
        if (!result.getRecords().isEmpty()) {
            block10: for (ManagementVO managementVO : result.getRecords()) {
                String sealType;
                switch (sealType = managementVO.getSealType()) {
                    case "COMPANY": {
                        managementVO.setSealTypeStr("\u4f01\u4e1a\u516c\u7ae0");
                        continue block10;
                    }
                    case "LP": {
                        managementVO.setSealTypeStr("\u6cd5\u5b9a\u4ee3\u8868\u4eba\u7ae0");
                        continue block10;
                    }
                    case "PERSONAL": {
                        managementVO.setSealTypeStr("\u4e2a\u4eba\u7b7e\u7ae0");
                        continue block10;
                    }
                }
                managementVO.setSealTypeStr("\u672a\u5b9a\u4e49");
            }
        }
        return CommonResponse.success((Object)result);
    }

    @RequestMapping(value={"/querySeal"}, method={RequestMethod.POST})
    public CommonResponse<IPage<ManagementVO>> querySeal(@RequestBody QueryParam queryParam) {
        String range = "part";
        CommonResponse response = this.paramConfigApi.getByCode("P-eF363d0191");
        if (!response.isSuccess() || null == response.getData()) {
            this.logger.info("\u83b7\u53d6\u7b7e\u7ae0\u53ef\u9009\u7ae0\u8303\u56f4\u63a7\u5236\u53c2\u6570\u5931\u8d25\u6216\u4e3a\u7a7a\uff0c", (Object)JSONObject.toJSONString((Object)response));
        }
        if ("1".equals(((ParamRegisterSetVO)response.getData()).getValueData())) {
            range = "all";
        }
        if (!"all".equals(range)) {
            queryParam.getParams().put("sealSubTypeName", new Parameter("in", (Object)"\u516c\u7ae0,\u5408\u540c\u4e13\u7528\u7ae0,\u6cd5\u5b9a\u4ee3\u8868\u4eba\u7ae0,\u4e2a\u4eba,\u5206\u516c\u53f8\u516c\u7ae0"));
        }
        queryParam.getParams().put("sourceStatus", new Parameter("eq", (Object)"NORMAL"));
        IPage page = this.service.queryPage(queryParam);
        List categoryVoList = BeanMapper.mapList((Iterable)page.getRecords(), ManagementVO.class);
        Page management = new Page();
        management.setCurrent(page.getCurrent());
        management.setRecords(categoryVoList);
        management.setSize(page.getSize());
        management.setTotal(page.getTotal());
        management.setPages(page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)management);
    }

    @RequestMapping(value={"/synchronizationAuto"}, method={RequestMethod.POST})
    public CommonResponse<String> synchronizationAuto(HttpServletRequest request) {
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c");
        List<ManagementVO> data = this.sealService.queryAllSeal();
        if (null == data) {
            this.logger.info("\u5b9a\u65f6\u4efb\u52a1 \u65e0\u5bf9\u5e94\u5370\u7ae0");
            return CommonResponse.success((String)"\u5b9a\u65f6\u4efb\u52a1 \u67e5\u8be2\u5370\u7ae0\u5931\u8d25\u5b9a\u65f6\u4efb\u52a1 \u65e0\u5bf9\u5e94\u5370\u7ae0");
        }
        List managementVOList = BeanMapper.mapList(data, ManagementVO.class);
        List managementEntityList = BeanMapper.mapList((Iterable)managementVOList, ManagementEntity.class);
        String authority = request.getHeader("authority");
        this.service.batchSaveOrUpdate(managementEntityList);
        this.logger.info(String.format("\u540c\u6b65\u6210\u529f \u5df2\u540c\u6b65%d\u4e2a", managementEntityList.size()));
        this.service.syncUpdateImgUrl(managementEntityList.parallelStream().map(ManagementEntity::getSourceSealId).collect(Collectors.toList()), authority);
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f");
    }

    @RequestMapping(value={"/synchronizationMan"}, method={RequestMethod.POST})
    public CommonResponse<String> synchronizationMan(HttpServletRequest request) {
        CommonResponse resp = this.idmWebEnterpriseApi.getEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        this.logger.info("\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7ec4\u7ec7\u4fe1\u606f\uff0c\u5165\u53c2\uff1a{}\uff0c\u51fa\u53c2\uff1a{}", (Object)InvocationInfoProxy.getTenantid(), (Object)JSONObject.toJSONString((Object)resp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (!resp.isSuccess() || StringUtils.isBlank((CharSequence)((EnterpriseVO)resp.getData()).getFullName())) {
            throw new BusinessException("\u67e5\u8be2\u67e5\u8be2\u516c\u53f8\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u516c\u53f8\u540d\u79f0!");
        }
        String companyName = ((EnterpriseVO)resp.getData()).getFullName();
        this.logger.info(companyName + ":\u4e3b\u52a8\u8bf7\u6c42\u540c\u6b65\u5f00\u59cb\u6267\u884c");
        List<ManagementVO> response = this.sealService.querySealsByCompanyName(companyName);
        if (response.isEmpty()) {
            return CommonResponse.success((String)(UserContext.getUserContext().getOrgName() + "\u65e0\u5bf9\u5e94\u7b7e\u7ae0\uff0c\u8bf7\u63d0\u9192\u7ba1\u7406\u5458"));
        }
        this.logger.info("\u5224\u65ad\u8fd4\u56de\u4fe1\u606f:" + JSONObject.toJSONString(response));
        List managementVOList = BeanMapper.mapList(response, ManagementVO.class);
        List managementEntityList = BeanMapper.mapList((Iterable)managementVOList, ManagementEntity.class);
        String authority = request.getHeader("authority");
        this.service.batchSaveOrUpdate(managementEntityList);
        this.logger.info(String.format("\u540c\u6b65\u6210\u529f \u5df2\u540c\u6b65%d\u4e2a", managementEntityList.size()));
        this.service.syncUpdateImgUrl(managementEntityList.parallelStream().map(ManagementEntity::getSourceSealId).collect(Collectors.toList()), authority);
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f");
    }

    @RequestMapping(value={"/updateManagement"}, method={RequestMethod.POST})
    public CommonResponse<ManagementVO> updateManagement(@RequestBody ManagementVO vo) {
        return this.service.updateManagement(vo);
    }

    @RequestMapping(value={"/getManagementByOrgId"}, method={RequestMethod.GET})
    public CommonResponse<List<ManagementVO>> getManagementByOrgId(@RequestParam(value="orgId") Long orgId) {
        QueryParam queryParam = new QueryParam();
        CommonResponse parentsByOrgId = this.orgApi.findParentsByOrgId(orgId);
        List<Long> OrgIdList = new ArrayList<Long>();
        if (parentsByOrgId.isSuccess()) {
            if (parentsByOrgId.getData() != null) {
                OrgIdList = ((List)parentsByOrgId.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            } else {
                OrgIdList.add(orgId);
            }
        } else {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u9519\u8bef\uff0c\u539f\u56e0\uff1a" + parentsByOrgId.getMsg());
        }
        queryParam.getParams().put("orgId", new Parameter("in", OrgIdList));
        String range = "part";
        CommonResponse response = this.paramConfigApi.getByCode("P-eF363d0191");
        if (!response.isSuccess() || null == response.getData()) {
            this.logger.info("\u83b7\u53d6\u7b7e\u7ae0\u53ef\u9009\u7ae0\u8303\u56f4\u63a7\u5236\u53c2\u6570\u5931\u8d25\u6216\u4e3a\u7a7a\uff0c", (Object)JSONObject.toJSONString((Object)response));
        }
        if ("1".equals(((ParamRegisterSetVO)response.getData()).getValueData())) {
            range = "all";
        }
        if (!"all".equals(range)) {
            queryParam.getParams().put("sealSubTypeName", new Parameter("in", (Object)"\u516c\u7ae0,\u5408\u540c\u4e13\u7528\u7ae0,\u6cd5\u5b9a\u4ee3\u8868\u4eba\u7ae0,\u4e2a\u4eba,\u5206\u516c\u53f8\u516c\u7ae0"));
        }
        queryParam.getParams().put("source_status", new Parameter("eq", (Object)"NORMAL"));
        queryParam.getParams().put("enable_status", new Parameter("eq", (Object)1));
        List managementEntities = this.service.queryList(queryParam);
        if (managementEntities.isEmpty()) {
            return CommonResponse.success((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u5370\u7ae0");
        }
        for (ManagementEntity entity : managementEntities) {
            QueryParam query = new QueryParam();
            query.getParams().put("pid", new Parameter("eq", (Object)entity.getId()));
            List managementUserEntities = this.userService.queryList(query);
            entity.setUserEntityList(managementUserEntities);
        }
        List management = BeanMapper.mapList((Iterable)managementEntities, ManagementVO.class);
        return CommonResponse.success((Object)management);
    }

    @GetMapping(value={"/managementUserRefer"})
    public CommonResponse<IPage<ManagementUserVO>> managementUserRefer(@RequestParam(value="pageNumber", defaultValue="1") Integer pageNumber, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="condition") String condition, @RequestParam(value="searchObject", required=false) String searchObject, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("userName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSON.parseObject((String)condition, Map.class);
            Assert.notNull(conditionMap.get("sealId"), (String)"PM\u7cfb\u7edf\u5370\u7ae0id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            param.getParams().put("pid", new Parameter("eq", (Object)Long.valueOf(String.valueOf(conditionMap.get("sealId")))));
        }
        IPage page = this.userService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ManagementUserVO.class));
        return CommonResponse.success((String)"", (Object)pageData);
    }
}

