/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.signaturemanage.enums.SignMgrSignatoryEnum;
import com.ejianc.business.signaturemanage.service.ISignMgrService;
import com.ejianc.business.signaturemanage.vo.SignMgrVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/signMonitor/"})
public class SignMonitorController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISignMgrService signMgrService;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<SignMgrVO>> queryList(@RequestBody QueryParam queryParam) {
        Page pageResp = new Page();
        List fields = queryParam.getFuzzyFields();
        fields.add("contractName");
        fields.add("billCode");
        fields.add("projectName");
        fields.add("recallUserName");
        IPage pageData = this.signMgrService.queryPage(queryParam, false);
        pageResp.setTotal(pageData.getTotal());
        pageResp.setSize(pageData.getSize());
        pageResp.setCurrent(pageData.getCurrent());
        pageResp.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), SignMgrVO.class));
        return CommonResponse.success((Object)pageResp);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List dataList = new ArrayList();
        List fields = queryParam.getFuzzyFields();
        fields.add("contractName");
        fields.add("billCode");
        fields.add("projectName");
        fields.add("recallUserName");
        String signStatus = ((Parameter)queryParam.getParams().get("signStatus")).getValue().toString();
        String exportExcelName = "SigningList-export.xlsx";
        if (signStatus.equals(SignMgrSignatoryEnum.WITHDRAWN.getValue().toString())) {
            exportExcelName = "RecallList-export.xlsx";
        } else if (signStatus.equals(SignMgrSignatoryEnum.SIGNED.getValue().toString())) {
            exportExcelName = "SignedList-export.xlsx";
        }
        CommonResponse projectIdReps = this.projectPoolApi.queryProjectIdsByorgId(InvocationInfoProxy.getOrgId(), null, null);
        if (!projectIdReps.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u672c\u606f\u9879\u76ee\u4fe1\u606f\u5931\u8d25, {}", (Object)JSONObject.toJSONString((Object)projectIdReps));
            throw new BusinessException("\u83b7\u53d6\u672c\u606f\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        queryParam.getParams().put("projectId", new Parameter("in", projectIdReps.getData()));
        List list = this.signMgrService.queryList(queryParam, false);
        dataList = BeanMapper.mapList((Iterable)list, SignMgrVO.class);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dataList.forEach(e -> {
            if (null != e.getFinishTime()) {
                e.setFinishTimeStr(sdf.format(e.getFinishTime()));
            }
            if (null != e.getCreateTime()) {
                e.setCreateTimeStr(sdf.format(e.getCreateTime()));
            }
            if (null != e.getRecallTime()) {
                e.setRecallTimeStr(sdf.format(e.getRecallTime()));
            }
            e.setSignStatusName(SignMgrSignatoryEnum.getSignStatusEnumByCode(e.getSignStatus()).getDescription());
        });
        HashMap beans = new HashMap();
        beans.put("records", dataList);
        ExcelExport.getInstance().export(exportExcelName, beans, response);
    }
}

