/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.signaturemanage.bean.ManagementEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.enums.DelFlagEnum;
import com.ejianc.business.signaturemanage.enums.SignMgrSignatoryEnum;
import com.ejianc.business.signaturemanage.mapper.SignatureRectMapper;
import com.ejianc.business.signaturemanage.service.IAsyncInformService;
import com.ejianc.business.signaturemanage.service.IManagementService;
import com.ejianc.business.signaturemanage.service.ISignMgrService;
import com.ejianc.business.signaturemanage.service.ISignMgrSignatoryService;
import com.ejianc.business.signaturemanage.service.ISignatureRectService;
import com.ejianc.business.signaturemanage.vo.OperatorVO;
import com.ejianc.business.signaturemanage.vo.SignatoryActionVO;
import com.ejianc.business.signaturemanage.vo.SignatoryRectVO;
import com.ejianc.business.signaturemanage.vo.SignatoryVO;
import com.ejianc.business.signaturemanage.vo.SignatureVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.common.base.Stopwatch;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.bean.company.TenantType;
import net.qiyuesuo.sdk.bean.contract.Action;
import net.qiyuesuo.sdk.bean.contract.ActionType;
import net.qiyuesuo.sdk.bean.contract.ContractDetail;
import net.qiyuesuo.sdk.bean.contract.ContractStatus;
import net.qiyuesuo.sdk.bean.contract.CreateContractRequest;
import net.qiyuesuo.sdk.bean.contract.Operator;
import net.qiyuesuo.sdk.bean.contract.SendContractRequest;
import net.qiyuesuo.sdk.bean.contract.StamperType;
import net.qiyuesuo.sdk.bean.contract.WaterMarkContent;
import net.qiyuesuo.sdk.bean.document.DocumentCreateByUrl;
import net.qiyuesuo.sdk.bean.sign.PreSignUrlRequest;
import net.qiyuesuo.sdk.bean.sign.Signatory;
import net.qiyuesuo.sdk.bean.sign.SignatoryRect;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.impl.ContractServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="signatureRectService")
public class SignatureRectServiceImpl
implements ISignatureRectService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ISignMgrService signMgrService;
    private final ISignMgrSignatoryService signMgrSignatoryService;
    private final IAsyncInformService asyncInformService;
    private final SignatureRectMapper signatureRectMapper;
    private final IAttachmentApi attachmentApi;
    private final IUserApi userApi;
    private final IOrgApi orgApi;
    private final IProjectSetApi projectSetApi;
    @Value(value="${qiyuesuo.client.url}")
    private String url;
    @Value(value="${qiyuesuo.client.accessKey}")
    private String accessKey;
    @Value(value="${qiyuesuo.client.accessSecret}")
    private String accessSecret;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${ejc.fileServerUrl}")
    private String fileHost;
    @Value(value="${qiyuesuo.contract.categoryId}")
    private Long categoryId;
    @Value(value="${qiyuesuo.contract.defaultTenantName:#{NULL}}")
    private String defaultTenantName;
    private IManagementService managementService;
    private SessionManager sessionManager;

    public SignatureRectServiceImpl(ISignMgrService signMgrService, IAttachmentApi attachmentApi, IUserApi userApi, SignatureRectMapper signatureRectMapper, ISignMgrSignatoryService signMgrSignatoryService, IAsyncInformService asyncInformService, IOrgApi orgApi, IProjectSetApi projectSetApi, IManagementService managementService, SessionManager sessionManager) {
        this.signMgrService = signMgrService;
        this.attachmentApi = attachmentApi;
        this.userApi = userApi;
        this.signatureRectMapper = signatureRectMapper;
        this.signMgrSignatoryService = signMgrSignatoryService;
        this.asyncInformService = asyncInformService;
        this.orgApi = orgApi;
        this.projectSetApi = projectSetApi;
        this.managementService = managementService;
        this.sessionManager = sessionManager;
    }

    private SDKClient getSdkClient() {
        SDKClient client = new SDKClient(this.url, this.accessKey, this.accessSecret);
        client.enableNonce();
        return client;
    }

    @Override
    public synchronized void deleteSignatureRect(Long contractId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SignMgrEntity::getDelFlag, (Object)DelFlagEnum.NORMAL.getDelFlag());
        queryWrapper.eq(SignMgrEntity::getBillId, (Object)contractId);
        SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)this.signMgrService.getOne((Wrapper)queryWrapper));
        this.logger.info("\u5355\u636eid-{}\u5bf9\u5e94\u7684\u7b7e\u7ae0\u6570\u636e \u53cc\u5220\u9664\u5904\u7406~~~~~~~", (Object)contractId);
        if (signMgrEntity != null) {
            Assert.notNull((Object)signMgrEntity.getSourceBillId(), (String)"\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\u4e0d\u5b58\u5728\uff01");
            Stopwatch start = Stopwatch.createStarted();
            ContractDetail contractDetail = this.thirdContractDetail(signMgrEntity.getSourceBillId(), false, true);
            Assert.notNull((Object)contractDetail, (String)"\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540c\u8be6\u60c5\u67e5\u8be2\u4e0d\u5230\uff01");
            if (contractDetail.getStatus() != ContractStatus.DRAFT) {
                throw new BusinessException("\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540c\u8be6\u60c5\u4e0d\u662f\u8349\u7a3f\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664PM\u7cfb\u7edf\u7b7e\u7ae0\u6570\u636e\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\uff01");
            }
            Stopwatch end = start.stop();
            this.logger.info("\u83b7\u53d6\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540c\u8be6\u60c5\uff0c\u7ed3\u675f\u3002\u5171\u8ba1\u8017\u65f6\uff1a\u300c{}\u300d\u79d2", (Object)end.elapsed(TimeUnit.SECONDS));
            this.deleteContractSignatureData(contractId);
            if (!"\u7b2c\u4e09\u65b9\u6587\u4ef6\u4e0d\u5b58\u5728,TFNN".equals(contractDetail.getBusinessData())) {
                this.deleteThirdContract(signMgrEntity.getSourceBillId());
            }
        }
    }

    @Override
    public String fetchPreSignUrl(SignatureVO signatureVO) {
        HashSet signPartsOrders = new HashSet();
        HashSet signActionsOrders = new HashSet();
        signatureVO.getSignatoryVOS().forEach(signatoryVO -> {
            if (signPartsOrders.contains(signatoryVO.getSignOrder())) {
                throw new BusinessException("\u4e0d\u540c\u7b7e\u7f72\u65b9\u7b7e\u7f72\u5e8f\u53f7\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            signPartsOrders.add(signatoryVO.getSignOrder());
            signActionsOrders.clear();
            signatoryVO.getSignatoryActionVOS().forEach(signatoryActionVO -> {
                if (signActionsOrders.contains(signatoryActionVO.getSealSignOrder())) {
                    throw new BusinessException("\u540c\u4e00\u7b7e\u7f72\u65b9\u4e0b\u7b7e\u7f72\u5e8f\u53f7\u4e0d\u80fd\u91cd\u590d\uff01");
                }
                signActionsOrders.add(signatoryActionVO.getSealSignOrder());
                signatoryActionVO.getOperatorVOS().forEach(operatorVO -> {
                    if (signatoryVO.getSignatureType() == 0) {
                        Assert.notNull((Object)operatorVO.getOperatorId(), (String)"\u64cd\u4f5c\u4ebaid\uff08\u5185\u90e8\u5355\u4f4d\u5e73\u53f0\u7528\u6237id\uff09\u300coperatorId\u300d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        Assert.hasLength((String)operatorVO.getOperatorName(), (String)"\u64cd\u4f5c\u4eba\u59d3\u540d\u300coperatorName\u300d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        Assert.hasLength((String)operatorVO.getOperatorContact(), (String)"\u64cd\u4f5c\u4eba\u8054\u7cfb\u65b9\u5f0f\u300coperatorContact\u300d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                });
            });
        });
        SignMgrEntity signMgrEntity = new SignMgrEntity();
        CreateContractRequest request = this.prepareCreateContractRequest(signatureVO, false, signMgrEntity);
        this.deleteSignatureRect(signatureVO.getBillId());
        Map<String, String> map = this.parseAttachment(signatureVO.getBillDocId());
        Long documentId = this.createContractDocument(map.get("url"), map.get("title"), map.get("fileType"), null);
        Assert.notNull((Object)documentId, (String)("\u83b7\u53d6\u9884\u7b7e\u7f72\u94fe\u63a5\uff1a\u6839\u636ePM\u7cfb\u7edf\u5408\u540c\u6587\u4ef6id\uff1a" + signatureVO.getBillDocId() + "\uff0c\u521b\u5efa\u5408\u540c\u6587\u6863\u5931\u8d25\uff01"));
        signatureVO.setBillDocumentName(map.get("title"));
        signatureVO.setBillDocumentType(map.get("fileType"));
        Long contractId = this.createContract(documentId, request);
        Assert.notNull((Object)contractId, (String)("\u83b7\u53d6\u9884\u7b7e\u7f72\u94fe\u63a5\uff1a\u6839\u636e\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540c\u6587\u6863id\uff1a" + documentId + "\uff0c\u521b\u5efa\u5408\u540c\u5931\u8d25\uff01"));
        signMgrEntity.setSourceBillId(contractId);
        signMgrEntity.setSourceDocId(documentId);
        this.logger.info("================================>\u8bf7\u6c42\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u53d1\u8d77\u5408\u540c\uff0c\u5e76\u5199\u5165\u7b7e\u7ae0\u4e1a\u52a1\u6570\u636e-START<================================");
        this.logger.info("\u5373\u5c06\u5199\u5165\u7684\u7b7e\u7ae0\u6570\u636esignMgrEntity\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)((Object)signMgrEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        this.signMgrService.saveOrUpdate((Object)signMgrEntity, false);
        this.logger.info("================================>\u8bf7\u6c42\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u53d1\u8d77\u5408\u540c\uff0c\u5199\u5165\u7b7e\u7ae0\u7ba1\u7406\u6570\u636e\u6210\u529f-END<================================");
        return this.preSignUrl(contractId, true, true, false, true, documentId, this.baseHost);
    }

    public Map<String, String> parseAttachment(Long fileId) {
        Assert.notNull((Object)fileId, (String)"fileId\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap<String, String> map = new HashMap<String, String>();
        Stopwatch start = Stopwatch.createStarted();
        CommonResponse res = this.attachmentApi.queryDetail(String.valueOf(fileId));
        Stopwatch end = start.stop();
        this.logger.info("\u6839\u636e\u6587\u4ef6id-{}\u83b7\u53d6\u9644\u4ef6\u8be6\u60c5\uff0c\u7ed3\u675f\u3002\u5171\u8ba1\u8017\u65f6\uff1a\u300c{}\u300d\u79d2", (Object)fileId, (Object)end.elapsed(TimeUnit.SECONDS));
        if (!res.isSuccess() || res.getData() == null) {
            this.logger.error("\u8c03\u7528\u6587\u4ef6\u4e2d\u5fc3\u63a5\u53e3\uff0c\u83b7\u53d6\u9644\u4ef6\u5931\u8d25\uff01\u539f\u56e0\uff1a{}", (Object)res.getMsg());
            throw new BusinessException("\u8c03\u7528\u6587\u4ef6\u4e2d\u5fc3\u63a5\u53e3\uff0c\u83b7\u53d6\u9644\u4ef6\u5931\u8d25\uff01\u539f\u56e0\uff1a" + res.getMsg());
        }
        this.logger.info("\u5408\u540c\u6587\u4ef6\u8be6\u60c5\uff1a{}", (Object)JSON.toJSONString((Object)res.getData(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat}));
        String fileUrl = this.fileHost + ((AttachmentVO)res.getData()).getFilePath();
        Assert.hasText((String)fileUrl, (String)"\u5408\u540c\u6587\u4ef6\u7f51\u7edc\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String fullName = ((AttachmentVO)res.getData()).getFileName();
        String title = fullName.substring(0, fullName.lastIndexOf("."));
        Assert.hasText((String)title, (String)"\u5408\u540c\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String fileType = fullName.substring(fullName.lastIndexOf(".") + 1);
        Assert.hasText((String)fileType, (String)"\u5408\u540c\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        map.put("url", fileUrl);
        map.put("title", title);
        map.put("fileType", fileType);
        return map;
    }

    @Override
    public void sendSignature(Long contractId) {
        Assert.notNull((Object)contractId, (String)"\u53d1\u8d77\u7b7e\u7ae0\uff0cPM\u7cfb\u7edf\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SignMgrEntity::getDelFlag, (Object)DelFlagEnum.NORMAL.getDelFlag());
        queryWrapper.eq(SignMgrEntity::getBillId, (Object)contractId);
        SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)this.signMgrService.getOne((Wrapper)queryWrapper));
        Assert.notNull((Object)((Object)signMgrEntity), (String)"\u8bf7\u5148\u70b9\u51fb\u7b7e\u7ae0\u5b9a\u4f4d\uff0c\u8bbe\u7f6e\u5370\u7ae0\u4f4d\u7f6e\u540e\u53d1\u8d77\u7b7e\u7ae0");
        Assert.notNull((Object)signMgrEntity.getSourceBillId(), (String)("\u53d1\u8d77\u7b7e\u7ae0\uff0c\u6839\u636ePM\u7cfb\u7edf\u5408\u540cid\uff1a" + contractId + "\uff0c\u672a\u627e\u5230\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\uff01"));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SignMgrSignatoryEntity::getDelFlag, (Object)DelFlagEnum.NORMAL.getDelFlag());
        wrapper.eq(SignMgrSignatoryEntity::getPid, (Object)signMgrEntity.getId());
        List signatoryEntities = this.signMgrSignatoryService.list((Wrapper)wrapper);
        Assert.notEmpty((Collection)signatoryEntities, (String)("\u53d1\u8d77\u7b7e\u7ae0\uff0c\u6839\u636ePM\u7cfb\u7edf\u5408\u540cid\uff1a" + contractId + "\uff0c\u672a\u627e\u5230\u7b7e\u7ae0\u6570\u636e\uff01"));
        String msg = this.sendContract(signMgrEntity.getSourceBillId());
        ContractDetail contractDetail = this.thirdContractDetail(signMgrEntity.getSourceBillId(), false, false);
        Assert.notNull((Object)contractDetail, (String)"\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540c\u8be6\u60c5\u67e5\u8be2\u4e0d\u5230\uff01");
        if (StringUtils.isNotBlank((CharSequence)msg) || contractDetail.getStatus() != ContractStatus.SIGNING) {
            throw new BusinessException("\u53d1\u8d77\u5408\u540c\u5931\u8d25!" + msg);
        }
        List<SignMgrSignatoryEntity> actions = this.nextAction(signatoryEntities, true);
        String authority = this.getAuthority();
        Integer status = CollectionUtils.isNotEmpty(actions) ? (Objects.equals(SignMgrSignatoryEnum.INTERNAL_UNIT.getValue(), actions.get(0).getSignatureType()) ? SignMgrSignatoryEnum.WAITE_PARTY_A.getValue() : SignMgrSignatoryEnum.WAITE_PARTY_B.getValue()) : SignMgrSignatoryEnum.WAITE_PARTY_A.getValue();
        this.asyncInformService.informBusinessSystem(signMgrEntity.getBillType(), contractId, signMgrEntity.getBillRefCode(), status, authority);
        signMgrEntity.setSignStatus(status);
        this.signMgrService.saveOrUpdate((Object)signMgrEntity, false);
        this.asyncInformService.informMessage(Collections.singletonList("sys"), actions, signMgrEntity.getSourceBillId(), signMgrEntity.getBillCode(), signMgrEntity.getContractName(), authority);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String recallContract(Long billId, String recallReason) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SignMgrEntity::getDelFlag, (Object)DelFlagEnum.NORMAL.getDelFlag());
        queryWrapper.eq(SignMgrEntity::getBillId, (Object)billId);
        SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)this.signMgrService.getOne((Wrapper)queryWrapper));
        if (signMgrEntity == null) {
            return "\u64a4\u56de\u5931\u8d25\uff0c\u8be5\u5355\u636e\u7684\u7b7e\u7ae0\u4fe1\u606f\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01";
        }
        if (null == signMgrEntity.getSourceBillId()) {
            this.logger.error("\u5355\u636e-\u3010id:{}\u3011\u7b7e\u7ae0\u4fe1\u606f\u4e2d\u65e0\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid", (Object)billId);
            return "\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\u4e0d\u5b58\u5728!";
        }
        ContractDetail contractDetail = this.thirdContractDetail(signMgrEntity.getSourceBillId(), false, true);
        this.logger.info("\u5355\u636e-\u3010id:{}\u3011\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540c\u8be6\u60c5: {}", (Object)JSONObject.toJSONString((Object)contractDetail));
        if (!"\u7b2c\u4e09\u65b9\u6587\u4ef6\u4e0d\u5b58\u5728,TFNN".equals(contractDetail.getBusinessData()) && !contractDetail.getStatus().getDescription().equals(ContractStatus.SIGNING.getDescription())) {
            return "\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540c\u4e0d\u662f\u7b7e\u7f72\u4e2d\u72b6\u6001\uff0c\u4e0d\u80fd\u6267\u884c\u64a4\u56de\u64cd\u4f5c\uff01";
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)signMgrEntity.getId());
        updateWrapper.set(SignMgrEntity::getRecallReason, (Object)recallReason);
        updateWrapper.set(SignMgrEntity::getRecallTime, (Object)new Date());
        updateWrapper.set(SignMgrEntity::getRecallUserId, (Object)InvocationInfoProxy.getUserid());
        CommonResponse userResp = this.userApi.findUserByUserId(InvocationInfoProxy.getUserid());
        if (userResp.isSuccess() && null != userResp.getData()) {
            updateWrapper.set(SignMgrEntity::getRecallUserName, (Object)((UserVO)userResp.getData()).getUserName());
        } else {
            this.logger.error("\u6839\u636eId-{}\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)InvocationInfoProxy.getUserid(), (Object)JSONObject.toJSONString((Object)userResp));
        }
        boolean updateFlag = this.signMgrService.update((Wrapper)updateWrapper);
        Assert.isTrue((boolean)updateFlag, (String)"\u903b\u8f91\u5220\u9664\u7b7e\u7ae0\u6570\u636e\uff0c\u66f4\u65b0\u7b7e\u7ae0\u6d41\u7a0b\u4e3b\u8868\u7b7e\u7ae0\u72b6\u6001\u5931\u8d25\uff01");
        if (!"\u7b2c\u4e09\u65b9\u6587\u4ef6\u4e0d\u5b58\u5728,TFNN".equals(contractDetail.getBusinessData())) {
            this.logger.info("\u7528\u6237-{}\u6267\u884c\u7b2c\u4e09\u65b9\u5408\u540c-{}\u7684\u64a4\u56de\u64cd\u4f5c\uff01", (Object)billId, (Object)signMgrEntity.getSourceBillId());
            ContractServiceImpl contractService = new ContractServiceImpl(this.getSdkClient());
            try {
                contractService.recallContract(signMgrEntity.getSourceBillId(), recallReason);
            }
            catch (PrivateAppException e) {
                this.logger.error("\u7528\u6237-{}\u6267\u884c\u7b2c\u4e09\u65b9\u5408\u540c-{}\u7684\u64a4\u56de\u64cd\u4f5c\u5f02\u5e38\uff1a", new Object[]{billId, signMgrEntity.getSourceBillId(), e});
                throw new BusinessException("\u64a4\u56de\u5931\u8d25\uff0c\u8c03\u7528\u7b2c\u4e09\u65b9\u5408\u540c\u64a4\u56de\u670d\u52a1\u5931\u8d25\uff01");
            }
        }
        return null;
    }

    public Long getThirdContractId(Long contractId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SignMgrEntity::getDelFlag, (Object)DelFlagEnum.NORMAL.getDelFlag());
        queryWrapper.eq(SignMgrEntity::getBillId, (Object)contractId);
        SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)this.signMgrService.getOne((Wrapper)queryWrapper));
        Assert.notNull((Object)((Object)signMgrEntity), (String)("PM\u7cfb\u7edf\u5408\u540cid\uff1a" + contractId + "\uff0c\u7535\u5b50\u7b7e\u7ae0\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01"));
        Assert.notNull((Object)signMgrEntity.getSourceBillId(), (String)"\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\uff0c\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        return signMgrEntity.getSourceBillId();
    }

    public Long createContractDocument(String url, String title, String fileType, List<WaterMarkContent> waterMarks) {
        Assert.hasText((String)url, (String)"\u6839\u636e\u8def\u5f84\u521b\u5efa\u5408\u540c\u6587\u6863\uff0c\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)title, (String)"\u6839\u636e\u8def\u5f84\u521b\u5efa\u5408\u540c\u6587\u6863\uff0c\u5408\u540c\u6587\u6863\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)fileType, (String)"\u6839\u636e\u8def\u5f84\u521b\u5efa\u5408\u540c\u6587\u6863\uff0c\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Long documentId = null;
        try {
            Stopwatch start = Stopwatch.createStarted();
            ContractServiceImpl contractService = new ContractServiceImpl(this.getSdkClient());
            documentId = contractService.createDocumentByUrl(new DocumentCreateByUrl(url, title, fileType, waterMarks));
            Stopwatch end = start.stop();
            this.logger.info("\u6839\u636e\u8def\u5f84\u521b\u5efa\u5408\u540c\u6587\u6863\uff0c\u7ed3\u675f\u3002\u5171\u8ba1\u8017\u65f6\uff1a\u300c{}\u300d\u79d2", (Object)end.elapsed(TimeUnit.SECONDS));
        }
        catch (PrivateAppException e) {
            this.logger.error("\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\uff0c\u521b\u5efa\u5408\u540c\u6587\u6863\u5931\u8d25\uff01\u5165\u53c2\uff1aPM\u7cfb\u7edf-\u6587\u4ef6\u8def\u5f84url\uff1a{}\uff0c\u6587\u4ef6\u540d\u79f0\uff1a{}\uff0c\u6587\u4ef6\u7c7b\u578b\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{url, title, fileType, e.getMessage()});
        }
        return documentId;
    }

    private Long createContract(Long documentId, CreateContractRequest request) {
        Long contractId;
        ContractServiceImpl contractService = new ContractServiceImpl(this.getSdkClient());
        request.setDocuments(Collections.singletonList(documentId));
        request.getSignatories().forEach(signatories -> {
            if (CollectionUtils.isNotEmpty((Collection)signatories.getActions())) {
                signatories.getActions().forEach(action -> {
                    if (CollectionUtils.isNotEmpty((Collection)action.getLocations())) {
                        action.getLocations().forEach(location -> location.setDocumentId(documentId));
                    }
                });
            }
        });
        try {
            Stopwatch start = Stopwatch.createStarted();
            this.logger.info("\u5f00\u59cb\u8c03\u7528\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u521b\u5efa\u5408\u540c\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)request, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            contractId = contractService.createContractByCategory(request);
            Stopwatch end = start.stop();
            this.logger.info("\u5f00\u59cb\u8c03\u7528\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u521b\u5efa\u5408\u540c\uff0c\u7ed3\u675f\u3002\u5171\u8ba1\u8017\u65f6\uff1a\u300c{}\u300d\u79d2", (Object)end.elapsed(TimeUnit.SECONDS));
        }
        catch (PrivateAppException e) {
            throw new BusinessException("\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u521b\u5efa\u5408\u540c\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a", (Throwable)e);
        }
        return contractId;
    }

    public CreateContractRequest prepareCreateContractRequest(SignatureVO signatureVO, Boolean send, SignMgrEntity signMgrEntity) {
        int acrossNum;
        UserContext userContext = this.sessionManager.getUserContext();
        CommonResponse userResp = this.userApi.findUserByUserId(userContext.getUserId());
        if (!userResp.isSuccess()) {
            this.logger.error("\u53d1\u8d77\u7b7e\u7ae0\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSON.toJSONString((Object)userResp));
            throw new BusinessException("\u53d1\u8d77\u7b7e\u7ae0\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        UserVO curUser = (UserVO)userResp.getData();
        Assert.notNull((Object)signatureVO, (String)"\u521b\u5efa\u5408\u540c\uff0c\u53d1\u8d77\u7b7e\u7ae0VO\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)send, (String)"\u521b\u5efa\u5408\u540c\uff0c\u662f\u5426\u7acb\u5373\u53d1\u8d77\u5408\u540c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<SignMgrSignatoryEntity> signatoryEntities = signMgrEntity.getSignMgrSignatoryEntities();
        CreateContractRequest request = new CreateContractRequest();
        ArrayList<Signatory> signatories = new ArrayList<Signatory>();
        request.setCategoryId(this.categoryId);
        request.setSubject(this.concatSubject(signatureVO.getSubject(), signatureVO.getBillName(), signatureVO.getContractName(), signatureVO.getOrgId(), signatureVO.getProjectId()));
        request.setSn(signatureVO.getBillCode());
        request.setSend(send);
        request.setDescription(signatureVO.getSignRequirements());
        UserVO userVO = this.getUserVO(UserContext.getUserContext().getUserId());
        request.setCreatorName(userVO.getUserName());
        Assert.hasText((String)userVO.getUserMobile(), (String)"\u5f53\u524d\u7528\u6237\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u7cfb\u7edf\u5185\u7ef4\u62a4\u624b\u673a\u53f7\u540e\u91cd\u8bd5\uff01");
        request.setCreatorContact(userVO.getUserMobile());
        if (StringUtils.isNotBlank((CharSequence)this.defaultTenantName)) {
            request.setTenantName(this.defaultTenantName);
        } else {
            request.setTenantName(userContext.getEnterpriseName());
        }
        request.setExtraSign(Boolean.valueOf(true));
        request.setMustSign(Boolean.valueOf(true));
        signMgrEntity.setDelFlag(DelFlagEnum.NORMAL.getDelFlag());
        signMgrEntity.setBillId(signatureVO.getBillId());
        signMgrEntity.setBillType(signatureVO.getBillType());
        signMgrEntity.setBillCode(signatureVO.getBillCode());
        signMgrEntity.setBillName(signatureVO.getBillName());
        signMgrEntity.setContractName(signatureVO.getContractName());
        signMgrEntity.setContractTaxMny(signatureVO.getContractTaxMny());
        signMgrEntity.setOrgId(signatureVO.getOrgId());
        signMgrEntity.setOrgCode(signatureVO.getOrgCode());
        signMgrEntity.setOrgName(signatureVO.getOrgName());
        signMgrEntity.setProjectId(signatureVO.getProjectId());
        signMgrEntity.setProjectCode(signatureVO.getProjectCode());
        signMgrEntity.setProjectName(signatureVO.getProjectName());
        signMgrEntity.setBillRefCode(signatureVO.getBillRefCode());
        signMgrEntity.setBillDocId(signatureVO.getBillDocId());
        signMgrEntity.setBillDocumentName(signatureVO.getBillDocumentName());
        signMgrEntity.setBillDocumentType(signatureVO.getBillDocumentType());
        signMgrEntity.setSignRequirements(signatureVO.getSignRequirements());
        signMgrEntity.setCreatorName(userVO.getUserName());
        signMgrEntity.setCreatorContact(userVO.getUserMobile());
        signMgrEntity.setTenantName(signatureVO.getTenantName());
        signMgrEntity.setSubject(request.getSubject());
        List signatoryVOS = signatureVO.getSignatoryVOS();
        Assert.notEmpty((Collection)signatoryVOS, (String)"\u521b\u5efa\u5408\u540c\uff0c\u7b7e\u7f72\u65b9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        signatoryVOS.sort(Comparator.comparing(SignatoryVO::getSignOrder));
        StringBuilder stringBuilder = new StringBuilder();
        boolean innerSign = true;
        ArrayList outSignUnits = new ArrayList();
        ArrayList<SignatoryActionVO> acts = new ArrayList<SignatoryActionVO>();
        signatoryVOS.forEach(e -> {
            acts.addAll(e.getSignatoryActionVOS());
            if (SignMgrSignatoryEnum.EXTERNAL_UNIT.getValue().equals(e.getSignatureType())) {
                outSignUnits.add(e);
            }
        });
        if (CollectionUtils.isNotEmpty(outSignUnits)) {
            innerSign = false;
        }
        if ((acrossNum = this.countAcross(acts).intValue()) > 7) {
            throw new BusinessException("\u9a91\u7f1d\u7ae0\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc77\u4e2a\uff01");
        }
        double offsetY = BigDecimal.valueOf(1.0 / (double)(acrossNum + 1)).setScale(2, RoundingMode.DOWN).doubleValue();
        AtomicInteger num = new AtomicInteger();
        String regex = ",|\uff0c";
        if (innerSign) {
            signatoryVOS.sort(new Comparator<SignatoryVO>(){

                @Override
                public int compare(SignatoryVO o1, SignatoryVO o2) {
                    return o1.getSignOrder() - o2.getSignOrder();
                }
            });
        }
        ManagementEntity seal = null;
        Long firstInnerNoPsSealId = null;
        for (SignatoryVO signatoryVO : signatoryVOS) {
            Signatory signatory = null;
            signatory = innerSign && signatories.size() > 0 ? (Signatory)signatories.get(0) : new Signatory();
            signatory.setTenantType(TenantType.valueOf((String)signatoryVO.getTenantType()));
            signatory.setTenantName(innerSign ? this.defaultTenantName : signatoryVO.getTenantName());
            boolean flag = Objects.equals(SignMgrSignatoryEnum.INTERNAL_UNIT.getValue(), signatoryVO.getSignatureType());
            String signatoryHead = flag ? "T_" : "S_";
            String signatoryNo = String.valueOf(stringBuilder.append(signatoryHead).append(InvocationInfoProxy.getTenantid()).append("_").append(signatureVO.getBillRefCode()).append("_").append(signatureVO.getBillId()).append("_").append(signatureVO.getBillType()).append("_").append(IdWorker.getId()));
            signatory.setSignatoryNo(signatoryNo);
            signatory.setReceiverName(signatoryVO.getReceiverName());
            if (StringUtils.isNotBlank((CharSequence)signatoryVO.getContact())) {
                signatory.setContact(signatoryVO.getContact());
            } else {
                if (StringUtils.isBlank((CharSequence)curUser.getUserMobile())) {
                    throw new BusinessException("\u5f53\u524d\u7528\u6237\u8054\u7cfb\u65b9\u5f0f\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u8054\u7cfb\u65b9\u5f0f\u540e\u5728\u8fdb\u884c\u64cd\u4f5c\uff01");
                }
                signatory.setContact(curUser.getUserMobile());
            }
            signatory.setSerialNo(signatoryVO.getSignOrder());
            ArrayList<Action> actions = null;
            int signActionInitOrder = 0;
            if (innerSign) {
                actions = signatory.getActions();
                if (null == actions) {
                    actions = new ArrayList();
                }
                signActionInitOrder = actions.size();
            } else {
                actions = new ArrayList<Action>();
            }
            List signatoryActionVOS = signatoryVO.getSignatoryActionVOS();
            for (SignatoryActionVO signatoryActionVO : signatoryActionVOS) {
                List signatoryRectVOS;
                OperatorVO firstOp;
                SignMgrSignatoryEntity sms = new SignMgrSignatoryEntity();
                Action action = new Action();
                action.setType(ActionType.valueOf((String)signatoryActionVO.getSignActionType()));
                stringBuilder.delete(0, stringBuilder.length());
                String actionNo = String.valueOf(stringBuilder.append(signatoryHead).append(InvocationInfoProxy.getTenantid()).append("_").append(signatureVO.getBillRefCode()).append("_").append(signatureVO.getBillId()).append("_").append(signatureVO.getBillType()).append("_").append(signatoryActionVO.getSignActionType()).append("_").append(signatoryActionVO.getSealSignOrder()).append("_").append(IdWorker.getId()));
                action.setActionNo(actionNo);
                action.setName(signatoryActionVO.getSealSignOrder() + "-" + signatoryActionVO.getName());
                if (CollectionUtils.isNotEmpty((Collection)signatoryActionVO.getOperatorVOS()) && null != (firstOp = (OperatorVO)signatoryActionVO.getOperatorVOS().get(0)) && StringUtils.isNotBlank((CharSequence)firstOp.getOperatorName())) {
                    action.setName(action.getName() + "-" + firstOp.getOperatorName());
                }
                action.setSerialNo(Integer.valueOf(signatoryActionVO.getSealSignOrder() + signActionInitOrder));
                if (flag && !"PERSONAL".equals(signatoryActionVO.getSignActionType()) && StringUtils.isNotBlank((CharSequence)signatoryActionVO.getSourceSealId()) && StringUtils.isNotBlank((CharSequence)signatoryActionVO.getSourceSealName())) {
                    Set ids = Stream.of(signatoryActionVO.getSourceSealId().split(regex)).map(e -> Long.parseLong(e.trim())).collect(Collectors.toSet());
                    Set names = Stream.of(signatoryActionVO.getSourceSealName().split(regex)).collect(Collectors.toSet());
                    action.setSealIds(ids);
                    action.setSealNames(names);
                    if (null == firstInnerNoPsSealId) {
                        firstInnerNoPsSealId = (Long)Stream.of(signatoryActionVO.getSourceSealId().split(regex)).map(e -> Long.parseLong(e.trim())).collect(Collectors.toList()).get(0);
                    }
                }
                ArrayList<Operator> operators = new ArrayList<Operator>();
                List ops = signatoryActionVO.getOperatorVOS();
                if (CollectionUtils.isNotEmpty((Collection)ops)) {
                    if (Objects.equals(SignMgrSignatoryEnum.INTERNAL_UNIT.getValue(), signatoryVO.getSignatureType())) {
                        this.checkInnerUser(ops);
                    }
                    for (OperatorVO op : ops) {
                        Operator operator = new Operator();
                        operator.setOperatorName(op.getOperatorName());
                        operator.setOperatorContact(op.getOperatorContact());
                        operators.add(operator);
                        sms.setSignatureId(op.getOperatorId());
                        sms.setSignatureName(op.getOperatorName());
                        sms.setSignatureContact(op.getOperatorContact());
                        sms.setSignActionType(signatoryActionVO.getSignActionType());
                        sms.setName(signatoryActionVO.getName());
                        sms.setSealSignOrder(signatoryActionVO.getSealSignOrder());
                        sms.setSourceSealId(signatoryActionVO.getSourceSealId());
                        sms.setSourceSealName(signatoryActionVO.getSourceSealName());
                        sms.setSealId(signatoryActionVO.getSealId());
                        sms.setSealName(signatoryActionVO.getSealName());
                        sms.setSignatureUserIds(signatoryActionVO.getSignatureUserIds());
                        sms.setActionNo(actionNo);
                        sms.setTenantName(signatoryVO.getTenantName());
                        sms.setTenantType(signatoryVO.getTenantType());
                        sms.setReceiverName(signatoryVO.getReceiverName());
                        sms.setContact(signatoryVO.getContact());
                        sms.setSignOrder(signatoryVO.getSignOrder());
                        sms.setSignatureType(signatoryVO.getSignatureType());
                        sms.setSignatoryNo(signatoryNo);
                        sms.setJobStatus(SignMgrSignatoryEnum.TO_BE_ACTIVATED.getValue());
                        sms.setDelFlag(DelFlagEnum.NORMAL.getDelFlag());
                        signatoryEntities.add(sms);
                    }
                    action.setActionOperators(operators);
                }
                if (CollectionUtils.isNotEmpty((Collection)(signatoryRectVOS = signatoryActionVO.getSignatoryRectVOS()))) {
                    ArrayList<SignatoryRect> signatoryRects = new ArrayList<SignatoryRect>();
                    for (SignatoryRectVO rect : signatoryRectVOS) {
                        List<String> timeStampKeyWords;
                        SignatoryRect sr;
                        List<String> keywords;
                        if ("PERSONAL".equals(signatoryActionVO.getSignActionType()) || "LP".equals(signatoryActionVO.getSignActionType())) {
                            if (StringUtils.isNotBlank((CharSequence)rect.getKeywords()) && CollectionUtils.isNotEmpty(keywords = Arrays.asList(rect.getKeywords().split(regex)))) {
                                for (String keyword : keywords) {
                                    if (!StringUtils.isNotBlank((CharSequence)keyword)) continue;
                                    sr = new SignatoryRect();
                                    sr.setRectType(StamperType.SEAL_CORPORATE);
                                    sr.setKeyword(keyword);
                                    signatoryRects.add(sr);
                                }
                            }
                            if (Boolean.TRUE.equals(rect.getTimeStampFlag()) && StringUtils.isNotBlank((CharSequence)rect.getTimeStampKeyWords()) && CollectionUtils.isNotEmpty(timeStampKeyWords = Arrays.asList(rect.getTimeStampKeyWords().split(regex)))) {
                                for (String timeStampKeyWord : timeStampKeyWords) {
                                    if (!StringUtils.isNotBlank((CharSequence)timeStampKeyWord)) continue;
                                    sr = new SignatoryRect();
                                    sr.setRectType(StamperType.TIMESTAMP);
                                    sr.setKeyword(timeStampKeyWord);
                                    signatoryRects.add(sr);
                                }
                            }
                        }
                        if ("CORPORATE".equals(signatoryActionVO.getSignActionType())) {
                            if (StringUtils.isNotBlank((CharSequence)rect.getKeywords())) {
                                keywords = Arrays.asList(rect.getKeywords().split(regex));
                                this.logger.info("keywords: {}", (Object)JSON.toJSONString(keywords, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
                                if (CollectionUtils.isNotEmpty(keywords)) {
                                    for (String keyword : keywords) {
                                        if (!StringUtils.isNotBlank((CharSequence)keyword)) continue;
                                        sr = new SignatoryRect();
                                        sr.setRectType(StamperType.SEAL_CORPORATE);
                                        sr.setKeyword(keyword);
                                        sr.setKeywordIndex(rect.getKeywordIndex());
                                        signatoryRects.add(sr);
                                        this.logger.info("keyword\uff1a{}\uff0csr: {}", (Object)keyword, (Object)JSON.toJSONString((Object)sr, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
                                    }
                                }
                            }
                            if (Boolean.TRUE.equals(rect.getTimeStampFlag()) && StringUtils.isNotBlank((CharSequence)rect.getTimeStampKeyWords()) && CollectionUtils.isNotEmpty(timeStampKeyWords = Arrays.asList(rect.getTimeStampKeyWords().split(regex)))) {
                                for (String timeStampKeyWord : timeStampKeyWords) {
                                    if (!StringUtils.isNotBlank((CharSequence)timeStampKeyWord)) continue;
                                    sr = new SignatoryRect();
                                    sr.setRectType(StamperType.TIMESTAMP);
                                    sr.setKeyword(timeStampKeyWord);
                                    sr.setKeywordIndex(rect.getKeywordIndex());
                                    signatoryRects.add(sr);
                                }
                            }
                            if (Boolean.TRUE.equals(rect.getAcrossFlag()) && StringUtils.isNotBlank((CharSequence)rect.getAcrossSetting())) {
                                SignatoryRect sr2;
                                if ("ACROSS_PAGE_ODD".equals(rect.getAcrossSetting())) {
                                    sr2 = new SignatoryRect();
                                    sr2.setRectType(StamperType.ACROSS_PAGE_ODD);
                                    sr2.setOffsetY(Double.valueOf(offsetY * (double)num.incrementAndGet()));
                                    signatoryRects.add(sr2);
                                }
                                if ("ACROSS_PAGE".equals(rect.getAcrossSetting())) {
                                    sr2 = new SignatoryRect();
                                    sr2.setRectType(StamperType.ACROSS_PAGE);
                                    sr2.setOffsetY(Double.valueOf(offsetY * (double)num.incrementAndGet()));
                                    signatoryRects.add(sr2);
                                }
                            }
                        }
                        sms.setOffsetX(rect.getOffsetX());
                        sms.setOffsetY(rect.getOffsetY());
                        sms.setPage(rect.getPage());
                        sms.setKeywords(rect.getKeywords());
                        sms.setKeywordIndex(rect.getKeywordIndex());
                        sms.setTimeStampFlag(rect.getTimeStampFlag());
                        sms.setTimeStampKeyWords(rect.getTimeStampKeyWords());
                        sms.setAcrossFlag(rect.getAcrossFlag());
                        sms.setAcrossSetting(rect.getAcrossSetting());
                    }
                    if (CollectionUtils.isNotEmpty(signatoryRects)) {
                        action.setLocations(signatoryRects);
                    }
                }
                actions.add(action);
            }
            signatory.setActions(actions);
            if (flag && null != firstInnerNoPsSealId && !innerSign) {
                this.logger.info("\u5f53\u524d\u7b7e\u7f72\u65b9\u672a\u5185\u90e8\u5355\u4f4d\uff0c\u83b7\u53d6\u7b2c\u4e00\u4e2a\u975e\u4e2a\u4eba\u5370\u7ae0-\u3010sourceSealId-{}\u3011\u4fe1\u606f", firstInnerNoPsSealId);
                seal = this.managementService.getBeSourceSealId(firstInnerNoPsSealId);
                this.logger.info("\u5f53\u524d\u7b7e\u7f72\u65b9\u672a\u5185\u90e8\u5355\u4f4d\uff0c\u83b7\u53d6\u7b2c\u4e00\u4e2a\u975e\u4e2a\u4eba\u5370\u7ae0-\u3010{}\u3011\u4fe1\u606f", (Object)JSONObject.toJSONString((Object)((Object)seal)));
                if (null != seal) {
                    signatory.setTenantName(seal.getSourceCompanyName());
                }
                firstInnerNoPsSealId = null;
            }
            if (signatoryVO.getSignatoryActionVOS().size() == 1 && ("PERSONAL".equals(((SignatoryActionVO)signatoryVO.getSignatoryActionVOS().get(0)).getSignActionType()) || "OPERATOR".equals(((SignatoryActionVO)signatoryVO.getSignatoryActionVOS().get(0)).getSignActionType()))) {
                signatory.setTenantType(TenantType.PERSONAL);
            }
            if (signatories.size() != 0 && innerSign) continue;
            signatories.add(signatory);
        }
        request.setSignatories(signatories);
        return request;
    }

    private void checkInnerUser(List<OperatorVO> ops) {
        Map<String, String> userMap = ops.stream().filter(op -> null != op.getOperatorId()).collect(Collectors.toMap(item -> item.getOperatorId().toString(), item -> item.getOperatorName()));
        String[] userIds = userMap.keySet().toArray(new String[userMap.keySet().size()]);
        if (userIds.length > 0) {
            CommonResponse users = this.userApi.queryListByIdsTenantId(userIds, InvocationInfoProxy.getTenantid());
            if (!users.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)users.getData()))) {
                this.logger.error("\u67e5\u8be2\u4eba\u5458-[ids-\u3010{}\u3011]\u4fe1\u606f\u5931\u8d25: {}", (Object)JSONObject.toJSONString((Object)userIds), (Object)JSONObject.toJSONString((Object)users));
                throw new BusinessException("\u83b7\u53d6\u5185\u90e8\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff01");
            }
            Set dbUserIds = ((List)users.getData()).stream().map(BaseVO::getId).collect(Collectors.toSet());
            if (userIds.length != dbUserIds.size()) {
                List userIdList = ((List)users.getData()).stream().map(u -> u.getId().toString()).collect(Collectors.toList());
                userIdList.stream().forEach(uid -> userMap.remove(uid));
                this.logger.error("\u4eba\u5458-[ids-\u3010{}\u3011]\u4fe1\u606f\u5931\u8d25", (Object)JSONObject.toJSONString(userMap.keySet()));
                throw new BusinessException("\u5185\u90e8\u4eba\u5458\u3010" + StringUtils.join(userMap.values(), (String)",") + "\u3011\u4fe1\u606f\u9a8c\u8bc1\u672a\u901a\u8fc7\uff01");
            }
        }
    }

    public String sendContract(Long contractId) {
        Assert.notNull((Object)contractId, (String)"\u53d1\u8d77\u5408\u540c\uff0c\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ContractServiceImpl contractService = new ContractServiceImpl(this.getSdkClient());
        SendContractRequest request = new SendContractRequest();
        request.setContractId(contractId);
        try {
            contractService.send(request);
        }
        catch (PrivateAppException e) {
            this.logger.error("\u53d1\u8d77\u5408\u540c\u5931\u8d25\uff0c\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\uff1a{}\uff0c\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)contractId, (Object)e.getMessage());
            return e.getMessage() + "\uff0c\u8bf7\u68c0\u67e5\u4e0b\u9879\u76ee\u7b80\u79f0\u548c\u5408\u540c\u540d\u79f0\u662f\u5426\u8fc7\u957f\uff0c\u5982\u95ee\u9898\u672a\u89e3\u51b3\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u8005\u54a8\u8be2\u552e\u540e\u4eba\u5458!";
        }
        return null;
    }

    public String preSignUrl(Long contractId, Boolean canSaveOrClose, Boolean canSetParam, Boolean canSend, Boolean canSetStamper, Long documentId, String invalidToPage) {
        Assert.notNull((Object)contractId, (String)"\u9884\u7b7e\u7f72\u9875\u9762\uff0c\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)canSaveOrClose, (String)"\u9884\u7b7e\u7f72\u9875\u9762\uff0c\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u662f\u5426\u5c55\u793a\u4fdd\u5b58\u5e76\u5173\u95ed\u6309\u94ae\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)canSetParam, (String)"\u9884\u7b7e\u7f72\u9875\u9762\uff0c\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u662f\u5426\u53ef\u4ee5\u586b\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)canSend, (String)"\u9884\u7b7e\u7f72\u9875\u9762\uff0c\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u662f\u5426\u53ef\u4ee5\u53d1\u8d77\u5408\u540c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)canSetStamper, (String)"\u9884\u7b7e\u7f72\u9875\u9762\uff0c\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u662f\u5426\u53ef\u4ee5\u6307\u5b9a\u7b7e\u7f72\u4f4d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)documentId, (String)"\u9884\u7b7e\u7f72\u9875\u9762\uff0c\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u9875\u9762\u9700\u5c55\u793a\u6587\u6863\u7684ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)invalidToPage, (String)"\u9884\u7b7e\u7f72\u9875\u9762\uff0c\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u94fe\u63a5\u5931\u6548\u540e\u8df3\u8f6c\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String preSignUrl = null;
        try {
            Stopwatch start = Stopwatch.createStarted();
            ContractServiceImpl contractService = new ContractServiceImpl(this.getSdkClient());
            PreSignUrlRequest request = new PreSignUrlRequest();
            request.setContractId(contractId);
            request.setCanSaveOrClose(canSaveOrClose);
            request.setCanSetParam(canSetParam);
            request.setCanSend(canSend);
            request.setCanSetStamper(canSetStamper);
            request.setDocumentId(documentId);
            request.setInvalidToPage(invalidToPage);
            preSignUrl = contractService.preSignUrl(request);
            Stopwatch end = start.stop();
            this.logger.info("\u83b7\u53d6\u9884\u7b7e\u7f72\u9875\u9762\u94fe\u63a5\uff0c\u7ed3\u675f\u3002\u5171\u8ba1\u8017\u65f6\uff1a\u300c{}\u300d\u79d2", (Object)end.elapsed(TimeUnit.SECONDS));
        }
        catch (PrivateAppException e) {
            this.logger.error("\u83b7\u53d6\u9884\u7b7e\u7f72\u9875\u9762\u94fe\u63a5\u5931\u8d25\uff0c\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\uff1a{}\uff0c\u662f\u5426\u53ef\u4ee5\u53d1\u8d77\u5408\u540c\uff1a{}\uff0c\u94fe\u63a5\u5931\u6548\u540e\u8df3\u8f6c\u5730\u5740\uff1a{}\uff0c\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{contractId, canSend, invalidToPage, e.getMessage()});
        }
        this.logger.info("\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\uff1a{}\uff0c\u9884\u7b7e\u7f72\u94fe\u63a5:{}", (Object)contractId, preSignUrl);
        return preSignUrl;
    }

    public ContractDetail thirdContractDetail(Long contractId, Boolean countSeal, boolean isDelCheck) {
        ContractDetail detail;
        Assert.notNull((Object)contractId, (String)"\u6839\u636e\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\u67e5\u8be2\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540c\u8be6\u60c5\uff0c\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)countSeal, (String)"\u6839\u636e\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\u67e5\u8be2\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540c\u8be6\u60c5\uff0c\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u662f\u5426\u7edf\u8ba1\u5370\u7ae0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ContractServiceImpl contractService = new ContractServiceImpl(this.getSdkClient());
        try {
            detail = contractService.detail(contractId, Boolean.valueOf(true));
        }
        catch (PrivateAppException e) {
            this.logger.error("\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\uff1a{}\uff0c\u67e5\u8be2\u5408\u540c\u8be6\u60c5\u5f02\u5e38\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)contractId, (Object)e);
            if (isDelCheck && null != e.getMessage() && e.getMessage().indexOf("\u627e\u4e0d\u5230ID\u4e3a") >= 0 && e.getMessage().indexOf("\u7684\u6587\u4ef6") >= 0) {
                this.logger.info("\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\uff1a{}\uff0c\u67e5\u8be2\u5408\u540c\u8be6\u60c5\u5f02\u5e38\uff01\u7b2c\u4e09\u65b9\u5bf9\u5e94\u6587\u4ef6\u672a\u83b7\u53d6\u5230, \u7ee7\u7eedPM\u64cd\u4f5c\u903b\u8f91");
                detail = new ContractDetail();
                detail.setStatus(ContractStatus.DRAFT);
                detail.setBusinessData("\u7b2c\u4e09\u65b9\u6587\u4ef6\u4e0d\u5b58\u5728,TFNN");
            }
            throw new BusinessException("\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u6839\u636e\u5408\u540cid\u67e5\u8be2\u5408\u540c\u8be6\u60c5\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
        }
        return detail;
    }

    public void deleteThirdContract(Long contractId) {
        Assert.notNull((Object)contractId, (String)"\u6839\u636e\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\u5220\u9664\u5408\u540c\uff0c\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        try {
            Stopwatch start = Stopwatch.createStarted();
            ContractServiceImpl contractService = new ContractServiceImpl(this.getSdkClient());
            contractService.delete(contractId);
            Stopwatch end = start.stop();
            this.logger.info("\u6839\u636e\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\u5220\u9664\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540c\u7ed3\u675f\u3002\u5171\u8ba1\u8017\u65f6\uff1a\u300c{}\u300d\u79d2", (Object)end.elapsed(TimeUnit.SECONDS));
        }
        catch (PrivateAppException e) {
            this.logger.error("\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u5408\u540cid\uff1a{}\uff0c\u5220\u9664\u5408\u540c\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)contractId, (Object)e.getMessage());
            throw new BusinessException("\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u6839\u636e\u5408\u540cid\u5220\u9664\u5408\u540c\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    public void deleteContractSignatureData(Long contractId) {
        this.signatureRectMapper.deleteContractSignatureData(contractId);
    }

    public List<SignMgrSignatoryEntity> nextAction(List<SignMgrSignatoryEntity> entities, boolean flag) {
        Assert.notEmpty(entities, (String)"\u67e5\u8be2\u4e0b\u4e00\u4e2a\u7b7e\u7f72\u52a8\u4f5c\uff0c\u7b7e\u7f72\u52a8\u4f5c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ArrayList<SignMgrSignatoryEntity> operators = new ArrayList<SignMgrSignatoryEntity>();
        if (flag) {
            entities.sort(Comparator.comparing(SignMgrSignatoryEntity::getSignOrder).thenComparing(SignMgrSignatoryEntity::getSealSignOrder));
            List<SignMgrSignatoryEntity> entityList = entities.stream().filter(e -> Objects.equals(e.getSignOrder(), ((SignMgrSignatoryEntity)((Object)((Object)entities.get(0)))).getSignOrder()) && Objects.equals(e.getSealSignOrder(), ((SignMgrSignatoryEntity)((Object)((Object)entities.get(0)))).getSealSignOrder())).collect(Collectors.toList());
            operators.addAll(entityList);
            this.updateBatchToBeSigned(entityList);
        } else {
            List entityList = entities.stream().filter(e -> Objects.equals(e.getJobStatus(), SignMgrSignatoryEnum.TO_BE_ACTIVATED.getValue())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(entityList)) {
                entityList.sort(Comparator.comparing(SignMgrSignatoryEntity::getSignOrder).thenComparing(SignMgrSignatoryEntity::getSealSignOrder));
                List<SignMgrSignatoryEntity> entityList1 = entityList.stream().filter(e -> Objects.equals(e.getSignOrder(), ((SignMgrSignatoryEntity)((Object)((Object)entityList.get(0)))).getSignOrder()) && Objects.equals(e.getSealSignOrder(), ((SignMgrSignatoryEntity)((Object)((Object)entityList.get(0)))).getSealSignOrder())).collect(Collectors.toList());
                operators.addAll(entityList1);
                this.updateBatchToBeSigned(entityList1);
            }
        }
        return operators;
    }

    private void updateBatchToBeSigned(List<SignMgrSignatoryEntity> entityList) {
        entityList.forEach(e -> e.setJobStatus(SignMgrSignatoryEnum.TO_BE_SIGNED.getValue()));
        this.signMgrSignatoryService.saveOrUpdateBatch(entityList, 5);
    }

    private String getAuthority() {
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        return request.getHeader("authority");
    }

    public RequestAttributes getAttributes() {
        return RequestContextHolder.getRequestAttributes();
    }

    public UserVO getUserVO(Long userId) {
        Assert.notNull((Object)userId, (String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\uff0c\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CommonResponse response = this.userApi.findUserByUserId(userId);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u6839\u636e\u7528\u6237id\uff0c\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        return (UserVO)response.getData();
    }

    public String concatSubject(String subject, String billName, String contractName, Long orgId, Long projectId) {
        Assert.hasText((String)subject, (String)"\u5408\u540c\u4e3b\u9898(\u539f\u59cb)\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)orgId, (String)"\u5408\u540c\u4e3b\u9898\uff0c\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        StringBuilder sb = new StringBuilder();
        sb.append(subject).append(billName);
        CommonResponse orgVOResponse = this.orgApi.detailById(orgId);
        if (!orgVOResponse.isSuccess() || orgVOResponse.getData() == null) {
            throw new BusinessException("\u6839\u636e\u7ec4\u7ec7id" + orgId + "\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + orgVOResponse.getMsg());
        }
        OrgVO org = (OrgVO)orgVOResponse.getData();
        if (org.getOrgType().equals(5)) {
            orgVOResponse = this.orgApi.detailById(org.getParentId());
            if (!orgVOResponse.isSuccess() || orgVOResponse.getData() == null) {
                throw new BusinessException("\u6839\u636e\u7ec4\u7ec7id" + orgId + "\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + orgVOResponse.getMsg());
            }
            org = (OrgVO)orgVOResponse.getData();
        }
        if (StringUtils.isNotBlank((CharSequence)org.getShortName())) {
            sb.append("_").append(org.getShortName());
        }
        if (projectId != null) {
            CommonResponse projectPoolSetVOResponse = this.projectSetApi.getProjectId(projectId);
            if (!projectPoolSetVOResponse.isSuccess() || projectPoolSetVOResponse.getData() == null) {
                throw new BusinessException("\u6839\u636e\u9879\u76eeid" + projectId + "\uff0c\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + projectPoolSetVOResponse.getMsg());
            }
            if (StringUtils.isNotBlank((CharSequence)((ProjectPoolSetVO)projectPoolSetVOResponse.getData()).getShortName())) {
                sb.append("_").append(((ProjectPoolSetVO)projectPoolSetVOResponse.getData()).getShortName());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)contractName)) {
            sb.append("_").append(contractName);
        }
        if (sb.length() > 80 && contractName.contains("\u4e2d\u6807\u901a\u77e5\u4e66")) {
            throw new BusinessException("\u4e3b\u6807\u9898\u8fc7\u957f\uff0c\u8bf7\u4fee\u6539\uff01");
        }
        return sb.toString();
    }

    private Integer countAcross(List<SignatoryActionVO> signatoryActionVOS) {
        Assert.notEmpty(signatoryActionVOS, (String)"\u7edf\u8ba1\u9a91\u7f1d\u7ae0\u6570\u91cf\uff0c\u7b7e\u7f72\u52a8\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AtomicInteger count = new AtomicInteger();
        signatoryActionVOS.forEach(signatoryActionVO -> {
            if (CollectionUtils.isNotEmpty((Collection)signatoryActionVO.getSignatoryRectVOS())) {
                signatoryActionVO.getSignatoryRectVOS().forEach(signatoryRectVO -> {
                    if (signatoryRectVO.getAcrossFlag() != null && signatoryRectVO.getAcrossFlag().booleanValue()) {
                        count.incrementAndGet();
                    }
                });
            }
        });
        return count.get();
    }
}

