package com.ejianc.business.signaturemanage.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.signaturemanage.bean.SignMgrEntity;
import com.ejianc.business.signaturemanage.enums.SignMgrSignatoryEnum;
import com.ejianc.business.signaturemanage.service.ISignMgrService;
import com.ejianc.business.signaturemanage.vo.SignMgrVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2023/4/26 11:34
 */
@RestController
@RequestMapping(value = "/signMonitor/")
public class SignMonitorController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISignMgrService signMgrService;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    /**
     * 列表查询
     *
     * @param queryParam 查询参数
     *
     * @return 返回列表
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<SignMgrVO>> queryList(@RequestBody QueryParam queryParam) {
        IPage<SignMgrVO> pageResp = new Page<>();
        List<String> fields = queryParam.getFuzzyFields();
        fields.add("contractName");
        fields.add("billCode");
        fields.add("projectName");
        fields.add("recallUserName");

        IPage<SignMgrEntity> pageData = signMgrService.queryPage(queryParam, false);
        pageResp.setTotal(pageData.getTotal());
        pageResp.setSize(pageData.getSize());
        pageResp.setCurrent(pageData.getCurrent());
        pageResp.setRecords(BeanMapper.mapList(pageData.getRecords(), SignMgrVO.class));

        return CommonResponse.success(pageResp);
    }

    /**
     * excel导出
     *
     * @return
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<SignMgrVO> dataList = new ArrayList<>();
        List<String> fields = queryParam.getFuzzyFields();
        fields.add("contractName");
        fields.add("billCode");
        fields.add("projectName");
        fields.add("recallUserName");
        String signStatus = queryParam.getParams().get("signStatus").getValue().toString();
        String exportExcelName = "SigningList-export.xlsx";
        if(signStatus.equals(SignMgrSignatoryEnum.WITHDRAWN.getValue().toString())) {
            exportExcelName = "RecallList-export.xlsx";
        } else if(signStatus.equals(SignMgrSignatoryEnum.SIGNED.getValue().toString())) {
            exportExcelName = "SignedList-export.xlsx";
        }

        CommonResponse<List<Long>> projectIdReps = projectPoolApi.queryProjectIdsByorgId(InvocationInfoProxy.getOrgId(), null, null);
        if(!projectIdReps.isSuccess()) {
            logger.error("获取本息项目信息失败, {}", JSONObject.toJSONString(projectIdReps));
            throw new BusinessException("获取本息项目信息失败！");
        }

        queryParam.getParams().put("projectId", new Parameter(QueryParam.IN, projectIdReps.getData()));

        List<SignMgrEntity> list = signMgrService.queryList(queryParam, false);
        dataList = BeanMapper.mapList(list, SignMgrVO.class);

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dataList.forEach(e -> {
            if(null != e.getFinishTime()) {
                e.setFinishTimeStr(sdf.format(e.getFinishTime()));
            }
            if(null != e.getCreateTime()) {
                e.setCreateTimeStr(sdf.format(e.getCreateTime()));
            }
            if(null != e.getRecallTime()) {
                e.setRecallTimeStr(sdf.format(e.getRecallTime()));
            }
            e.setSignStatusName(SignMgrSignatoryEnum.getSignStatusEnumByCode(e.getSignStatus()).getDescription());
        });

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", dataList);
        ExcelExport.getInstance().export(exportExcelName, beans, response);
    }

}
