/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.signaturemanage.bean.SignatureSettingEntity;
import com.ejianc.business.signaturemanage.service.ISignatureSettingService;
import com.ejianc.business.signaturemanage.service.ISignatureSettingSubService;
import com.ejianc.business.signaturemanage.vo.SignatureSettingVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"signatureSetting"})
public class SignatureSettingController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISignatureSettingService service;
    @Autowired
    private ISignatureSettingSubService subService;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SignatureSettingVO> saveOrUpdate(@RequestBody SignatureSettingVO settingVO) {
        return this.service.saveOrUpdateSignature(settingVO);
    }

    @ResponseBody
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<SignatureSettingVO>> queryList(@RequestBody QueryParam param) {
        ArrayList orgIdList = new ArrayList();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("unitName");
        fuzzyFields.add("defaultSealName");
        fuzzyFields.add("createName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        CommonResponse orgResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgResp.isSuccess()) {
            Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize(), 0L);
            return CommonResponse.success((String)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u5931\u8d25\uff0c\u9879\u76ee\u7ec4\u7ec7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01", (Object)pageData);
        }
        List orgList = (List)orgResp.getData();
        if (CollectionUtils.isNotEmpty((Collection)orgList)) {
            orgList.forEach(orgVO -> orgIdList.add(orgVO.getId()));
            if (CollectionUtils.isNotEmpty(orgIdList)) {
                param.getParams().put("unitId", new Parameter("in", orgIdList));
            }
        }
        IPage page = this.service.queryPage(param, false);
        for (SignatureSettingEntity s : page.getRecords()) {
            s.setDefaultSealName(this.subService.getDefaultSealName(s.getId()));
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SignatureSettingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ResponseBody
    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.POST})
    public CommonResponse<SignatureSettingVO> updateStatus(@RequestBody SignatureSettingVO settingVO) {
        SignatureSettingEntity entity = (SignatureSettingEntity)((Object)this.service.selectById(settingVO.getId()));
        entity.setEnableStatus(settingVO.getEnableStatus());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), SignatureSettingVO.class));
    }

    @ResponseBody
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<SignatureSettingVO> queryDetail(Long id) {
        return this.service.queryDetail(id);
    }

    @ResponseBody
    @RequestMapping(value={"/queryDefaultSeal"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> queryDefaultSeal(String unitId) {
        return this.service.queryDefaultSeal(unitId);
    }

    @GetMapping(value={"/getUnitsDefaultSeal"})
    @ResponseBody
    public CommonResponse<JSONObject> getUnitsDefaultSeal(@RequestParam List<Long> unitIds) {
        return this.service.getUnitsDefaultSeal(unitIds);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getParams().put("unit_id", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage pageData = this.service.queryPage(param, false);
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            List list = BeanMapper.mapList((Iterable)pageData.getRecords(), SignatureSettingVO.class);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SignatureSettingVO vo;
                vo.setEnableStatusStr((vo = (SignatureSettingVO)iterator.next()).getEnableStatus() == 1 ? "\u542f\u7528" : "\u505c\u7528");
                vo.setSealCreateTimeStr(sdf.format(vo.getSealCreateTime()));
                vo.setDefaultSealName(this.subService.getDefaultSealName(vo.getId()));
            }
            HashMap<String, List> beans = new HashMap<String, List>(list.size());
            this.logger.error(JSONObject.toJSONString((Object)list));
            beans.put("bean", list);
            ExcelExport.getInstance().export("\u7b7e\u7ae0.xlsx", beans, response);
        }
    }
}

