/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.signaturemanage.bean.ManagementEntity;
import com.ejianc.business.signaturemanage.bean.ManagementUserEntity;
import com.ejianc.business.signaturemanage.mapper.ManagementMapper;
import com.ejianc.business.signaturemanage.service.IManagementService;
import com.ejianc.business.signaturemanage.service.IManagementUserService;
import com.ejianc.business.signaturemanage.service.ISealManageService;
import com.ejianc.business.signaturemanage.vo.ManagementUserVO;
import com.ejianc.business.signaturemanage.vo.ManagementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="managementService")
public class ManagementServiceImpl
extends BaseServiceImpl<ManagementMapper, ManagementEntity>
implements IManagementService {
    private static final String BILL_CODE = "LJL_MANAGEMENT";
    @Autowired
    private IBillCodeApi billCodeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IManagementService service;
    @Autowired
    private ISealManageService sealManageService;
    @Autowired
    private IManagementUserService userService;
    @Autowired
    private IOrgApi orgApi;
    @Value(value="${seal.defaultSealPng.personal}")
    private String personalImgUrl;

    public String getPersonalImgUrl() {
        return this.personalImgUrl;
    }

    public void setPersonalImgUrl(String personalImgUrl) {
        this.personalImgUrl = personalImgUrl;
    }

    @Override
    public CommonResponse<ManagementVO> updateManagement(ManagementVO vo) {
        ManagementEntity managementEntity = (ManagementEntity)((Object)this.selectById(vo.getId()));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter("eq", (Object)managementEntity.getId()));
        queryParam.getParams().put("user_type", new Parameter("eq", (Object)"user"));
        List managementUserEntities = this.userService.queryList(queryParam);
        if (!managementUserEntities.isEmpty()) {
            this.userService.deleteUserByIdList(managementUserEntities.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
        if (null != vo.getOrgId()) {
            managementEntity.setOrgId(vo.getOrgId());
            CommonResponse oneById = this.orgApi.getOneById(vo.getOrgId());
            managementEntity.setOrgName(vo.getOrgName());
            managementEntity.setTenantId(((OrgVO)oneById.getData()).getTenantId());
            managementEntity.setIsMatch(1);
        }
        List userEntities = BeanMapper.mapList((Iterable)vo.getUserEntityList(), ManagementUserEntity.class);
        StringBuilder stringBuilder = new StringBuilder();
        for (ManagementUserEntity u : userEntities) {
            stringBuilder.append(u.getUserName());
            stringBuilder.append(",");
            u.setUserType("user");
            if (1 != u.getIsDefault()) continue;
            managementEntity.setSealDefaultId(u.getId());
            managementEntity.setSealDefaultName(u.getUserName());
        }
        managementEntity.setContractSealFlag(vo.getContractSealFlag());
        managementEntity.setSealUseName(stringBuilder.toString());
        managementEntity.setUserEntityList(userEntities);
        this.saveOrUpdate((Object)managementEntity, false);
        List managementUserVoS = BeanMapper.mapList((Iterable)userEntities, ManagementUserVO.class);
        ManagementVO map = (ManagementVO)BeanMapper.map((Object)((Object)managementEntity), ManagementVO.class);
        map.setUserEntityList(managementUserVoS);
        return CommonResponse.success((Object)map);
    }

    private ManagementEntity bySourceSealId(ManagementEntity managementEntity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_seal_id", (Object)managementEntity.getSourceSealId());
        return (ManagementEntity)((Object)this.getOne((Wrapper)queryWrapper));
    }

    private void newManagement(ManagementEntity managementEntity) {
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if (billCode.isSuccess()) {
            managementEntity.setBillCode((String)billCode.getData());
            OrgVO orgVO = new OrgVO();
            orgVO.setTenantId(InvocationInfoProxy.getTenantid());
            orgVO.setName(managementEntity.getSourceCompanyName());
            CommonResponse oneByOrgVO = this.orgApi.findOneByOrgVO(orgVO);
            if (oneByOrgVO.isSuccess()) {
                if (null != oneByOrgVO.getData()) {
                    this.checkPerson((OrgVO)oneByOrgVO.getData());
                    managementEntity.setTenantId(((OrgVO)oneByOrgVO.getData()).getTenantId());
                    managementEntity.setOrgName(((OrgVO)oneByOrgVO.getData()).getName());
                    managementEntity.setOrgId(((OrgVO)oneByOrgVO.getData()).getId());
                    managementEntity.setEnableStatus(1);
                    managementEntity.setIsMatch(1);
                } else {
                    managementEntity.setEnableStatus(0);
                    managementEntity.setIsMatch(0);
                }
            }
            if ("\u5408\u540c\u4e13\u7528\u7ae0".equals(managementEntity.getSealSubTypeName())) {
                managementEntity.setContractSealFlag(1);
            } else {
                managementEntity.setContractSealFlag(0);
            }
            if ("NORMAL".equals(managementEntity.getSourceStatus())) {
                managementEntity.setEnableStatus(1);
            } else {
                managementEntity.setEnableStatus(0);
            }
        } else {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.saveOrUpdate((Object)managementEntity);
    }

    @Override
    public void syncUpdate(ManagementEntity managementEntity, String authority) {
        ManagementEntity entity = this.bySourceSealId(managementEntity);
        if (null == entity) {
            this.newManagement(managementEntity);
        } else {
            entity.setSourceCompanyId(managementEntity.getSourceCompanyId());
            entity.setSourceCompanyName(managementEntity.getSourceCompanyName());
            entity.setSourceStatus(managementEntity.getSourceStatus());
            entity.setSealSubTypeName(managementEntity.getSealSubTypeName());
            entity.setEnableStatus(managementEntity.getEnableStatus());
            entity.setSourceSealName(managementEntity.getSourceSealName());
            entity.setSourceSealId(managementEntity.getSourceSealId());
            if (StringUtils.isNotEmpty((CharSequence)managementEntity.getSourceStatusDescription())) {
                entity.setSourceStatusDescription(managementEntity.getSourceStatusDescription());
            }
            if (StringUtils.isNotEmpty((CharSequence)managementEntity.getSealType())) {
                entity.setSealType(managementEntity.getSealType());
            }
            if ("\u5408\u540c\u4e13\u7528\u7ae0".equals(managementEntity.getSealSubTypeName())) {
                managementEntity.setContractSealFlag(1);
            } else {
                managementEntity.setContractSealFlag(0);
            }
            this.saveOrUpdate((Object)entity, false);
        }
    }

    public void checkPerson(OrgVO orgVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orgId", new Parameter("eq", (Object)orgVO.getId()));
        queryParam.getParams().put("sealType", new Parameter("eq", (Object)"PERSONAL"));
        List managementEntities = this.queryList(queryParam, false);
        if (managementEntities.isEmpty()) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                ManagementEntity entity = new ManagementEntity();
                entity.setOrgId(orgVO.getId());
                entity.setOrgName(orgVO.getName());
                entity.setIsMatch(1);
                entity.setSourceStatus("NORMAL");
                entity.setTenantId(InvocationInfoProxy.getTenantid());
                entity.setBillCode((String)billCode.getData());
                entity.setSealSubTypeName("\u4e2a\u4eba");
                entity.setImgUrl(this.personalImgUrl);
                entity.setSealCategory("ELECTRONIC");
                entity.setSealType("PERSONAL");
                entity.setSourceSealId(IdWorker.getId());
                entity.setSourceSealName("\u4e2a\u4eba\u7b7e\u7ae0");
                entity.setSourceCompanyName(orgVO.getName());
                entity.setContractSealFlag(0);
                entity.setEnableStatus(1);
                entity.setSourceStatusDescription("\u6b63\u5e38");
                this.saveOrUpdate((Object)entity, false);
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
    }

    @Override
    public void batchSaveOrUpdate(List<ManagementEntity> entityList) {
        List sealIds = entityList.parallelStream().map(ManagementEntity::getSourceSealId).collect(Collectors.toList());
        Map<Long, ManagementEntity> entityListMap = entityList.stream().collect(Collectors.toMap(ManagementEntity::getSourceSealId, Function.identity(), (k1, k2) -> k2));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"source_seal_id", sealIds);
        List updateEntities = this.service.list((Wrapper)wrapper);
        List updateSealIds = updateEntities.parallelStream().map(ManagementEntity::getSourceSealId).collect(Collectors.toList());
        List<ManagementEntity> insertEntities = entityList.parallelStream().filter(e -> !updateSealIds.contains(e.getSourceSealId())).collect(Collectors.toList());
        if (!insertEntities.isEmpty()) {
            this.batchSave(insertEntities);
        }
        if (!updateEntities.isEmpty()) {
            this.batchUpdate(updateEntities, entityListMap);
        }
    }

    @Override
    public void batchSave(List<ManagementEntity> entityList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"seal_type", (Object)"PERSONAL");
        List personal = this.service.list((Wrapper)queryWrapper);
        Map personalMap = personal.stream().collect(Collectors.toMap(ManagementEntity::getSourceCompanyName, Function.identity(), (k1, k2) -> k2));
        OrgVO orgVO = new OrgVO();
        orgVO.setTenantId(InvocationInfoProxy.getTenantid());
        HashMap<String, Object> orgVOMap = new HashMap<String, Object>();
        for (ManagementEntity managementEntity : entityList) {
            ManagementEntity entity;
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            managementEntity.setBillCode((String)billCode.getData());
            if (orgVOMap.containsKey(managementEntity.getSourceCompanyName())) {
                OrgVO orgVO1 = (OrgVO)orgVOMap.get(managementEntity.getSourceCompanyName());
                if (!personalMap.containsKey(managementEntity.getSourceCompanyName())) {
                    CommonResponse billCode2 = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
                    if (!billCode.isSuccess()) {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    entity = new ManagementEntity();
                    entity.setOrgId(orgVO1.getId());
                    entity.setOrgName(orgVO1.getName());
                    entity.setIsMatch(1);
                    entity.setSourceStatus("NORMAL");
                    entity.setTenantId(InvocationInfoProxy.getTenantid());
                    entity.setBillCode((String)billCode2.getData());
                    entity.setSealSubTypeName("\u4e2a\u4eba");
                    entity.setImgUrl(this.personalImgUrl);
                    entity.setSealCategory("ELECTRONIC");
                    entity.setSealType("PERSONAL");
                    entity.setSourceSealId(IdWorker.getId());
                    entity.setSourceSealName("\u4e2a\u4eba\u7b7e\u7ae0");
                    entity.setSourceCompanyName(orgVO1.getName());
                    entity.setContractSealFlag("\u5408\u540c\u4e13\u7528\u7ae0".equals(managementEntity.getSealSubTypeName()) ? 1 : 0);
                    entity.setEnableStatus("NORMAL".equals(managementEntity.getSourceStatus()) ? 1 : 0);
                    entity.setSourceStatusDescription("\u6b63\u5e38");
                    this.saveOrUpdate((Object)entity, false);
                    personalMap.put(entity.getSourceCompanyName(), entity);
                }
                managementEntity.setTenantId(orgVO1.getTenantId());
                managementEntity.setOrgName(orgVO1.getName());
                managementEntity.setOrgId(orgVO1.getId());
                managementEntity.setEnableStatus(1);
                managementEntity.setIsMatch(1);
                managementEntity.setContractSealFlag("\u5408\u540c\u4e13\u7528\u7ae0".equals(managementEntity.getSealSubTypeName()) ? 1 : 0);
                managementEntity.setEnableStatus("NORMAL".equals(managementEntity.getSourceStatus()) ? 1 : 0);
                continue;
            }
            orgVO.setName(managementEntity.getSourceCompanyName());
            CommonResponse oneByOrgVO = this.orgApi.findOneByOrgVO(orgVO);
            if (!oneByOrgVO.isSuccess()) continue;
            if (oneByOrgVO.getData() != null) {
                if (!personalMap.containsKey(managementEntity.getSourceCompanyName())) {
                    CommonResponse billCode1 = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
                    if (!billCode.isSuccess()) {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    entity = new ManagementEntity();
                    entity.setOrgId(((OrgVO)oneByOrgVO.getData()).getId());
                    entity.setOrgName(((OrgVO)oneByOrgVO.getData()).getName());
                    entity.setIsMatch(1);
                    entity.setSourceStatus("NORMAL");
                    entity.setTenantId(InvocationInfoProxy.getTenantid());
                    entity.setBillCode((String)billCode1.getData());
                    entity.setSealSubTypeName("\u4e2a\u4eba");
                    entity.setImgUrl(this.personalImgUrl);
                    entity.setSealCategory("ELECTRONIC");
                    entity.setSealType("PERSONAL");
                    entity.setSourceSealId(IdWorker.getId());
                    entity.setSourceSealName("\u4e2a\u4eba\u7b7e\u7ae0");
                    entity.setSourceCompanyName(((OrgVO)oneByOrgVO.getData()).getName());
                    entity.setContractSealFlag("\u5408\u540c\u4e13\u7528\u7ae0".equals(managementEntity.getSealSubTypeName()) ? 1 : 0);
                    entity.setEnableStatus("NORMAL".equals(managementEntity.getSourceStatus()) ? 1 : 0);
                    entity.setSourceStatusDescription("\u6b63\u5e38");
                    this.saveOrUpdate((Object)entity, false);
                    personalMap.put(entity.getSourceCompanyName(), entity);
                }
                orgVOMap.put(managementEntity.getSourceCompanyName(), oneByOrgVO.getData());
                managementEntity.setTenantId(((OrgVO)oneByOrgVO.getData()).getTenantId());
                managementEntity.setOrgName(((OrgVO)oneByOrgVO.getData()).getName());
                managementEntity.setOrgId(((OrgVO)oneByOrgVO.getData()).getId());
                managementEntity.setEnableStatus(1);
                managementEntity.setIsMatch(1);
            } else {
                managementEntity.setEnableStatus(0);
                managementEntity.setIsMatch(0);
            }
            managementEntity.setContractSealFlag("\u5408\u540c\u4e13\u7528\u7ae0".equals(managementEntity.getSealSubTypeName()) ? 1 : 0);
            managementEntity.setEnableStatus("NORMAL".equals(managementEntity.getSourceStatus()) ? 1 : 0);
        }
        this.logger.info("entityList>>>>>>>>>{}", (Object)entityList.size());
        this.service.saveBatch(entityList);
    }

    @Override
    public void batchUpdate(List<ManagementEntity> updateEntities, Map<Long, ManagementEntity> entityListMap) {
        Boolean flag = false;
        for (ManagementEntity entity : updateEntities) {
            ManagementEntity e = entityListMap.get(entity.getSourceSealId());
            if (Objects.equals(entity.getSourceCompanyId(), e.getSourceCompanyId()) && e.getSourceCompanyName().equals(entity.getSourceCompanyName()) && e.getSourceStatus().equals(entity.getSourceStatus()) && e.getSealSubTypeName().equals(entity.getSealSubTypeName()) && Objects.equals(e.getEnableStatus(), entity.getEnableStatus()) && e.getSourceSealName().equals(entity.getSourceSealName()) && Objects.equals(e.getSourceSealId(), entity.getSourceSealId()) && e.getSourceStatusDescription().equals(entity.getSourceStatusDescription()) && e.getSealType().equals(entity.getSealType())) continue;
            this.logger.info("\u5f53\u524d\u5370\u7ae0\u9700\u8981\u66f4\u65b0--{}", (Object)JSONObject.toJSONString((Object)((Object)entity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            flag = true;
            entity.setSourceCompanyId(e.getSourceCompanyId());
            entity.setSourceCompanyName(e.getSourceCompanyName());
            entity.setSourceStatus(e.getSourceStatus());
            entity.setSealSubTypeName(e.getSealSubTypeName());
            entity.setEnableStatus(e.getEnableStatus());
            entity.setSourceSealName(e.getSourceSealName());
            entity.setSourceSealId(e.getSourceSealId());
            entity.setSourceStatusDescription(e.getSourceStatusDescription());
            entity.setSealType(e.getSealType());
            entity.setContractSealFlag("\u5408\u540c\u4e13\u7528\u7ae0".equals(e.getSealSubTypeName()) ? 1 : 0);
            entity.setEnableStatus("NORMAL".equals(e.getSourceStatus()) ? 1 : 0);
        }
        this.logger.info("entityList>>>>>>>>>{}", (Object)updateEntities.size());
        if (Boolean.TRUE.equals(flag)) {
            this.service.saveOrUpdateBatch(updateEntities);
        }
    }

    @Override
    public void syncUpdateImgUrl(List<Long> sealIds, String authority) {
        if (!sealIds.isEmpty()) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.in((Object)"source_seal_id", sealIds);
            List entityList = this.service.list((Wrapper)wrapper);
            for (ManagementEntity e : entityList) {
                if (!StringUtils.isBlank((CharSequence)e.getImgUrl())) continue;
                this.sealManageService.replaceImgUrl(e.getSourceSealId(), authority, e);
            }
        }
    }

    @Override
    public ManagementEntity getBeSourceSealId(Long sourceSealId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_seal_id", (Object)sourceSealId);
        return (ManagementEntity)((Object)super.getOne((Wrapper)query));
    }
}

