package com.ejianc.business.signaturemanage.service.impl;

import com.ejianc.business.signaturemanage.bean.SignatureSettingSubEntity;
import com.ejianc.business.signaturemanage.mapper.SignatureSettingSubMapper;
import com.ejianc.business.signaturemanage.service.ISignatureSettingSubService;
import com.ejianc.business.signaturemanage.vo.SignatureSettingSubVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author:刘家乐
 * @version: 1
 * @document:
 */
@Service("signatureSettingSubService")
public class SignatureSettingSubServiceImpl
        extends BaseServiceImpl<SignatureSettingSubMapper, SignatureSettingSubEntity>
        implements ISignatureSettingSubService {

    @Autowired
    private SignatureSettingSubMapper mapper;
    @Override
    public void deleteUserByIdList(List<Long> idList) {
        mapper.deleteUserByIdList(idList);
    }

    @Override
    public String getDefaultSealName(Long pid){
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid",new Parameter(QueryParam.EQ,pid));
        List<SignatureSettingSubEntity> signatureSettingSubEntities = this.queryList(queryParam, false);
        StringBuilder stringBuilder = new StringBuilder();
        if (signatureSettingSubEntities.isEmpty()){
            stringBuilder.append("空");
        }else {
            for (SignatureSettingSubEntity subEntity:signatureSettingSubEntities){
                stringBuilder.append(subEntity.getSourceSealName());
                stringBuilder.append(",");
            }
        }
        return stringBuilder.toString();

    }

    @Override
    public List<SignatureSettingSubVO> getByUnitIds(List<Long> unitIds, String sourceStatus) {
        return mapper.getByUnitIds(unitIds, sourceStatus);
    }
}
