package com.ejianc.business.signaturemanage.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;


@Configuration
@EnableAsync
public class TaskPoolConfig {

	@Bean(name = "downloadFileTask")
	public Executor taskExecutor() {
		ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
		//核心线程池大小
		executor.setCorePoolSize(2);
		//最大线程数
		executor.setMaxPoolSize(8);
		//队列容量
		executor.setQueueCapacity(16);
		//活跃时间
		executor.setKeepAliveSeconds(60);
		//线程名字前缀
		executor.setThreadNamePrefix("taskExecutor-");
		executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
		return executor;
	}

	@Bean(name = "commonTask")
	public Executor commonTaskExecutor() {
		ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
		//核心线程池大小
		executor.setCorePoolSize(2);
		//最大线程数
		executor.setMaxPoolSize(8);
		//队列容量
		executor.setQueueCapacity(16);
		//活跃时间
		executor.setKeepAliveSeconds(60);
		//线程名字前缀
		executor.setThreadNamePrefix("commonTaskExecutor-");
		executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
		return executor;
	}

	@Bean(name = "attributesTask")
	public Executor attributesTaskExecutor() {
		ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
		// 核心线程池大小
		executor.setCorePoolSize(2);
		// 最大线程数
		executor.setMaxPoolSize(8);
		// 队列容量
		executor.setQueueCapacity(16);
		// 活跃时间
		executor.setKeepAliveSeconds(60);
		// 线程名字前缀
		executor.setThreadNamePrefix("attributesTaskExecutor-");
		// 等待计划任务
		executor.setWaitForTasksToCompleteOnShutdown(true);
		// 关闭的最大时间
		executor.setAwaitTerminationSeconds(60);
		// 配置任务装饰器
		executor.setTaskDecorator(new ThreadContextDecorator());
		// 中止策略
		executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
		// 初始化线程设置
		executor.initialize();
		return executor;
	}
}
