/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.signaturemanage.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.signaturemanage.bean.SignMgrEntity;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.enums.DelFlagEnum;
import com.ejianc.business.signaturemanage.enums.SignMgrSignatoryEnum;
import com.ejianc.business.signaturemanage.mapper.GlobalCallBackMapper;
import com.ejianc.business.signaturemanage.service.IAsyncInformService;
import com.ejianc.business.signaturemanage.service.ISignMgrLogService;
import com.ejianc.business.signaturemanage.service.ISignMgrPreviewService;
import com.ejianc.business.signaturemanage.service.ISignMgrService;
import com.ejianc.business.signaturemanage.service.ISignMgrSignatoryService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="globalCallBackService")
public class GlobalCallBackService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ISignMgrService signMgrService;
    private final ISignMgrSignatoryService signMgrSignatoryService;
    private final ISignMgrLogService signMgrLogService;
    private final ISignMgrPreviewService signMgrPreviewService;
    private final GlobalCallBackMapper globalCallBackMapper;
    private final IBillTypeApi billTypeApi;
    private final IUserApi userApi;
    private final IPushMessageApi pushMessageApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    private final IAsyncInformService asyncInformService;

    public GlobalCallBackService(ISignMgrService signMgrService, ISignMgrSignatoryService signMgrSignatoryService, ISignMgrLogService signMgrLogService, ISignMgrPreviewService signMgrPreviewService, GlobalCallBackMapper globalCallBackMapper, IBillTypeApi billTypeApi, IUserApi userApi, IPushMessageApi pushMessageApi, IAsyncInformService asyncInformService) {
        this.signMgrService = signMgrService;
        this.signMgrSignatoryService = signMgrSignatoryService;
        this.signMgrLogService = signMgrLogService;
        this.signMgrPreviewService = signMgrPreviewService;
        this.globalCallBackMapper = globalCallBackMapper;
        this.billTypeApi = billTypeApi;
        this.userApi = userApi;
        this.pushMessageApi = pushMessageApi;
        this.asyncInformService = asyncInformService;
    }

    public Map<String, String> contractTerminate(Map<String, String> map) {
        this.logger.info("\u5168\u5c40\u56de\u8c03-\u6587\u4ef6\u4f5c\u5e9f\uff0c\u5165\u53c2\uff1amap--{}", (Object)JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        this.sendStatus(map.get("authority"), Long.valueOf(map.get("billId")), map.get("billType"), map.get("billRefCode"), SignMgrSignatoryEnum.TERMINATE.getValue());
        this.logger.info("\u5168\u5c40\u56de\u8c03-\u6587\u4ef6\u4f5c\u5e9f\uff0c\u901a\u77e5\u4e1a\u52a1\u7cfb\u7edf\u6210\u529f\uff01");
        return map;
    }

    public Map<String, String> contractExpired(Map<String, String> map) {
        this.logger.info("\u5168\u5c40\u56de\u8c03-\u6587\u4ef6\u8fc7\u671f\uff0c\u5165\u53c2\uff1amap--{}", (Object)JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        this.tombstoneSignData(map.get("contractId"), SignMgrSignatoryEnum.COMPLETED.getValue(), SignMgrSignatoryEnum.EXPIRED.getValue());
        List<SignMgrSignatoryEntity> signatoryEntityList = this.selectSignMgrSignatory(Long.valueOf(map.get("pid")));
        this.sendStatus(map.get("authority"), Long.valueOf(map.get("billId")), map.get("billType"), map.get("billRefCode"), SignMgrSignatoryEnum.EXPIRED.getValue());
        this.logger.info("\u5168\u5c40\u56de\u8c03-\u6587\u4ef6\u8fc7\u671f\uff0c\u901a\u77e5\u4e1a\u52a1\u7cfb\u7edf\u6210\u529f\uff01");
        this.sendMessage(signatoryEntityList, map.get("billType"), map.get("billCode"), map.get("contractName"), SignMgrSignatoryEnum.EXPIRED.getDescription());
        this.logger.info("\u5168\u5c40\u56de\u8c03-\u6587\u4ef6\u8fc7\u671f\uff0c\u901a\u77e5\u76f8\u5173\u7b7e\u7f72\u4eba\u6210\u529f\uff01");
        return map;
    }

    public Map<String, String> contractComplete(Map<String, String> map) {
        this.logger.info("\u5168\u5c40\u56de\u8c03-\u6587\u4ef6\u5168\u90e8\u7b7e\u7f72\u5b8c\u6210\uff0c\u5165\u53c2\uff1amap--{}", (Object)JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        Assert.notNull((Object)map.get("contractId"), (String)"\u5168\u5c40\u56de\u8c03-\u6587\u4ef6\u5168\u90e8\u7b7e\u7f72\u5b8c\u6210\uff0c\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0contractId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)map.get("authority"), (String)"\u5168\u5c40\u56de\u8c03-\u6587\u4ef6\u5168\u90e8\u7b7e\u7f72\u5b8c\u6210\uff0c\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0authority\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SignMgrEntity::getDelFlag, (Object)DelFlagEnum.NORMAL.getDelFlag());
        queryWrapper.eq(SignMgrEntity::getSourceBillId, (Object)map.get("contractId"));
        SignMgrEntity entity = (SignMgrEntity)((Object)this.signMgrService.getOne((Wrapper)queryWrapper));
        Assert.notNull((Object)((Object)entity), (String)"\u5168\u5c40\u56de\u8c03-\u6587\u4ef6\u5168\u90e8\u7b7e\u7f72\u5b8c\u6210\uff0c\u7b2c\u4e09\u65b9\u7535\u5b50\u7b7e\u7ae0\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(SignMgrSignatoryEntity::getDelFlag, (Object)DelFlagEnum.NORMAL.getDelFlag());
        updateWrapper.eq(SignMgrSignatoryEntity::getPid, (Object)entity.getId());
        updateWrapper.set(SignMgrSignatoryEntity::getJobStatus, (Object)SignMgrSignatoryEnum.COMPLETED.getValue());
        updateWrapper.set(SignMgrSignatoryEntity::getSignResult, (Object)SignMgrSignatoryEnum.SIGNED.getValue());
        boolean updateFlag = this.signMgrSignatoryService.update((Wrapper)updateWrapper);
        Assert.isTrue((boolean)updateFlag, (String)"\u5168\u5c40\u56de\u8c03-\u6587\u4ef6\u5168\u90e8\u7b7e\u7f72\u5b8c\u6210\uff0c\u66f4\u65b0\u7b7e\u7f72\u52a8\u4f5c\u7b7e\u7ae0\u72b6\u6001\u5931\u8d25\uff01");
        this.asyncInformService.informBusinessSystem(entity.getBillType(), entity.getBillId(), entity.getBillRefCode(), SignMgrSignatoryEnum.SIGNED.getValue(), map.get("authority"));
        return map;
    }

    public Map<String, String> contractRecall(Map<String, String> map) {
        this.logger.info("\u53d1\u8d77\u65b9\u56de\u8c03-\u6587\u4ef6\u64a4\u56de\uff0c\u5165\u53c2\uff1amap--{}", (Object)JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        this.tombstoneSignData(map.get("contractId"), SignMgrSignatoryEnum.COMPLETED.getValue(), SignMgrSignatoryEnum.WITHDRAWN.getValue());
        List<SignMgrSignatoryEntity> signatoryEntityList = this.selectSignMgrSignatory(Long.valueOf(map.get("pid")));
        this.sendStatus(map.get("authority"), Long.valueOf(map.get("billId")), map.get("billType"), map.get("billRefCode"), SignMgrSignatoryEnum.WITHDRAWN.getValue());
        this.logger.info("\u5168\u5c40\u56de\u8c03-\u6587\u4ef6\u8fc7\u671f\uff0c\u901a\u77e5\u4e1a\u52a1\u7cfb\u7edf\u6210\u529f\uff01");
        this.sendMessage(signatoryEntityList, map.get("billType"), map.get("billCode"), map.get("contractName"), SignMgrSignatoryEnum.WITHDRAWN.getDescription());
        this.logger.info("\u5168\u5c40\u56de\u8c03-\u6587\u4ef6\u8fc7\u671f\uff0c\u901a\u77e5\u76f8\u5173\u7b7e\u7f72\u4eba\u6210\u529f\uff01");
        return map;
    }

    public Map<String, String> contractRejected(Map<String, String> map) {
        this.logger.info("\u63a5\u6536\u65b9\u56de\u8c03-\u6587\u4ef6\u9000\u56de\uff0c\u5165\u53c2\uff1amap--{}", (Object)JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        this.tombstoneSignData(map.get("contractId"), SignMgrSignatoryEnum.COMPLETED.getValue(), SignMgrSignatoryEnum.RETURNED.getValue());
        List<SignMgrSignatoryEntity> signatoryEntityList = this.selectSignMgrSignatory(Long.valueOf(map.get("pid")));
        this.sendStatus(map.get("authority"), Long.valueOf(map.get("billId")), map.get("billType"), map.get("billRefCode"), SignMgrSignatoryEnum.RETURNED.getValue());
        this.logger.info("\u5168\u5c40\u56de\u8c03-\u6587\u4ef6\u8fc7\u671f\uff0c\u901a\u77e5\u4e1a\u52a1\u7cfb\u7edf\u6210\u529f\uff01");
        this.sendMessage(signatoryEntityList, map.get("billType"), map.get("billCode"), map.get("contractName"), SignMgrSignatoryEnum.RETURNED.getDescription());
        this.logger.info("\u5168\u5c40\u56de\u8c03-\u6587\u4ef6\u8fc7\u671f\uff0c\u901a\u77e5\u76f8\u5173\u7b7e\u7f72\u4eba\u6210\u529f\uff01");
        return map;
    }

    public Map<String, String> contractAllReceiverSignatoryComplete(Map<String, String> map) {
        this.logger.info("\u63a5\u6536\u65b9\u56de\u8c03-\u6240\u6709\u63a5\u6536\u65b9\u7b7e\u7f72\u5b8c\u6210\uff0c\u5165\u53c2\uff1amap--{}", (Object)JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return map;
    }

    public void tombstoneSignData(String sourceBillId, Integer jobStatus, Integer status) {
        this.logger.info("\u903b\u8f91\u5220\u9664\u7b7e\u7ae0\u6570\u636e\uff0c\u5165\u53c2\uff1asourceBillId--{}\uff0cjobStatus--{}\uff0cstatus--{}", new Object[]{sourceBillId, jobStatus, status});
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"del_flag", (Object)0);
        queryWrapper.eq((Object)"source_bill_id", (Object)sourceBillId);
        SignMgrEntity signMgrEntity = (SignMgrEntity)((Object)this.signMgrService.getOne((Wrapper)queryWrapper));
        signMgrEntity.setDelFlag(1);
        this.signMgrService.saveOrUpdate((Object)signMgrEntity, false);
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"del_flag", (Object)0);
        queryWrapper1.eq((Object)"pid", (Object)signMgrEntity.getId());
        List signatoryList = this.signMgrSignatoryService.list((Wrapper)queryWrapper1);
        signatoryList.parallelStream().peek(e -> {
            e.setDelFlag(1);
            e.setJobStatus(jobStatus);
            e.setSignResult(status);
        }).collect(Collectors.toList());
        this.signMgrSignatoryService.saveOrUpdateBatch(signatoryList);
        QueryWrapper queryWrapper2 = new QueryWrapper();
        queryWrapper2.eq((Object)"del_flag", (Object)0);
        queryWrapper2.eq((Object)"bill_id", (Object)signMgrEntity.getBillId());
        List logList = this.signMgrLogService.list((Wrapper)queryWrapper2);
        if (!logList.isEmpty()) {
            logList.parallelStream().peek(e -> e.setDelFlag(1)).collect(Collectors.toList());
            this.signMgrLogService.saveOrUpdateBatch(logList);
        }
        QueryWrapper queryWrapper3 = new QueryWrapper();
        queryWrapper3.eq((Object)"del_flag", (Object)0);
        queryWrapper3.eq((Object)"bill_id", (Object)signMgrEntity.getBillId());
        List previewList = this.signMgrPreviewService.list((Wrapper)queryWrapper3);
        if (!previewList.isEmpty()) {
            previewList.parallelStream().peek(e -> e.setDelFlag(1)).collect(Collectors.toList());
            this.signMgrPreviewService.saveOrUpdateBatch(previewList);
        }
    }

    public List<SignMgrSignatoryEntity> selectSignMgrSignatory(Long pid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"pid", (Object)pid);
        return this.signMgrSignatoryService.list((Wrapper)queryWrapper);
    }

    public void sendStatus(String authority, Long billId, String billType, String billRefCode, Integer status) {
        CommonResponse mdRefResp = this.billTypeApi.queryMetadataByBillType(billType);
        if (!mdRefResp.isSuccess()) {
            this.logger.error("\u7b7e\u7ae0\u72b6\u6001\u66f4\u65b0\u5931\u8d25,\u6839\u636ebillType-{}\u67e5\u8be2\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25,\u539f\u56e0\uff1a{}\uff01", (Object)billType, (Object)mdRefResp.getMsg());
        }
        MdReferVO mdRef = (MdReferVO)mdRefResp.getData();
        String entityName = mdRef.getEntityName().replace("Entity", "") + "Signature";
        String apiUrl = entityName.substring(0, 1).toLowerCase() + entityName.substring(1);
        String sendUrl = this.BASE_HOST + mdRef.getProjectName() + "/" + apiUrl + "/changeStatus";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("billId", billId);
        param.put("refCode", billRefCode);
        param.put("status", status);
        try {
            JSONObject resultJson;
            String code;
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("authority", authority);
            headerMap.put("content-type", "application/json;charset=UTF-8");
            String httpRespStr = HttpTookit.postByJson((String)Objects.requireNonNull(sendUrl), (String)JSONObject.toJSONString(param), headerMap, (Integer)10000, (Integer)10000);
            this.logger.info("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edfurl-{},param-{},\u7b7e\u7ae0\u72b6\u6001\u7ed3\u679c\uff1a{}", new Object[]{sendUrl, JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}), httpRespStr});
            if (!StringUtils.isEmpty((CharSequence)httpRespStr) && Integer.parseInt(code = (resultJson = JSONObject.parseObject((String)httpRespStr)).getString("code")) != 0) {
                this.logger.error("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edf\u6210\u529f\uff0c\u8fd4\u56de\u7ed3\u679c\u5931\u8d25!");
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edfurl-{},param-{},\u7b7e\u7ae0\u72b6\u6001\u5f02\u5e38\uff1a", new Object[]{sendUrl, JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}), e});
        }
    }

    public void sendMessage(List<SignMgrSignatoryEntity> s, String billType, String billCode, String contractName, String status) {
        PushMsgParameter parameter = new PushMsgParameter();
        String msgType = "notice";
        String subject = "\u7535\u5b50\u7b7e\u7ae0-" + status;
        String content = "\u4f60\u7684\u6587\u4ef6\u3010" + billType + "_" + billCode + "_" + contractName + "\u3011 " + status + "!";
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("sys");
        String[] channel = lst.toArray(new String[lst.size()]);
        Set<String> userIds = s.parallelStream().filter(e -> SignMgrSignatoryEnum.INTERNAL_UNIT.getValue().equals(e.getSignatureType())).map(e -> String.valueOf(e.getSignatureId())).collect(Collectors.toSet());
        String[] receivers = userIds.toArray(new String[userIds.size()]);
        CommonResponse user = this.userApi.findUserByUserId(Long.valueOf((String)userIds.iterator().next()));
        if (!user.isSuccess()) {
            this.logger.error("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u4fe1\u606f\uff0c\u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString((Object)user, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        }
        String tenantId = String.valueOf(((UserVO)user.getData()).getTenantId());
        parameter.setChannel(channel);
        parameter.setReceivers(receivers);
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(tenantId);
        CommonResponse response = this.pushMessageApi.pushMessage(parameter);
        if (!response.isSuccess()) {
            this.logger.error("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString((Object)response, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        }
    }
}

