package com.ejianc.framework.skeleton.commonQuery.controller;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.commonQuery.service.ICommonQueryService;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import com.ejianc.framework.skeleton.util.CheckValidKey;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2020/7/29 17:21
 */
@RestController
@RequestMapping(value = "/commonQuery/")
public class CommonQueryController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICommenQueryFieldsService commenQueryFieldsService;
    @Autowired
    private ICommonQueryService commonQueryService;

    @Value("${extend.field.mode:false}")
    private Boolean extFieldsMode;

    @PostMapping(value = "queryBillInfoByProperty")
    @ResponseBody
    public CommonResponse<JSONArray> queryBillInfoByProperty(@RequestBody Map<String, String> queryMap) {
        if(StringUtils.isBlank(queryMap.get("databaseName"))) {
            logger.error("业务数据库名不能为空！");
            return CommonResponse.error("业务数据库名称不能为空");
        }
        if(!CheckValidKey.isValidKey(queryMap.get("databaseName"))){
            logger.error("业务数据库名校验关键字失败！");
            return CommonResponse.error("业务数据库名校验关键字失败");
        }
        if(StringUtils.isBlank(queryMap.get("tableName"))) {
            logger.error("业务表名不能为空！");
            return CommonResponse.error("业务表名称不能为空");
        }
        if(!CheckValidKey.isValidKey(queryMap.get("tableName"))){
            logger.error("业务表名校验关键字失败！");
            return CommonResponse.error("业务表名校验关键字失败");
        }
        if(StringUtils.isBlank(queryMap.get("columns"))) {
            logger.error("查询字段不能为空！");
            return CommonResponse.error("查询字段不能为空");
        }
        if(!CheckValidKey.isValidKey(queryMap.get("columns"))){
            logger.error("查询字段校验关键字失败！");
            return CommonResponse.error("查询字段校验关键字失败");
        }
        if(StringUtils.isBlank(queryMap.get("parameter"))) {
            logger.error("查询条件不能为空！");
            return CommonResponse.error("查询条件不能为空");
        }
        if(!CheckValidKey.isValidKey(queryMap.get("parameter"))){
            logger.error("查询条件校验关键字失败！");
            return CommonResponse.error("查询条件校验关键字失败");
        }
        JSONArray result = commenQueryFieldsService.queryBillInfoByProperty(queryMap.get("databaseName"), queryMap.get("tableName"), queryMap.get("columns"), queryMap.get("parameter"));

        return CommonResponse.success("查询成功！", result);
    }

    /** 查询当前工程是否开启扩展字段 */
    @PostMapping(value = "extFieldsModeOpen")
    @ResponseBody
    public CommonResponse<Boolean> extFieldsModeOpen(@RequestBody Map<String, String> queryMap) {
        return CommonResponse.success("查询成功！", extFieldsMode);
    }

    @PostMapping(value = "queryNumberBySql")
    @ResponseBody
    public CommonResponse<Integer> queryNumberBySql(@RequestBody Map<String, String> queryMap) {
        return commonQueryService.queryNumberBySql(queryMap);
    }

}
