package com.ejianc.framework.skeleton.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlFilter implements Filter {
    public static Logger logger = LoggerFactory.getLogger(AccessControlFilter.class);

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res,
                         FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse) res;
        HttpServletRequest request = (HttpServletRequest) req;


        String requestUrl = request.getRequestURI();
        if (requestUrl.contains(".css") || requestUrl.contains(".js")
                || requestUrl.contains(".png") || requestUrl.contains(".jpg")
                || requestUrl.contains(".jpeg") || requestUrl.contains(".woff")
                || requestUrl.contains(".html") || requestUrl.contains(".htm")
                || requestUrl.contains(".gif") || requestUrl.contains(".svg")
                || requestUrl.contains(".ttf") || requestUrl.contains(".eot")
                || requestUrl.contains(".ico")) {
            response.setHeader("Access-Control-Allow-Credentials", "false");
            response.setStatus(200);
            chain.doFilter(req, res);
        } else {
            String origin = request.getHeader("origin");
            if (origin == null || "".equals(origin)) {
                origin = "*";
            }
            response.setHeader("Access-Control-Allow-Origin", "*");   // 没部署nginx,线上环境不好使，暂时注释掉
            response.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS");
            response.setHeader("Access-Control-Max-Age", "3600");
            //ajax通过header传递到后端
            response.setHeader("Access-Control-Allow-Headers", "x-requested-with, authority, content-type, ejc-token, Content-Disposition");
            response.setHeader("Access-Control-Allow-Credentials", "true");
            response.setHeader("Access-Control-Expose-Headers", "ejc-content-type");

            String method = request.getMethod();
            if (StringUtils.isNotBlank(method) && method.equalsIgnoreCase("OPTIONS")) {
                response.setStatus(200);
            } else {
                chain.doFilter(req, res);
            }
        }

    }

    @Override
    public void destroy() {
    }

}
