package com.ejianc.framework.skeleton.refer.util;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.ClientProtocolException;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.refer.constants.MetaDataUrlconstants;

/**
 * 根据redis和http rest 托底获取参照实体信息
 * 
 * @author guominga 2020年02月13日
 *
 */
public class ReferObjectUtil {

	private final static org.slf4j.Logger Log = LoggerFactory.getLogger(ReferObjectUtil.class);
	private static final String REFER_CACHE_KEY = "refer_cache_key:";
	private static final String REFER_PROJECT_CACHE_KEY = "refer_project_cache_key:";

	/**
	 * 
	 * @param value
	 *            单个档案直接传:id
	 * @param referCode
	 * @return
	 * @throws IOException
	 * @throws GeneralSecurityException
	 * @throws ClientProtocolException
	 */
	@SuppressWarnings("unchecked")
	public static JSONArray getReferEntityValue(String value, String referCode) throws Exception {
		MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
		JSONArray jsonArray = null;
		if(value.endsWith(",")) {
			value = value.substring(0, value.length()-1);
		}
		// 走redis
		String cacheKey = REFER_CACHE_KEY + referCode + ":" + value;
		if("support-defdoc".equals(referCode)){
			//自定义档案需要添加租户作为唯一性key
			cacheKey = REFER_CACHE_KEY + "-" + InvocationInfoProxy.getTenantid() + referCode + ":" + value;
		}
		RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("redisTemplate", RedisTemplate.class);
		
		Object cacheValue = redisTemplate.opsForValue().get(cacheKey);
		if (cacheValue != null) {
// 			Log.info("{}有缓存",cacheKey);
// 			Log.info("缓存具体值{}",cacheValue);
			if(!"kongzhi".equals(cacheValue.toString())) {
				jsonArray = JSON.parseArray(cacheValue.toString());
			}
		} else if(referCode.contains("CFS")){
			Log.info("查询CFS参照数据：{}-{}",referCode,value);
			jsonArray = getCfsReferData(value, referCode,urlconstants);
			if(jsonArray != null) {
				redisTemplate.opsForValue().set(cacheKey, jsonArray.toJSONString(), 10, TimeUnit.MINUTES);
			}
		} else {
			try {
				String referData = getReferRestUrl(referCode);
				JSONObject json = JSON.parseObject(referData);
				String referUrl = json.get("projectName").toString();
				Map<String, Object> reflist = (Map<String, Object>) json.get("refMapList");
				if(reflist == null){
					throw new BusinessException("参照referCode："+referCode+"所在参照元数据没有定义参照映射字段，请在元数据中心设置");
				}
				reflist.put("valueId", value);
				reflist.put("databaseName", json.get("databaseName"));
				String tableNewName = json.getString("tableName").replace("${tenantId}", InvocationInfoProxy.getTenantid()+"");
				reflist.put("tableName", tableNewName);
				String url = urlconstants.getBaseHost() + referUrl + "/commonrefer/getrefervalue";
				// Log.info("请求具体数据url:{}",url);
				// Log.info("请求具体数据参数:{}",reflist);
				String jsonbackstr = ReferHttpClientUtils.getAndHeader(url, reflist);
				// Log.info("数据库取的具体值{}",jsonbackstr);
				jsonArray = JSON.parseArray(jsonbackstr);
				if(jsonArray.size() > 0) {
					redisTemplate.opsForValue().set(cacheKey, jsonbackstr, 10, TimeUnit.MINUTES);
				}else{
					//第二次调用
					jsonbackstr = ReferHttpClientUtils.getAndHeader(url, reflist);
					jsonArray = JSON.parseArray(jsonbackstr);
					if(jsonArray.size() > 0) {
						redisTemplate.opsForValue().set(cacheKey, jsonbackstr, 10, TimeUnit.MINUTES);
					}else{
						redisTemplate.opsForValue().set(cacheKey, "kongzhi", 1, TimeUnit.MINUTES);
					}
				}
			}catch(Exception e) {
				Log.info("-----有错误------{}",e);
				redisTemplate.opsForValue().set(cacheKey, "kongzhi", 1, TimeUnit.MINUTES);
			}
		}
		return jsonArray;
	}
	
	/**
	 * 通过元数据服务获取实体信息
	 * 
	 * @param referCode
	 * @return
	 */
	private static String getReferRestUrl(String referCode) {
		/** 从缓存读取参照所在元数据信息，减少请求交互，提升性能 */
		RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("redisTemplate", RedisTemplate.class);
		String cacheKey = REFER_PROJECT_CACHE_KEY + referCode ;
		Object cacheValue = redisTemplate.opsForValue().get(cacheKey);
		if (cacheValue != null) {
			return cacheValue.toString();
		}
		String data = null;
		MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
		String backData = null;
		try {
//			Log.info("请求元数据url：{}",urlconstants.getMetaDataBaseUrl() + referCode);
			backData = ReferHttpClientUtils.getAndHeader(urlconstants.getMetaDataBaseUrl() + referCode, null);
		} catch (ClientProtocolException e) {
			ExceptionUtil.wrappException(e);
		} catch (GeneralSecurityException e) {
			ExceptionUtil.wrappException(e);
		} catch (IOException e) {
			ExceptionUtil.wrappException(e);
		}

		JSONObject jsonobject = JSON.parseObject(backData);
		if(jsonobject.getString("code").equals("0")){
			if(jsonobject.getString("data")!=null){
				data = JSON.parseObject(jsonobject.getString("data")).toJSONString();
				/** 将参照所在元数据信息写入缓存，减少请求交互，提升性能 */
				redisTemplate.opsForValue().set(cacheKey, jsonobject.getString("data"),24,TimeUnit.HOURS);
			}
		}else{
			ExceptionUtil.wrappBusinessException("参照编码" + referCode + "的实体没有发布元数据!");
		}
		return data;

	}


    /**
     * 获取CFS参照数据
     * @param value 数据ID
     * @param referCode 参照码
     * @param urlconstants 元数据URL常量，用于构建请求URL
     * @return 返回查询到的参照数据JSONArray，如果查询失败或无数据，则返回null
     */
    private static JSONArray getCfsReferData(String value, String referCode, MetaDataUrlconstants urlconstants){
        // 构建请求URL
        String url = urlconstants.getBaseHost()  + "ejc-cfs-web/refer/queryCfsReferData";
        Map<String, Object> params = new HashMap<>(); // 准备请求参数
        params.put("id",value);
        params.put("pageCode",referCode);

        JSONArray result = null;
        try {
            // 发起GET请求并获取响应字符串
            String jsonbackstr = ReferHttpClientUtils.getAndHeader(url, params);
			Log.info("CFS参照查询结果：{}",jsonbackstr);
            // 如果响应字符串不为空，则解析为JSONArray并返回
            if(StringUtils.isNotBlank(jsonbackstr)){
				CommonResponse response = JSONObject.parseObject(jsonbackstr, CommonResponse.class);
                result = (JSONArray)response.getData();
            }
        } catch (Exception e) {
            // 记录查询异常日志
            Log.error("查询CFS参照数据出错：{}",e.getMessage());
        }
        return result;
    }

}
