package com.ejianc.framework.skeleton.template;

import com.ejianc.framework.skeleton.util.ComparatorTree;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.data.annotation.Transient;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BaseTreeVO<T extends BaseTreeVO> extends BaseVO {
    private static final long serialVersionUID = -1409392498533687139L;

    private String innerCode;

    @Transient
    private  List<T> children;

    public String getInnerCode() {
        return innerCode;
    }

    /*EJCTree使用字段*/
    private String title;
    private String key;

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }

    public List<T> getChildren() {
        return this.children;
    }

    public void setChildren(List<T> children) {
        this.children = children;
    }

    public void sortChildren() {
        if (CollectionUtils.isNotEmpty(this.children)) {
            Collections.sort(this.children, new ComparatorTree());

            for(int i = 0; i < this.children.size(); ++i) {
                (this.children.get(i)).sortChildren();
            }
        }
    }

    public void addChild(T t) {
        if(null == this.children) {
            this.children = new ArrayList<>();
        }
        this.children.add(t);
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}
