package com.ejianc.business.steelstructure.income.consts;


import java.util.HashMap;
import java.util.Map;

/**
 * @author songlx
 * @description: 招标形式
 * @return:
 * @date: 2021/11/17
 */
public enum BiddingFormEnum {

    GONG_KAI(1, "公开招标"),
    YAO_QING(2, "邀请招标"),
    ZHI_JIE(3, "直接发包"),
    QI_TA(4, "其他");


    private Integer code;
    private String name;

    private static Map<Integer, String> enumMap;

    static {
        enumMap = new HashMap<>();
        enumMap.put(GONG_KAI.getCode(), GONG_KAI.getName());
        enumMap.put(YAO_QING.getCode(), YAO_QING.getName());
        enumMap.put(ZHI_JIE.getCode(), ZHI_JIE.getName());
        enumMap.put(QI_TA.getCode(), QI_TA.getName());
    }

    public static String getNameByCode(Integer code) {
        return enumMap.get(code);
    }


    BiddingFormEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }


}
