package com.ejianc.business.steelstructure.income.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 项目预算书
 * 
 * @author generator
 * 
 */
public class BudgetVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer budgetModel; // 模式,0-清单模式，1-费用项模式，2-郑州一建预算清单
    private String billCode; // 单据编号
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long contractId; // 合同
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private String budgetName; // 预算书名称
    private Integer budgetSource; // 预算来源:0-合同，1-变更，2-签证，3-索赔，4-审定预算书，5-其它
    private String budgetSourceName; // 预算来源:0-合同，1-变更，2-签证，3-索赔，4-审定预算书，5-其它
    private Long budgetCategoryId; // 预算分类
    private String budgetCategoryName; // 预算分类名称
    private Integer incomeFlag; // 是否收入：0-否，1-是
    private BigDecimal taxRate; // 税率
    private BigDecimal budgetMny; // 金额(无税)
    private BigDecimal budgetTaxMny; // 金额(含税)
    private Long accountingId; // 核算对象
    private String accountingName; // 核算对象名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称
    private BigDecimal subTotalMny; // 分部分项金额(无税)
    private BigDecimal subTotalTaxMny; // 分部分项金额(含税)
    private BigDecimal measureTotalMny; // 措施项金额(无税)
    private BigDecimal measureTotalTaxMny; // 措施项金额(含税)
    private BigDecimal otherTotalMny; // 其它项金额(无税)
    private BigDecimal otherTotalTaxMny; // 其它项金额(含税)
    private BigDecimal feeTotalMny; // 费税金额(无税)
    private BigDecimal feeTotalTaxMny; // 费税金额(含税)
    private Integer billState; // 单据状态
    private String useType; // 引用类型(QS-洽商，QZ-签证，SP-索赔)
    private Long useId; // 引用主键
    private BigDecimal budgetTax; // 税额
    private BigDecimal subTotalTax; // 分部分项税额
    private BigDecimal measureTotalTax; // 措施项税额
    private BigDecimal otherTotalTax; // 其它项税额
    private BigDecimal feeTotalTax; // 费税税额

    private List<BudgetSubVO> subVos = new ArrayList<>(); // 分部分项清单
    private List<BudgetMeasureVO> measureVos = new ArrayList<>(); // 措施项清单
    private List<BudgetOtherVO> otherVos = new ArrayList<>(); // 其他项清单
    private List<BudgetFeeVO> feeVos = new ArrayList<>(); // 费税清单
    private List<BudgetCostVO> costVos = new ArrayList<>(); // 费用项清单

    private Integer detailLength;// 子表数量
    private BigDecimal budgetRate;// 预算占比
    private String fillingFlag; // 归档状态
    private String sealFlag; // 用印状态

    public String getFillingFlag() {
        return fillingFlag;
    }

    public void setFillingFlag(String fillingFlag) {
        this.fillingFlag = fillingFlag;
    }

    public String getSealFlag() {
        return sealFlag;
    }

    public void setSealFlag(String sealFlag) {
        this.sealFlag = sealFlag;
    }

    public BigDecimal getBudgetTax() {
        return budgetTax;
    }

    public void setBudgetTax(BigDecimal budgetTax) {
        this.budgetTax = budgetTax;
    }

    public BigDecimal getSubTotalTax() {
        return subTotalTax;
    }

    public void setSubTotalTax(BigDecimal subTotalTax) {
        this.subTotalTax = subTotalTax;
    }

    public BigDecimal getMeasureTotalTax() {
        return measureTotalTax;
    }

    public void setMeasureTotalTax(BigDecimal measureTotalTax) {
        this.measureTotalTax = measureTotalTax;
    }

    public BigDecimal getOtherTotalTax() {
        return otherTotalTax;
    }

    public void setOtherTotalTax(BigDecimal otherTotalTax) {
        this.otherTotalTax = otherTotalTax;
    }

    public BigDecimal getFeeTotalTax() {
        return feeTotalTax;
    }

    public void setFeeTotalTax(BigDecimal feeTotalTax) {
        this.feeTotalTax = feeTotalTax;
    }

    public String getBudgetSourceName() {
        return budgetSourceName;
    }

    public void setBudgetSourceName(String budgetSourceName) {
        this.budgetSourceName = budgetSourceName;
    }

    public BigDecimal getBudgetRate() {
        return budgetRate;
    }

    public void setBudgetRate(BigDecimal budgetRate) {
        this.budgetRate = budgetRate;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Integer getDetailLength() {
        return detailLength;
    }

    public void setDetailLength(Integer detailLength) {
        this.detailLength = detailLength;
    }

    /**
     * 模式,0-清单模式，1-费用项模式
     */
    public Integer getBudgetModel() {
        return budgetModel;
    }

    /**
     * 模式,0-清单模式，1-费用项模式
     */
    public void setBudgetModel(Integer budgetModel) {
        this.budgetModel = budgetModel;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 所属组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 所属组织
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 所属组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 所属组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 合同
     */
    @ReferSerialTransfer(referCode = "ref-contract-register")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编码
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编码
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 预算书名称
     */
    public String getBudgetName() {
        return budgetName;
    }

    /**
     * 预算书名称
     */
    public void setBudgetName(String budgetName) {
        this.budgetName = budgetName;
    }
    /**
     * 预算来源:0-合同，1-变更，2-签证，3-索赔，4-审定预算书，5-其它
     */
    public Integer getBudgetSource() {
        return budgetSource;
    }

    /**
     * 预算来源:0-合同，1-变更，2-签证，3-索赔，4-审定预算书，5-其它
     */
    public void setBudgetSource(Integer budgetSource) {
        this.budgetSource = budgetSource;
    }
    /**
     * 预算分类
     */
    @ReferSerialTransfer(referCode = "pro-income-budget-category")
    public Long getBudgetCategoryId() {
        return budgetCategoryId;
    }

    /**
     * 预算分类
     */
    @ReferDeserialTransfer
    public void setBudgetCategoryId(Long budgetCategoryId) {
        this.budgetCategoryId = budgetCategoryId;
    }
    /**
     * 预算分类名称
     */
    public String getBudgetCategoryName() {
        return budgetCategoryName;
    }

    /**
     * 预算分类名称
     */
    public void setBudgetCategoryName(String budgetCategoryName) {
        this.budgetCategoryName = budgetCategoryName;
    }
    /**
     * 是否收入：0-否，1-是
     */
    public Integer getIncomeFlag() {
        return incomeFlag;
    }

    /**
     * 是否收入：0-否，1-是
     */
    public void setIncomeFlag(Integer incomeFlag) {
        this.incomeFlag = incomeFlag;
    }
    /**
     * 税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 金额(无税)
     */
    public BigDecimal getBudgetMny() {
        return budgetMny;
    }

    /**
     * 金额(无税)
     */
    public void setBudgetMny(BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }
    /**
     * 金额(含税)
     */
    public BigDecimal getBudgetTaxMny() {
        return budgetTaxMny;
    }

    /**
     * 金额(含税)
     */
    public void setBudgetTaxMny(BigDecimal budgetTaxMny) {
        this.budgetTaxMny = budgetTaxMny;
    }
    /**
     * 核算对象
     */
    @ReferSerialTransfer(referCode="subject-project-wbs-ref")
    public Long getAccountingId() {
        return accountingId;
    }

    /**
     * 核算对象
     */
    @ReferDeserialTransfer
    public void setAccountingId(Long accountingId) {
        this.accountingId = accountingId;
    }
    /**
     * 核算对象名称
     */
    public String getAccountingName() {
        return accountingName;
    }

    /**
     * 核算对象名称
     */
    public void setAccountingName(String accountingName) {
        this.accountingName = accountingName;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 经办部门
     */
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    /**
     * 经办部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 经办部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public BigDecimal getSubTotalMny() {
        return subTotalMny;
    }

    public void setSubTotalMny(BigDecimal subTotalMny) {
        this.subTotalMny = subTotalMny;
    }

    public BigDecimal getSubTotalTaxMny() {
        return subTotalTaxMny;
    }

    public void setSubTotalTaxMny(BigDecimal subTotalTaxMny) {
        this.subTotalTaxMny = subTotalTaxMny;
    }

    public BigDecimal getMeasureTotalMny() {
        return measureTotalMny;
    }

    public void setMeasureTotalMny(BigDecimal measureTotalMny) {
        this.measureTotalMny = measureTotalMny;
    }

    public BigDecimal getMeasureTotalTaxMny() {
        return measureTotalTaxMny;
    }

    public void setMeasureTotalTaxMny(BigDecimal measureTotalTaxMny) {
        this.measureTotalTaxMny = measureTotalTaxMny;
    }

    public BigDecimal getOtherTotalMny() {
        return otherTotalMny;
    }

    public void setOtherTotalMny(BigDecimal otherTotalMny) {
        this.otherTotalMny = otherTotalMny;
    }

    public BigDecimal getOtherTotalTaxMny() {
        return otherTotalTaxMny;
    }

    public void setOtherTotalTaxMny(BigDecimal otherTotalTaxMny) {
        this.otherTotalTaxMny = otherTotalTaxMny;
    }

    public BigDecimal getFeeTotalMny() {
        return feeTotalMny;
    }

    public void setFeeTotalMny(BigDecimal feeTotalMny) {
        this.feeTotalMny = feeTotalMny;
    }

    public BigDecimal getFeeTotalTaxMny() {
        return feeTotalTaxMny;
    }

    public void setFeeTotalTaxMny(BigDecimal feeTotalTaxMny) {
        this.feeTotalTaxMny = feeTotalTaxMny;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 引用类型(QS-洽商，QZ-签证，SP-索赔)
     */
    public String getUseType() {
        return useType;
    }

    /**
     * 引用类型(QS-洽商，QZ-签证，SP-索赔)
     */
    public void setUseType(String useType) {
        this.useType = useType;
    }
    /**
     * 引用主键
     */
    public Long getUseId() {
        return useId;
    }

    /**
     * 引用主键
     */
    public void setUseId(Long useId) {
        this.useId = useId;
    }

    public List<BudgetSubVO> getSubVos() {
        return subVos;
    }

    public void setSubVos(List<BudgetSubVO> subVos) {
        this.subVos = subVos;
    }

    public List<BudgetMeasureVO> getMeasureVos() {
        return measureVos;
    }

    public void setMeasureVos(List<BudgetMeasureVO> measureVos) {
        this.measureVos = measureVos;
    }

    public List<BudgetOtherVO> getOtherVos() {
        return otherVos;
    }

    public void setOtherVos(List<BudgetOtherVO> otherVos) {
        this.otherVos = otherVos;
    }

    public List<BudgetFeeVO> getFeeVos() {
        return feeVos;
    }

    public void setFeeVos(List<BudgetFeeVO> feeVos) {
        this.feeVos = feeVos;
    }

    public List<BudgetCostVO> getCostVos() {
        return costVos;
    }

    public void setCostVos(List<BudgetCostVO> costVos) {
        this.costVos = costVos;
    }
}
