package com.ejianc.business.steelstructure.income.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.ArrayList;
import java.util.List;

/**
 * 产值报量子表
 * 
 * @author generator
 * 
 */
public class ProductionDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long productionId; // 产值进度主键
    private Long budgetId; // 预算书主键
    private String budgetCode; // 预算书编号
    private String budgetName; // 预算书名称
    private Integer budgetModel; // 预算模式 0-清单模式，1-费用项目模式
    private String budgetSource; // 预算来源:0-合同，1-变更，2-签证，3-索赔，4-审定预算书，5-其它
    private java.math.BigDecimal taxRate; // 税率
    private java.math.BigDecimal budgetMny; // 预算金额(无税)
    private java.math.BigDecimal budgetTaxMny; // 预算金额
    private java.math.BigDecimal productionMny; // 本次产值金额(无税)
    private java.math.BigDecimal productionTaxMny; // 本次产值金额
    private java.math.BigDecimal lastProductionMny; // 截止上期累计产值金额(无税)
    private java.math.BigDecimal lastProductionTaxMny; // 截止上期累计产值金额
    private java.math.BigDecimal sumProductionMny; // 累计产值金额(无税)
    private java.math.BigDecimal sumProductionTaxMny; // 累计产值金额
    private String memo; // 备注
    
    private List<com.ejianc.business.steelstructure.income.vo.ProductionDetailCostVO> costList = new ArrayList<>(); // 产值报量子表-费用项清单
    private List<com.ejianc.business.steelstructure.income.vo.ProductionDetailSubVO> subList = new ArrayList<>(); // 产值报量子表-分部分项清单
    private List<ProductionDetailMeasureVO> measureList = new ArrayList<>(); // 产值报量子表-措施项清单
    private List<com.ejianc.business.steelstructure.income.vo.ProductionDetailOtherVO> otherList = new ArrayList<>(); // 产值报量子表-其他项清单
    private List<ProductionDetailFeeVO> feeList = new ArrayList<>(); // 产值报量子表-费税清单

    private Integer budgetVersion;// 预算书版本

    private Integer detailLength;// 子表数量

    public Integer getDetailLength() {
        return detailLength;
    }

    public void setDetailLength(Integer detailLength) {
        this.detailLength = detailLength;
    }

    public Integer getBudgetVersion() {
        return budgetVersion;
    }

    public void setBudgetVersion(Integer budgetVersion) {
        this.budgetVersion = budgetVersion;
    }

    /**
     * 产值进度主键
     */
    public Long getProductionId() {
        return productionId;
    }

    /**
     * 产值进度主键
     */
    public void setProductionId(Long productionId) {
        this.productionId = productionId;
    }
    /**
     * 预算书主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算书主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 预算书编号
     */
    public String getBudgetCode() {
        return budgetCode;
    }

    /**
     * 预算书编号
     */
    public void setBudgetCode(String budgetCode) {
        this.budgetCode = budgetCode;
    }
    /**
     * 预算书名称
     */
    public String getBudgetName() {
        return budgetName;
    }

    /**
     * 预算书名称
     */
    public void setBudgetName(String budgetName) {
        this.budgetName = budgetName;
    }
    /**
     * 预算模式 0-清单模式，1-费用项目模式
     */
    public Integer getBudgetModel() {
        return budgetModel;
    }

    /**
     * 预算模式 0-清单模式，1-费用项目模式
     */
    public void setBudgetModel(Integer budgetModel) {
        this.budgetModel = budgetModel;
    }
    /**
     * 预算来源:0-合同，1-变更，2-签证，3-索赔，4-审定预算书，5-其它
     */
    public String getBudgetSource() {
        return budgetSource;
    }

    /**
     * 预算来源:0-合同，1-变更，2-签证，3-索赔，4-审定预算书，5-其它
     */
    public void setBudgetSource(String budgetSource) {
        this.budgetSource = budgetSource;
    }
    /**
     * 税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 预算金额(无税)
     */
    public java.math.BigDecimal getBudgetMny() {
        return budgetMny;
    }

    /**
     * 预算金额(无税)
     */
    public void setBudgetMny(java.math.BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }
    /**
     * 预算金额
     */
    public java.math.BigDecimal getBudgetTaxMny() {
        return budgetTaxMny;
    }

    /**
     * 预算金额
     */
    public void setBudgetTaxMny(java.math.BigDecimal budgetTaxMny) {
        this.budgetTaxMny = budgetTaxMny;
    }
    /**
     * 本次产值金额(无税)
     */
    public java.math.BigDecimal getProductionMny() {
        return productionMny;
    }

    /**
     * 本次产值金额(无税)
     */
    public void setProductionMny(java.math.BigDecimal productionMny) {
        this.productionMny = productionMny;
    }
    /**
     * 本次产值金额
     */
    public java.math.BigDecimal getProductionTaxMny() {
        return productionTaxMny;
    }

    /**
     * 本次产值金额
     */
    public void setProductionTaxMny(java.math.BigDecimal productionTaxMny) {
        this.productionTaxMny = productionTaxMny;
    }
    /**
     * 截止上期累计产值金额(无税)
     */
    public java.math.BigDecimal getLastProductionMny() {
        return lastProductionMny;
    }

    /**
     * 截止上期累计产值金额(无税)
     */
    public void setLastProductionMny(java.math.BigDecimal lastProductionMny) {
        this.lastProductionMny = lastProductionMny;
    }
    /**
     * 截止上期累计产值金额
     */
    public java.math.BigDecimal getLastProductionTaxMny() {
        return lastProductionTaxMny;
    }

    /**
     * 截止上期累计产值金额
     */
    public void setLastProductionTaxMny(java.math.BigDecimal lastProductionTaxMny) {
        this.lastProductionTaxMny = lastProductionTaxMny;
    }
    /**
     * 累计产值金额(无税)
     */
    public java.math.BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    /**
     * 累计产值金额(无税)
     */
    public void setSumProductionMny(java.math.BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }
    /**
     * 累计产值金额
     */
    public java.math.BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    /**
     * 累计产值金额
     */
    public void setSumProductionTaxMny(java.math.BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     /**
      * 产值报量子表-费用项清单
      */
     public List<com.ejianc.business.steelstructure.income.vo.ProductionDetailCostVO> getCostList() {
        return costList;
     }

     /**
      * 产值报量子表-费用项清单
      */
     public void setCostList(List<com.ejianc.business.steelstructure.income.vo.ProductionDetailCostVO> costList) {
        this.costList = costList;
     }
     /**
      * 产值报量子表-分部分项清单
      */
     public List<com.ejianc.business.steelstructure.income.vo.ProductionDetailSubVO> getSubList() {
        return subList;
     }

     /**
      * 产值报量子表-分部分项清单
      */
     public void setSubList(List<com.ejianc.business.steelstructure.income.vo.ProductionDetailSubVO> subList) {
        this.subList = subList;
     }
     /**
      * 产值报量子表-措施项清单
      */
     public List<ProductionDetailMeasureVO> getMeasureList() {
        return measureList;
     }

     /**
      * 产值报量子表-措施项清单
      */
     public void setMeasureList(List<ProductionDetailMeasureVO> measureList) {
        this.measureList = measureList;
     }
     /**
      * 产值报量子表-其他项清单
      */
     public List<com.ejianc.business.steelstructure.income.vo.ProductionDetailOtherVO> getOtherList() {
        return otherList;
     }

     /**
      * 产值报量子表-其他项清单
      */
     public void setOtherList(List<com.ejianc.business.steelstructure.income.vo.ProductionDetailOtherVO> otherList) {
        this.otherList = otherList;
     }
     /**
      * 产值报量子表-费税清单
      */
     public List<ProductionDetailFeeVO> getFeeList() {
        return feeList;
     }

     /**
      * 产值报量子表-费税清单
      */
     public void setFeeList(List<ProductionDetailFeeVO> feeList) {
        this.feeList = feeList;
     }
}
