package com.ejianc.business.steelstructure.income.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.ArrayList;
import java.util.List;

/**
 * 对甲报量子表
 * 
 * @author generator
 * 
 */
public class QuoteDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long quoteId; // 甲方报量主键
    private Long budgetId; // 预算书主键
    private String budgetCode; // 预算书编号
    private String budgetName; // 预算书名称
    private Integer budgetModel; // 预算模式 0-清单模式，1-费用项目模式
    private String budgetSource; // 预算来源:0-合同，1-变更，2-签证，3-索赔，4-审定预算书，5-其它
    private java.math.BigDecimal taxRate; // 税率
    private java.math.BigDecimal budgetMny; // 预算金额(无税)
    private java.math.BigDecimal budgetTaxMny; // 预算金额
    private java.math.BigDecimal quoteMny; // 本次上报金额(无税)
    private java.math.BigDecimal quoteTaxMny; // 本次上报金额
    private java.math.BigDecimal lastQuoteMny; // 截止上期累计上报金额(无税)
    private java.math.BigDecimal lastQuoteTaxMny; // 截止上期累计上报金额
    private java.math.BigDecimal sumQuoteMny; // 累计上报金额(无税)
    private java.math.BigDecimal sumQuoteTaxMny; // 累计上报金额
    private String memo; // 备注
    
    private List<com.ejianc.business.steelstructure.income.vo.QuoteDetailCostVO> costList = new ArrayList<>(); // 对甲报量子表-费用项清单
    private List<com.ejianc.business.steelstructure.income.vo.QuoteDetailSubVO> subList = new ArrayList<>(); // 对甲报量子表-分部分项清单
    private List<com.ejianc.business.steelstructure.income.vo.QuoteDetailMeasureVO> measureList = new ArrayList<>(); // 对甲报量子表-措施项清单
    private List<com.ejianc.business.steelstructure.income.vo.QuoteDetailOtherVO> otherList = new ArrayList<>(); // 对甲报量子表-其他项清单
    private List<com.ejianc.business.steelstructure.income.vo.QuoteDetailFeeVO> feeList = new ArrayList<>(); // 对甲报量子表-费税清单

    private Integer budgetVersion;

    public Integer getBudgetVersion() {
        return budgetVersion;
    }

    public void setBudgetVersion(Integer budgetVersion) {
        this.budgetVersion = budgetVersion;
    }

    /**
     * 甲方报量主键
     */
    public Long getQuoteId() {
        return quoteId;
    }

    /**
     * 甲方报量主键
     */
    public void setQuoteId(Long quoteId) {
        this.quoteId = quoteId;
    }
    /**
     * 预算书主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算书主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 预算书编号
     */
    public String getBudgetCode() {
        return budgetCode;
    }

    /**
     * 预算书编号
     */
    public void setBudgetCode(String budgetCode) {
        this.budgetCode = budgetCode;
    }
    /**
     * 预算书名称
     */
    public String getBudgetName() {
        return budgetName;
    }

    /**
     * 预算书名称
     */
    public void setBudgetName(String budgetName) {
        this.budgetName = budgetName;
    }
    /**
     * 预算模式 0-清单模式，1-费用项目模式
     */
    public Integer getBudgetModel() {
        return budgetModel;
    }

    /**
     * 预算模式 0-清单模式，1-费用项目模式
     */
    public void setBudgetModel(Integer budgetModel) {
        this.budgetModel = budgetModel;
    }
    /**
     * 预算来源:0-合同，1-变更，2-签证，3-索赔，4-审定预算书，5-其它
     */
    public String getBudgetSource() {
        return budgetSource;
    }

    /**
     * 预算来源:0-合同，1-变更，2-签证，3-索赔，4-审定预算书，5-其它
     */
    public void setBudgetSource(String budgetSource) {
        this.budgetSource = budgetSource;
    }
    /**
     * 税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 预算金额(无税)
     */
    public java.math.BigDecimal getBudgetMny() {
        return budgetMny;
    }

    /**
     * 预算金额(无税)
     */
    public void setBudgetMny(java.math.BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }
    /**
     * 预算金额
     */
    public java.math.BigDecimal getBudgetTaxMny() {
        return budgetTaxMny;
    }

    /**
     * 预算金额
     */
    public void setBudgetTaxMny(java.math.BigDecimal budgetTaxMny) {
        this.budgetTaxMny = budgetTaxMny;
    }
    /**
     * 本次上报金额(无税)
     */
    public java.math.BigDecimal getQuoteMny() {
        return quoteMny;
    }

    /**
     * 本次上报金额(无税)
     */
    public void setQuoteMny(java.math.BigDecimal quoteMny) {
        this.quoteMny = quoteMny;
    }
    /**
     * 本次上报金额
     */
    public java.math.BigDecimal getQuoteTaxMny() {
        return quoteTaxMny;
    }

    /**
     * 本次上报金额
     */
    public void setQuoteTaxMny(java.math.BigDecimal quoteTaxMny) {
        this.quoteTaxMny = quoteTaxMny;
    }
    /**
     * 截止上期累计上报金额(无税)
     */
    public java.math.BigDecimal getLastQuoteMny() {
        return lastQuoteMny;
    }

    /**
     * 截止上期累计上报金额(无税)
     */
    public void setLastQuoteMny(java.math.BigDecimal lastQuoteMny) {
        this.lastQuoteMny = lastQuoteMny;
    }
    /**
     * 截止上期累计上报金额
     */
    public java.math.BigDecimal getLastQuoteTaxMny() {
        return lastQuoteTaxMny;
    }

    /**
     * 截止上期累计上报金额
     */
    public void setLastQuoteTaxMny(java.math.BigDecimal lastQuoteTaxMny) {
        this.lastQuoteTaxMny = lastQuoteTaxMny;
    }
    /**
     * 累计上报金额(无税)
     */
    public java.math.BigDecimal getSumQuoteMny() {
        return sumQuoteMny;
    }

    /**
     * 累计上报金额(无税)
     */
    public void setSumQuoteMny(java.math.BigDecimal sumQuoteMny) {
        this.sumQuoteMny = sumQuoteMny;
    }
    /**
     * 累计上报金额
     */
    public java.math.BigDecimal getSumQuoteTaxMny() {
        return sumQuoteTaxMny;
    }

    /**
     * 累计上报金额
     */
    public void setSumQuoteTaxMny(java.math.BigDecimal sumQuoteTaxMny) {
        this.sumQuoteTaxMny = sumQuoteTaxMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     /**
      * 对甲报量子表-费用项清单
      */
     public List<com.ejianc.business.steelstructure.income.vo.QuoteDetailCostVO> getCostList() {
        return costList;
     }

     /**
      * 对甲报量子表-费用项清单
      */
     public void setCostList(List<com.ejianc.business.steelstructure.income.vo.QuoteDetailCostVO> costList) {
        this.costList = costList;
     }
     /**
      * 对甲报量子表-分部分项清单
      */
     public List<com.ejianc.business.steelstructure.income.vo.QuoteDetailSubVO> getSubList() {
        return subList;
     }

     /**
      * 对甲报量子表-分部分项清单
      */
     public void setSubList(List<com.ejianc.business.steelstructure.income.vo.QuoteDetailSubVO> subList) {
        this.subList = subList;
     }
     /**
      * 对甲报量子表-措施项清单
      */
     public List<com.ejianc.business.steelstructure.income.vo.QuoteDetailMeasureVO> getMeasureList() {
        return measureList;
     }

     /**
      * 对甲报量子表-措施项清单
      */
     public void setMeasureList(List<com.ejianc.business.steelstructure.income.vo.QuoteDetailMeasureVO> measureList) {
        this.measureList = measureList;
     }
     /**
      * 对甲报量子表-其他项清单
      */
     public List<com.ejianc.business.steelstructure.income.vo.QuoteDetailOtherVO> getOtherList() {
        return otherList;
     }

     /**
      * 对甲报量子表-其他项清单
      */
     public void setOtherList(List<com.ejianc.business.steelstructure.income.vo.QuoteDetailOtherVO> otherList) {
        this.otherList = otherList;
     }
     /**
      * 对甲报量子表-费税清单
      */
     public List<com.ejianc.business.steelstructure.income.vo.QuoteDetailFeeVO> getFeeList() {
        return feeList;
     }

     /**
      * 对甲报量子表-费税清单
      */
     public void setFeeList(List<com.ejianc.business.steelstructure.income.vo.QuoteDetailFeeVO> feeList) {
        this.feeList = feeList;
     }
}
