package com.ejianc.business.steelstructure.other.vo;

import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 其他收入合同
 * 
 * @author generator
 * 
 */
public class OtherContractVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ConvertField(targetField = "contractCode")
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    @ConvertField
    private Long projectId; // 项目
    @ConvertField
    private String projectName; // 项目名称
    @ConvertField
    private String projectCode; // 项目编号
    @ConvertField
    private Long orgId; // 组织
    @ConvertField
    private String orgCode; // 组织编码
    @ConvertField
    private String orgName; // 组织名称
    @ConvertField
    private Long parentOrgId; // 父级组织
    @ConvertField
    private String parentOrgCode; // 父级组织编码
    @ConvertField
    private String parentOrgName; // 父级组织名称
    @ConvertField
    private String contractName; // 合同名称
    private Long contractType; // 合同类型
    @ConvertField
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签约日期
    @ConvertField(targetField = "partyaId")
    private Long customerId; // 合同甲方
    @ConvertField(targetField = "partyaName")
    private String customerName; // 合同甲方名称
    @ConvertField(targetField = "partybId")
    private Long supplierId; // 合同乙方
    @ConvertField(targetField = "partybName")
    private String supplierName; // 合同乙方名称
    @ConvertField
    private BigDecimal taxRate; // 合同税率
    @ConvertField(targetField = "contractTax")
    private BigDecimal taxMny; // 税额
    @ConvertField
    private BigDecimal contractMny; // 合同(签订)金额(不含税)
    @ConvertField
    private BigDecimal contractTaxMny; // 合同(签订)金额
    //@ConvertField(targetField = "performanceStatus")
    private String contractStatus; // 合同状态：1-未签订，2-履约中, 3-已封账，4-已解除，5-已冻结
    @ConvertField
    private Long employeeId; // 经办人
    @ConvertField
    private String employeeName; // 经办人名称
    @ConvertField(targetField = "departmentId")
    private Long deptId; // 经办部门
    @ConvertField(targetField = "departmentName")
    private String deptName; // 经办部门名称
    @ConvertField
    private String memo; // 备注
    @ConvertField(targetField = "baseTaxMny")
    private BigDecimal baseTaxMoney; // 初始版本金额（含税）
    @ConvertField(targetField = "baseMny")
    private BigDecimal baseMoney; // 初始版本金额
    private BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    private BigDecimal beforeChangeMny; // 变更前金额
    private BigDecimal changingTaxMny; // 变更中金额（含税）
    private BigDecimal changingMny; // 变更中金额
    private Integer changeVersion; // 变更版本
    private String changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private String changeCode; // 变更单号
    private Long changeId; // 变更主键
    private String changeReason; // 变更原因
    @ConvertField
    private String mainContractName; // 主合同名称
    @ConvertField
    private Long mainContractId; // 主合同ID
    @ConvertField
    private String mainContractCode; // 主合同编码
    private BigDecimal sumSettleMny; // 累计结算金额（含税）
    private BigDecimal sumSettleTaxMny; // 累计结算金额
    private BigDecimal sumCollectMny; // 累计收款
    private BigDecimal sumInvoicingTaxMny; // 累计开票（含税）
    private BigDecimal sumInvoicingMny; // 累计开票
    @ConvertField
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    private Integer isFinish; // 是否已做结算(1:是，0：否)
    private Integer isRelieve; // 是否已解除：0-否，1-是
    private String supplementContent; // 补充协议内容
    private Integer isSuspend; // 是否中止：0-否，1-是
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeTime; // 变更（编制）时间
    private String contractStatusName;
    private String billStateName;
    @ConvertField(targetField = "sourceId,contractId,id")
    private Long id;

    @ConvertField
    private Integer dr;

    private List<com.ejianc.business.steelstructure.other.vo.OtherDetailVO> checkList = new ArrayList<>(); // 其他收入合同表-清单
    private List<OtherClauseVO> clauseList = new ArrayList<>();

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getCustomerId() {
        return customerId;
    }
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }
    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public String getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(String changeStatus) {
        this.changeStatus = changeStatus;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    public void setSumSettleMny(BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }

    public BigDecimal getSumSettleTaxMny() {
        return sumSettleTaxMny;
    }

    public void setSumSettleTaxMny(BigDecimal sumSettleTaxMny) {
        this.sumSettleTaxMny = sumSettleTaxMny;
    }

    public BigDecimal getSumCollectMny() {
        return sumCollectMny;
    }

    public void setSumCollectMny(BigDecimal sumCollectMny) {
        this.sumCollectMny = sumCollectMny;
    }
    public BigDecimal getSumInvoicingTaxMny() {
        return sumInvoicingTaxMny;
    }

    public void setSumInvoicingTaxMny(BigDecimal sumInvoicingTaxMny) {
        this.sumInvoicingTaxMny = sumInvoicingTaxMny;
    }
    public BigDecimal getSumInvoicingMny() {
        return sumInvoicingMny;
    }

    public void setSumInvoicingMny(BigDecimal sumInvoicingMny) {
        this.sumInvoicingMny = sumInvoicingMny;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public Integer getIsFinish() {
        return isFinish;
    }

    public void setIsFinish(Integer isFinish) {
        this.isFinish = isFinish;
    }
    public Integer getIsRelieve() {
        return isRelieve;
    }

    public void setIsRelieve(Integer isRelieve) {
        this.isRelieve = isRelieve;
    }
    public String getSupplementContent() {
        return supplementContent;
    }

    public void setSupplementContent(String supplementContent) {
        this.supplementContent = supplementContent;
    }
    public Integer getIsSuspend() {
        return isSuspend;
    }

    public void setIsSuspend(Integer isSuspend) {
        this.isSuspend = isSuspend;
    }
    public Date getChangeTime() {
        return changeTime;
    }

    public void setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
    }

    public List<com.ejianc.business.steelstructure.other.vo.OtherDetailVO> getCheckList() {
        return checkList;
    }

    public void setCheckList(List<com.ejianc.business.steelstructure.other.vo.OtherDetailVO> checkList) {
        this.checkList = checkList;
    }

    public List<OtherClauseVO> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<OtherClauseVO> clauseList) {
        this.clauseList = clauseList;
    }

    public String getContractStatusName() {
        return contractStatusName;
    }

    public void setContractStatusName(String contractStatusName) {
        this.contractStatusName = contractStatusName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Integer getDr() {
        return dr;
    }

    @Override
    public void setDr(Integer dr) {
        this.dr = dr;
    }
}
