package com.ejianc.business.steelstructure.income.api;

import com.ejianc.business.steelstructure.income.hystrix.ProincomeBudgetHystrix;
import com.ejianc.business.steelstructure.income.vo.BudgetReportVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name= "ejc-steelstructure-web", url="${common.env.feign-client-url}", path="ejc-steelstructure-web", fallback = ProincomeBudgetHystrix.class)
public interface IProincomeBudgetApi {

    /**
     * 根据项目查项目预算金额
     * @param projectId
     * @param endDate
     * @return
     */
    @GetMapping("/api/budgetApi/querySumBudgetMny")
    public CommonResponse<List<BudgetReportVO>> querySumBudgetMny(@RequestParam(value = "projectId") Long projectId,
                                                                  @RequestParam(value = "endDate", required = false) String endDate);
}
