package com.ejianc.business.steelstructure.income.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 清单明细
 *
 * @author generator
 *
 */
public class BudgetDetailReportVO extends BaseVO{
    private static final long serialVersionUID = 1L;

    private Long budgetId; // 预算书主键
    private Long budgetBid; // 清单项主键
    private String billCode; // 单据编号
    private Integer budgetModel; // 模式,0-清单模式，1-费用项模式，2-郑州一建预算清单
    private String budgetModelName; // 模式,0-清单模式，1-费用项模式，2-郑州一建预算清单
    private String budgetName; // 预算书名称
    private String accountingName; // 核算对象名称

    private String subDetailIndex; // 序号
    private String subCode; // 编码
    private String subName; // 名称
    private String subFeature; // 特征
    private String subUnit; // 单位
    private BigDecimal subNum; // 工程量
    private BigDecimal subPrice; // 综合单价(无税)
    private BigDecimal subMny; // 综合合价

    private String detailIndex; // 序号
    private Integer detailType; // 清单项类型:0-分部分项，1-措施项，2-其他项，3-费税
    private String detailCode; // 编码
    private String detailName; // 名称
    private String detailSpec; // 规格
    private String detailUnit; // 单位
    private BigDecimal detailNum; // 工程量
    private BigDecimal detailPrice; // 综合单价(无税)
    private BigDecimal detailMny; // 综合合价
    private Long detailSubjectId; // 成本科目id
    private String detailSubjectName; // 成本科目名称


    @ReferSerialTransfer(referCode="subject-project-org-ref")
    public Long getDetailSubjectId() {
        return detailSubjectId;
    }
    @ReferDeserialTransfer
    public void setDetailSubjectId(Long detailSubjectId) {
        this.detailSubjectId = detailSubjectId;
    }

    public String getDetailSubjectName() {
        return detailSubjectName;
    }

    public void setDetailSubjectName(String detailSubjectName) {
        this.detailSubjectName = detailSubjectName;
    }

    /**
     * 预算书主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算书主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 清单项主键
     */
    public Long getBudgetBid() {
        return budgetBid;
    }

    /**
     * 清单项主键
     */
    public void setBudgetBid(Long budgetBid) {
        this.budgetBid = budgetBid;
    }
    /**
     * 清单项类型:0-分部分项，1-措施项，2-其他项，3-费税
     */
    public Integer getDetailType() {
        return detailType;
    }

    /**
     * 清单项类型:0-分部分项，1-措施项，2-其他项，3-费税
     */
    public void setDetailType(Integer detailType) {
        this.detailType = detailType;
    }

    public String getBudgetModelName() {
        return budgetModelName;
    }

    public void setBudgetModelName(String budgetModelName) {
        this.budgetModelName = budgetModelName;
    }

    /**
     * 编码
     */
    public String getDetailCode() {
        return detailCode;
    }

    /**
     * 编码
     */
    public void setDetailCode(String detailCode) {
        this.detailCode = detailCode;
    }
    /**
     * 名称
     */
    public String getDetailName() {
        return detailName;
    }

    /**
     * 名称
     */
    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }
    /**
     * 规格
     */
    public String getDetailSpec() {
        return detailSpec;
    }

    /**
     * 规格
     */
    public void setDetailSpec(String detailSpec) {
        this.detailSpec = detailSpec;
    }
    /**
     * 单位
     */
    public String getDetailUnit() {
        return detailUnit;
    }

    /**
     * 单位
     */
    public void setDetailUnit(String detailUnit) {
        this.detailUnit = detailUnit;
    }
    /**
     * 工程量
     */
    public BigDecimal getDetailNum() {
        return detailNum;
    }

    /**
     * 工程量
     */
    public void setDetailNum(BigDecimal detailNum) {
        this.detailNum = detailNum;
    }
    /**
    /**
     * 综合单价(无税)
     */
    public BigDecimal getDetailPrice() {
        return detailPrice;
    }

    /**
     * 综合单价(无税)
     */
    public void setDetailPrice(BigDecimal detailPrice) {
        this.detailPrice = detailPrice;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBudgetModel() {
        return budgetModel;
    }

    public void setBudgetModel(Integer budgetModel) {
        this.budgetModel = budgetModel;
    }

    public String getBudgetName() {
        return budgetName;
    }

    public void setBudgetName(String budgetName) {
        this.budgetName = budgetName;
    }

    public String getAccountingName() {
        return accountingName;
    }

    public void setAccountingName(String accountingName) {
        this.accountingName = accountingName;
    }

    public String getSubDetailIndex() {
        return subDetailIndex;
    }

    public void setSubDetailIndex(String subDetailIndex) {
        this.subDetailIndex = subDetailIndex;
    }

    public String getSubCode() {
        return subCode;
    }

    public void setSubCode(String subCode) {
        this.subCode = subCode;
    }

    public String getSubName() {
        return subName;
    }

    public void setSubName(String subName) {
        this.subName = subName;
    }

    public String getSubFeature() {
        return subFeature;
    }

    public void setSubFeature(String subFeature) {
        this.subFeature = subFeature;
    }

    public String getSubUnit() {
        return subUnit;
    }

    public void setSubUnit(String subUnit) {
        this.subUnit = subUnit;
    }

    public BigDecimal getSubNum() {
        return subNum;
    }

    public void setSubNum(BigDecimal subNum) {
        this.subNum = subNum;
    }

    public BigDecimal getSubPrice() {
        return subPrice;
    }

    public void setSubPrice(BigDecimal subPrice) {
        this.subPrice = subPrice;
    }

    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }

    public BigDecimal getSubMny() {
        return subMny;
    }

    public void setSubMny(BigDecimal subMny) {
        this.subMny = subMny;
    }

    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
}
