package com.ejianc.business.steelstructure.income.vo;

import com.ejianc.business.steelstructure.income.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 清单明细
 * 
 * @author generator
 * 
 */
public class BudgetDetailVO extends BaseVO implements ITreeNodeB{
    private static final long serialVersionUID = 1L;
    
    private Long budgetId; // 预算书主键
    private Long budgetBid; // 清单项主键
    private Integer detailType; // 清单项类型:0-分部分项，1-措施项，2-其他项，3-费税
    private String detailCode; // 编码
    private String detailName; // 名称
    private String detailSpec; // 规格
    private String detailUnit; // 单位
    private BigDecimal detailNum; // 工程量
    private BigDecimal detailTaxRate; // 税率
    private BigDecimal detailPrice; // 综合单价(无税)
    private BigDecimal detailTaxPrice; // 综合单价(含税)
    private BigDecimal detailMny; // 合价(无税)
    private BigDecimal detailTaxMny; // 合价(含税)
    private BigDecimal detailTax; // 税额
    private String detailMemo; // 备注
    private String tid;
    private String tpid;
    private String indexCode;//序号
    private Integer nodeLevel; // 级别
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    //错误信息
    private String warnType;

    private Long parentId; // 父ID
    private String detailIndex; // 序号
    private Boolean leafFlag; // 是否末级
    private BigDecimal content; // 含量
    private Long detailSubjectId; // 成本科目id
    private String detailSubjectName; // 成本科目名称

    private List<ITreeNodeB> children;
    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public Integer getNodeLevel() {
        return nodeLevel;
    }

    public void setNodeLevel(Integer nodeLevel) {
        this.nodeLevel = nodeLevel;
    }


    public String getIndexCode() {
        return indexCode;
    }

    public void setIndexCode(String indexCode) {
        this.indexCode = indexCode;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public BigDecimal getContent() {
        return content;
    }

    public void setContent(BigDecimal content) {
        this.content = content;
    }
    @ReferSerialTransfer(referCode="subject-project-org-ref")
    public Long getDetailSubjectId() {
        return detailSubjectId;
    }
    @ReferDeserialTransfer
    public void setDetailSubjectId(Long detailSubjectId) {
        this.detailSubjectId = detailSubjectId;
    }

    public String getDetailSubjectName() {
        return detailSubjectName;
    }

    public void setDetailSubjectName(String detailSubjectName) {
        this.detailSubjectName = detailSubjectName;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }

    /**
     * 预算书主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算书主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 清单项主键
     */
    public Long getBudgetBid() {
        return budgetBid;
    }

    /**
     * 清单项主键
     */
    public void setBudgetBid(Long budgetBid) {
        this.budgetBid = budgetBid;
    }
    /**
     * 清单项类型:0-分部分项，1-措施项，2-其他项，3-费税
     */
    public Integer getDetailType() {
        return detailType;
    }

    /**
     * 清单项类型:0-分部分项，1-措施项，2-其他项，3-费税
     */
    public void setDetailType(Integer detailType) {
        this.detailType = detailType;
    }
    /**
     * 编码
     */
    public String getDetailCode() {
        return detailCode;
    }

    /**
     * 编码
     */
    public void setDetailCode(String detailCode) {
        this.detailCode = detailCode;
    }
    /**
     * 名称
     */
    public String getDetailName() {
        return detailName;
    }

    /**
     * 名称
     */
    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }
    /**
     * 规格
     */
    public String getDetailSpec() {
        return detailSpec;
    }

    /**
     * 规格
     */
    public void setDetailSpec(String detailSpec) {
        this.detailSpec = detailSpec;
    }
    /**
     * 单位
     */
    public String getDetailUnit() {
        return detailUnit;
    }

    /**
     * 单位
     */
    public void setDetailUnit(String detailUnit) {
        this.detailUnit = detailUnit;
    }
    /**
     * 工程量
     */
    public BigDecimal getDetailNum() {
        return detailNum;
    }

    /**
     * 工程量
     */
    public void setDetailNum(BigDecimal detailNum) {
        this.detailNum = detailNum;
    }
    /**
     * 税率
     */
    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    /**
     * 税率
     */
    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }
    /**
     * 综合单价(无税)
     */
    public BigDecimal getDetailPrice() {
        return detailPrice;
    }

    /**
     * 综合单价(无税)
     */
    public void setDetailPrice(BigDecimal detailPrice) {
        this.detailPrice = detailPrice;
    }
    /**
     * 综合单价(含税)
     */
    public BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    /**
     * 综合单价(含税)
     */
    public void setDetailTaxPrice(BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }
    /**
     * 合价(无税)
     */
    public BigDecimal getDetailMny() {
        return detailMny;
    }

    /**
     * 合价(无税)
     */
    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
    /**
     * 合价(含税)
     */
    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    /**
     * 合价(含税)
     */
    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }
    /**
     * 备注
     */
    public String getDetailMemo() {
        return detailMemo;
    }

    /**
     * 备注
     */
    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }
    
}
