package com.ejianc.business.steelstructure.income.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class RegisterChangeHistoryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    /**
     * 合同主键
     */
    private Long registerId;
    
    /**
     * 合同金额(含税)
     */
    private BigDecimal contractTaxMny;

    /**
     * 合同金额(无税)
     */
    private BigDecimal contractMny;
    
    /**
     * 初始版本金额(含税)
     */
    private BigDecimal baseTaxMoney;

    /**
     * 初始版本金额(无税)
     */
    private BigDecimal baseMoney;
    
    /**
     * 累计变更金额
     */
    private BigDecimal sumChangeMny;

    /**
     * 累计变更率
     */
    private BigDecimal sumScale;
    
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    private String changeStatus;

    /**
     * 是否已做竣工结算(1:是，0：否)
     */
    private Integer isFinish;

    /**
     * 是否已解除：0-否，1-是
     */
    private Integer isRelieve;

    private Integer isSuspend; // 是否已中止/解除：0-否，1-是
    
    private List<ContractRegisterChangeVO> changeRecord = new ArrayList<>();

    public Long getRegisterId() {
        return registerId;
    }

    public void setRegisterId(Long registerId) {
        this.registerId = registerId;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    public BigDecimal getSumChangeMny() {
        return sumChangeMny;
    }

    public void setSumChangeMny(BigDecimal sumChangeMny) {
        this.sumChangeMny = sumChangeMny;
    }

    public BigDecimal getSumScale() {
        return sumScale;
    }

    public void setSumScale(BigDecimal sumScale) {
        this.sumScale = sumScale;
    }
    
    public String getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(String changeStatus) {
        this.changeStatus = changeStatus;
    }
    
    public Integer getIsFinish() {
        return isFinish;
    }

    public void setIsFinish(Integer isFinish) {
        this.isFinish = isFinish;
    }

    public Integer getIsRelieve() {
        return isRelieve;
    }

    public void setIsRelieve(Integer isRelieve) {
        this.isRelieve = isRelieve;
    }

    public Integer getIsSuspend() {
        return isSuspend;
    }

    public void setIsSuspend(Integer isSuspend) {
        this.isSuspend = isSuspend;
    }

    public List<ContractRegisterChangeVO> getChangeRecord() {
        return changeRecord;
    }

    public void setChangeRecord(List<ContractRegisterChangeVO> changeRecord) {
        this.changeRecord = changeRecord;
    }
}
