/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.income.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
public class ValidateUtil {
    private static final Logger logger = LoggerFactory.getLogger(ValidateUtil.class);
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ICommenQueryFieldsService queryFieldsService;
    private static final String REQUEST_ID = "saveOrUpdate";

    public Boolean validateUpStreamVersion(String billId, String billTypeCode, Integer version) {
        Boolean flag = true;
        if (version != null && version != 0) {
            Jedis jedis = this.jedisPool.getResource();
            boolean locked = false;
            try {
                locked = RedisTool.tryLock((Jedis)jedis, (String)billId, (String)REQUEST_ID, (int)1000);
                logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
                if (locked) {
                    JSONObject json = this.queryFieldsService.queryBillDetail(billId, billTypeCode);
                    logger.info("====" + json.toJSONString());
                    Object obj = json.getJSONObject("data").get((Object)"version");
                    String str = obj != null ? obj.toString() : "0";
                    str = str.indexOf(".") > 0 ? str.substring(0, str.indexOf(".")) : str;
                    Integer dataVersion = Integer.parseInt(str);
                    if (version.intValue() != dataVersion.intValue()) {
                        flag = false;
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
            }
            finally {
                if (locked) {
                    RedisTool.releaseLock((Jedis)jedis, (String)billId, (String)REQUEST_ID);
                }
                jedis.close();
            }
        }
        return flag;
    }
}

