package com.ejianc.business.steelstructure.income.utils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum SubjectEnum {

    增值税("SJ","增值税"),
    人工费("RGF","人工费"),
    机械设备费("JXF","机械设备费"),
    间接费_管理费("GLF","间接费"),
    间接费_规费("GF","间接费"),
    材料费_安全文明("AQWMF","材料费"),
    材料费_其他措施费("QTCSF","材料费");

    private String subjectCode;

    private String subjectName;
    private static Map<String, SubjectEnum> enumMap = new HashMap<>();
    private static Map<String, String> codeNameMap = new HashMap<>();
    private static List<String> codeList = new ArrayList<>();

    static {
        enumMap = EnumSet.allOf(SubjectEnum.class).stream().collect(Collectors.toMap(SubjectEnum::getSubjectCode, Function.identity(), (k1, k2) -> k2));
    }
    static {
        codeNameMap = EnumSet.allOf(SubjectEnum.class).stream().collect(Collectors.toMap(SubjectEnum::getSubjectCode, SubjectEnum::getSubjectName, (k1, k2) -> k2));
    }
    static {
        codeList = EnumSet.allOf(SubjectEnum.class).stream().map(SubjectEnum::getSubjectCode).collect(Collectors.toList());
    }

    SubjectEnum(String subjectCode, String subjectName) {
        this.subjectCode = subjectCode;
        this.subjectName = subjectName;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public static SubjectEnum getEnumBySubjectCode(String subjectCode) {
        return enumMap.get(subjectCode);
    }
    public static String getNameByCode(String subjectCode) {
        return codeNameMap.get(subjectCode);
    }
    public static List<String> getCodeList() {
        return codeList;
    }
}
