package com.ejianc.business.steelstructure.income.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 工程造价调整-调整来源
 * 
 * @author generator
 * 
 */
public class CostAdjustDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long adjustId; // 造价调整ID
    private Long claimId; // 洽商签证索赔ID
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private String claimTitle; // 洽商签证索赔标题
    private String billType; // 单据类型：QS-洽商，QZ-签证，SP-索赔
    private BigDecimal claimMny; // 洽商签证索赔金额(无税)
    private BigDecimal claimTaxMny; // 洽商签证索赔金额
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate; // 提交日期

    private String replyStatus; // 甲方批复状态(0-未通过，1-未批复，2-已批复)
    private BigDecimal replyMny; // 甲方批复金额(无税)
    private BigDecimal replyTaxMny; // 甲方批复金额
    

    public Long getAdjustId() {
        return adjustId;
    }

    public void setAdjustId(Long adjustId) {
        this.adjustId = adjustId;
    }
    public Long getClaimId() {
        return claimId;
    }

    public void setClaimId(Long claimId) {
        this.claimId = claimId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getClaimTitle() {
        return claimTitle;
    }

    public void setClaimTitle(String claimTitle) {
        this.claimTitle = claimTitle;
    }
    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }
    public BigDecimal getClaimMny() {
        return claimMny;
    }

    public void setClaimMny(BigDecimal claimMny) {
        this.claimMny = claimMny;
    }
    public BigDecimal getClaimTaxMny() {
        return claimTaxMny;
    }

    public void setClaimTaxMny(BigDecimal claimTaxMny) {
        this.claimTaxMny = claimTaxMny;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getReplyStatus() {
        return replyStatus;
    }

    public void setReplyStatus(String replyStatus) {
        this.replyStatus = replyStatus;
    }

    public BigDecimal getReplyMny() {
        return replyMny;
    }

    public void setReplyMny(BigDecimal replyMny) {
        this.replyMny = replyMny;
    }

    public BigDecimal getReplyTaxMny() {
        return replyTaxMny;
    }

    public void setReplyTaxMny(BigDecimal replyTaxMny) {
        this.replyTaxMny = replyTaxMny;
    }
}
