package com.ejianc.business.steelstructure.income.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;


/**
 * 投标信息跟踪
 * 
 * @author generator
 * 
 */
//("投标信息跟踪")
public class InfoTrackVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    //("单据编码")
    private String billCode;
    //("工程名称")
    private String engineeringName;
    //("历史工程名称")
    private String hisEngineeringName;
    //("信息来源")
    private Long infoSource;
    //("信息来源名称")
    private String infoSourceName;
    //("跟踪单位")
    private Long followUnit;
    //("跟踪单位名称")
    private String followUnitName;
    //("单位负责人")
    private Long unitDirector;
    //("单位负责人名称")
    private String unitDirectorName;
    //("单位负责人联系方式")
    private String unitDirectorPhone;
    //("招标代理机构")
    private String biddingAgency;
    //("项目投标主管")
    private Long projectBidManage;
    //("项目投标主管")
    private String projectBidManageName;
    //("项目投标主管联系方式")
    private String projectBidManagePhone;
    //("跟踪状态(1:跟踪中，0：已结束)")
    private Integer followState;
    //("工程地点")
    private String address;
    //("地区")
    private String area;
    //地区名称
    private String areaName;
    //("省份")
    private String province;
    //("市")
    private String city;
    //("区县")
    private String region;
    //("建设单位")
    private Long constructionUnit;
    //("建设单位名称")
    private String constructionUnitName;
    //("业主委托人")
    private String ownerEntrust;
    //("业主委托人联系方式")
    private String ownerEntrustPhone;
    //("资金来源")
    private Long fundsSource;
    //("资金来源名称")
    private String fundsSourceName;
    //("招标形式")
    private Integer biddingForm;
    //("投标范围")
    private String bidRange;
    //("工程类别")
    private Long engineeringType;
    //("工程类别名称")
    private String engineeringTypeName;
    //("计划工期")
    private BigDecimal planDuration;
    //("投资金额")
    private BigDecimal investorAmount;
    //("本次项目投资金额")
    private BigDecimal theInvestmentAmount;
    //("预计招标日期")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date estimatedBiddingDate;
    //("工程概况")
    private String projectOverview;
    //("备注")
    private String remark;
    //("编制人")
    private Long employeeId;
    //("编制人名称")
    private String employeeName;
    //("编制日期")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date billDate;
    //("报名日期")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date signUpDate;
    //("单据状态（审批必须字段）")
    private Integer billState;
    //("所属组织")
    private Long orgId;
    //("所属组织名称")
    private String orgName;
    //("是否中止1是0否")
    private Integer isStop;

    //("所属组织编码")
    private String orgCode;

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }


    /** 单据、跟踪状态名称 */
    private String billStateName;

    private String followStateName;

    private String biddingFormName;
    //跟踪日期
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date trackDate;

    /** 投标记录 */
   /* private List<RecordVO> records;

    public List<RecordVO> getRecords() {
        return records;
    }

    public void setRecords(List<RecordVO> records) {
        this.records = records;
    }*/

    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 工程名称
     */
    public String getEngineeringName() {
        return engineeringName;
    }

    /**
     * 工程名称
     */
    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }

    /**
     * 历史工程名称
     */
    public String getHisEngineeringName() {
        return hisEngineeringName;
    }
    /**
     * 历史工程名称
     */
    public void setHisEngineeringName(String hisEngineeringName) {
        this.hisEngineeringName = hisEngineeringName;
    }

    /**
     * 信息来源
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getInfoSource() {
        return infoSource;
    }

    /**
     * 信息来源
     */
    @ReferDeserialTransfer
    public void setInfoSource(Long infoSource) {
        this.infoSource = infoSource;
    }
    /**
     * 信息来源名称
     */
    public String getInfoSourceName() {
        return infoSourceName;
    }

    /**
     * 信息来源名称
     */
    public void setInfoSourceName(String infoSourceName) {
        this.infoSourceName = infoSourceName;
    }
    /**
     * 跟踪单位
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getFollowUnit() {
        return followUnit;
    }

    /**
     * 跟踪单位
     */
    @ReferDeserialTransfer
    public void setFollowUnit(Long followUnit) {
        this.followUnit = followUnit;
    }
    /**
     * 跟踪单位名称
     */
    public String getFollowUnitName() {
        return followUnitName;
    }

    /**
     * 跟踪单位名称
     */
    public void setFollowUnitName(String followUnitName) {
        this.followUnitName = followUnitName;
    }
    /**
     * 单位负责人
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getUnitDirector() {
        return unitDirector;
    }

    /**
     * 单位负责人
     */
    @ReferDeserialTransfer
    public void setUnitDirector(Long unitDirector) {
        this.unitDirector = unitDirector;
    }

    /**
     * 单位负责人名称
     */
    public String getUnitDirectorName() {
        return unitDirectorName;
    }
    /**
     * 单位负责人名称
     */
    public void setUnitDirectorName(String unitDirectorName) {
        this.unitDirectorName = unitDirectorName;
    }

    /**
     * 单位负责人联系方式
     */
    public String getUnitDirectorPhone() {
        return unitDirectorPhone;
    }

    /**
     * 单位负责人联系方式
     */
    public void setUnitDirectorPhone(String unitDirectorPhone) {
        this.unitDirectorPhone = unitDirectorPhone;
    }
    /**
     * 招标代理机构
     */
    public String getBiddingAgency() {
        return biddingAgency;
    }

    /**
     * 招标代理机构
     */
    public void setBiddingAgency(String biddingAgency) {
        this.biddingAgency = biddingAgency;
    }
    /**
     * 项目投标主管
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getProjectBidManage() {
        return projectBidManage;
    }

    /**
     * 项目投标主管
     */
    @ReferDeserialTransfer
    public void setProjectBidManage(Long projectBidManage) {
        this.projectBidManage = projectBidManage;
    }

    /**
     * 项目投标主管姓名
     */
    public String getProjectBidManageName() {
        return projectBidManageName;
    }
    /**
     * 项目投标主管姓名
     */
    public void setProjectBidManageName(String projectBidManageName) {
        this.projectBidManageName = projectBidManageName;
    }

    /**
     * 项目投标主管联系方式
     */
    public String getProjectBidManagePhone() {
        return projectBidManagePhone;
    }

    /**
     * 项目投标主管联系方式
     */
    public void setProjectBidManagePhone(String projectBidManagePhone) {
        this.projectBidManagePhone = projectBidManagePhone;
    }
    /**
     * 跟踪状态(1:跟踪中，2：已报名，0：已结束)
     */
    public Integer getFollowState() {
        return followState;
    }

    /**
     * 跟踪状态(1:跟踪中，2：已报名，0：已结束)
     */
    public void setFollowState(Integer followState) {
        this.followState = followState;
    }
    /**
     * 工程地点
     */
    public String getAddress() {
        return address;
    }

    /**
     * 工程地点
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * 地区
     */
    public String getArea() {
        return area;
    }
    /**
     * 地区
     */
    public void setArea(String area) {
        this.area = area;
    }

    /**
     * 省份
     */
    public String getProvince() {
        return province;
    }

    /**
     * 省份
     */
    public void setProvince(String province) {
        this.province = province;
    }
    /**
     * 市
     */
    public String getCity() {
        return city;
    }

    /**
     * 市
     */
    public void setCity(String city) {
        this.city = city;
    }
    /**
     * 区县
     */
    public String getRegion() {
        return region;
    }

    /**
     * 区县
     */
    public void setRegion(String region) {
        this.region = region;
    }
    /**
     * 建设单位
     */
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getConstructionUnit() {
        return constructionUnit;
    }

    /**
     * 建设单位
     */
    @ReferDeserialTransfer
    public void setConstructionUnit(Long constructionUnit) {
        this.constructionUnit = constructionUnit;
    }
    /**
     * 建设单位名称
     */
    public String getConstructionUnitName() {
        return constructionUnitName;
    }

    /**
     * 建设单位名称
     */
    public void setConstructionUnitName(String constructionUnitName) {
        this.constructionUnitName = constructionUnitName;
    }
    /**
     * 业主委托人
     */
    public String getOwnerEntrust() {
        return ownerEntrust;
    }

    /**
     * 业主委托人
     */
    public void setOwnerEntrust(String ownerEntrust) {
        this.ownerEntrust = ownerEntrust;
    }
    /**
     * 业主委托人联系方式
     */
    public String getOwnerEntrustPhone() {
        return ownerEntrustPhone;
    }

    /**
     * 业主委托人联系方式
     */
    public void setOwnerEntrustPhone(String ownerEntrustPhone) {
        this.ownerEntrustPhone = ownerEntrustPhone;
    }
    /**
     * 资金来源
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFundsSource() {
        return fundsSource;
    }

    /**
     * 资金来源
     */
    @ReferDeserialTransfer
    public void setFundsSource(Long fundsSource) {
        this.fundsSource = fundsSource;
    }
    /**
     * 资金来源名称
     */
    public String getFundsSourceName() {
        return fundsSourceName;
    }
    /**
     * 资金来源名称
     */
    public void setFundsSourceName(String fundsSourceName) {
        this.fundsSourceName = fundsSourceName;
    }

    /**
     * 招标形式
     */
    public Integer getBiddingForm() {
        return biddingForm;
    }

    /**
     * 招标形式
     */
    public void setBiddingForm(Integer biddingForm) {
        this.biddingForm = biddingForm;
    }

    /**
     * 投标范围
     */
    public String getBidRange() {
        return bidRange;
    }

    /**
     * 投标范围
     */
    public void setBidRange(String bidRange) {
        this.bidRange = bidRange;
    }
    /**
     * 工程类别
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEngineeringType() {
        return engineeringType;
    }

    /**
     * 工程类别
     */
    @ReferDeserialTransfer
    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }
    /**
     * 工程类别名称
     */
    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    /**
     * 工程类别名称
     */
    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }
    /**
     * 计划工期
     */
    public BigDecimal getPlanDuration() {
        return planDuration;
    }

    /**
     * 计划工期
     */
    public void setPlanDuration(BigDecimal planDuration) {
        this.planDuration = planDuration;
    }
    /**
     * 投资金额
     */
    public BigDecimal getInvestorAmount() {
        return investorAmount;
    }

    /**
     * 投资金额
     */
    public void setInvestorAmount(BigDecimal investorAmount) {
        this.investorAmount = investorAmount;
    }
    /**
     * 本次项目投资金额
     */
    public BigDecimal getTheInvestmentAmount() {
        return theInvestmentAmount;
    }

    /**
     * 本次项目投资金额
     */
    public void setTheInvestmentAmount(BigDecimal theInvestmentAmount) {
        this.theInvestmentAmount = theInvestmentAmount;
    }
    /**
     * 预计招标日期
     */
    public Date getEstimatedBiddingDate() {
        return estimatedBiddingDate;
    }

    /**
     * 预计招标日期
     */
    public void setEstimatedBiddingDate(Date estimatedBiddingDate) {
        this.estimatedBiddingDate = estimatedBiddingDate;
    }
    /**
     * 工程概况
     */
    public String getProjectOverview() {
        return projectOverview;
    }

    /**
     * 工程概况
     */
    public void setProjectOverview(String projectOverview) {
        this.projectOverview = projectOverview;
    }
    /**
     * 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * 编制人
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }
    /**
     * 编制人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 编制人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }
    /**
     * 编制人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 编制日期
     */
    public Date getBillDate() {
        return billDate;
    }
    /**
     * 编制日期
     */
    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    /**
     * 报名日期
     */
    public Date getSignUpDate() {
        return signUpDate;
    }

    /**
     * 报名日期
     */
    public void setSignUpDate(Date signUpDate) {
        this.signUpDate = signUpDate;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 所属组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 是否中止 1是0否
     */
    public Integer getIsStop() {
        return isStop;
    }

    public void setIsStop(Integer isStop) {
        this.isStop = isStop;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getFollowStateName() {
        return followStateName;
    }

    public void setFollowStateName(String followStateName) {
        this.followStateName = followStateName;
    }

    public String getBiddingFormName() {
        return biddingFormName;
    }

    public void setBiddingFormName(String biddingFormName) {
        this.biddingFormName = biddingFormName;
    }

    public Date getTrackDate() {
        return trackDate;
    }

    public void setTrackDate(Date trackDate) {
        this.trackDate = trackDate;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
}
