package com.ejianc.business.steelstructure.other.vo;

import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 其他收入合同结算
 * 
 * @author generator
 * 
 */
public class OtherSettleVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    @ConvertField(targetField = "projectId")
    private Long projectId; // 项目
    @ConvertField(targetField = "orgId")
    private Long orgId; // 组织
    @ConvertField(targetField = "billCode")
    private String billCode; // 单据编号
    @ConvertField(targetField = "contractId")
    private Long contractId; // 合同主键
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ConvertField(targetField = "settleDate")
    private Date settleDate; // 报量时间
    @ConvertField(targetField = "employeeId")
    private Long employeeId; // 经办人
    @ConvertField(targetField = "curTaxMny")
    private BigDecimal settleTaxMny; // 本期结算金额（含税）
    private BigDecimal taxRate; // 合同税率
    @ConvertField(targetField = "curTax")
    private BigDecimal tax; // 税金
    @ConvertField(targetField = "curMny")
    private BigDecimal settleMny; // 本期结算金额（不含税）
    private BigDecimal sumSettleMny; // 截至上期累计结算金额（不含税）
    private BigDecimal sumSettleTaxMny; // 截至上期累计结算金额（含税）
    @ConvertField(targetField = "billState")
    private Integer billState; // 单据状态
    private String contractName; // 合同名称
    @ConvertField(targetField = "projectName")
    private String projectName; // 项目名称
    @ConvertField(targetField = "employeeName")
    private String employeeName; // 经办人名称
    private BigDecimal contractMny; // 合同金额(不含税)
    private BigDecimal contractTaxMny; // 合同金额(含税)
    @ConvertField(targetField = "orgName")
    private String orgName; // 组织名称
    private BigDecimal sumSettleRate; // 截至上期累计结算比例
    private BigDecimal totalSettleMny; // 累计结算金额（不含税）
    private BigDecimal totalSettleTaxMny; // 累计结算金额（含税）
    private BigDecimal totalSettleRate; // 累计结算比例
    private String sourceId; // 来源主键
    @ConvertField(targetField = "departmentId")
    private Long deptId; // 部门id
    @ConvertField(targetField = "departmentName")
    private String deptName; // 部门名称
    @ConvertField
    private String billStateName;
    @ConvertField(targetField = "parentOrgId")
    private Long parentOrgId; // 父级组织
    @ConvertField(targetField = "parentOrgCode")
    private String parentOrgCode; // 父级组织编码
    @ConvertField(targetField = "parentOrgName")
    private String parentOrgName; // 父级组织名称
    @ConvertField(targetField = "orgCode")
    private String orgCode; // 组织编码
    private String settleType;
    @ConvertField(targetField = "contractCode")
    private String contractCode; // 合同编码
    @ConvertField(targetField = "projectCode")
    private String projectCode; // 项目编码
    @ConvertField(targetField = "partyaId")
    private Long customerId; // 合同甲方
    @ConvertField(targetField = "partyaName")
    private String customerName; // 合同甲方名称

    private List<OtherSettleDetailVO> otherSettleDetailList = new ArrayList<>(); // 其他收入合同结算明细
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="other-contract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }

    public BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    public void setSumSettleMny(BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }

    public BigDecimal getSumSettleTaxMny() {
        return sumSettleTaxMny;
    }

    public void setSumSettleTaxMny(BigDecimal sumSettleTaxMny) {
        this.sumSettleTaxMny = sumSettleTaxMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public BigDecimal getSumSettleRate() {
        return sumSettleRate;
    }

    public void setSumSettleRate(BigDecimal sumSettleRate) {
        this.sumSettleRate = sumSettleRate;
    }

    public BigDecimal getTotalSettleMny() {
        return totalSettleMny;
    }

    public void setTotalSettleMny(BigDecimal totalSettleMny) {
        this.totalSettleMny = totalSettleMny;
    }

    public BigDecimal getTotalSettleTaxMny() {
        return totalSettleTaxMny;
    }

    public void setTotalSettleTaxMny(BigDecimal totalSettleTaxMny) {
        this.totalSettleTaxMny = totalSettleTaxMny;
    }

    public BigDecimal getTotalSettleRate() {
        return totalSettleRate;
    }

    public void setTotalSettleRate(BigDecimal totalSettleRate) {
        this.totalSettleRate = totalSettleRate;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public List<OtherSettleDetailVO> getOtherSettleDetailList() {
        return otherSettleDetailList;
    }

    public void setOtherSettleDetailList(List<OtherSettleDetailVO> otherSettleDetailList) {
        this.otherSettleDetailList = otherSettleDetailList;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getSettleType() {
        return settleType;
    }

    public void setSettleType(String settleType) {
        this.settleType = settleType;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getCustomerId() {
        return customerId;
    }
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
}
